/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.rule;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.type.XmlSchemaExternalType;
import org.raml.v2.internal.utils.SchemaGenerator;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;
import org.xml.sax.SAXException;

public class XmlSchemaValidationRule
extends Rule {
    private Schema schema;
    private String type;

    public XmlSchemaValidationRule(XmlSchemaExternalType schemaNode, ResourceLoader resourceLoader) {
        try {
            this.schema = SchemaGenerator.generateXmlSchema(resourceLoader, schemaNode);
            this.type = schemaNode.getInternalFragment();
        }
        catch (SAXException e) {
            this.schema = null;
        }
    }

    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Lists.newArrayList();
    }

    public boolean matches(@Nonnull Node node) {
        return node instanceof StringNode;
    }

    @Nonnull
    public Node apply(@Nonnull Node node) {
        if (this.schema == null) {
            return ErrorNodeFactory.createInvalidXmlExampleNode((String)"Invalid XmlSchema");
        }
        if (node instanceof SimpleTypeNode) {
            return this.validateXmlExample(node);
        }
        return node;
    }

    private Node validateXmlExample(@Nonnull Node node) {
        String value = ((SimpleTypeNode)node).getLiteralValue();
        try {
            QName rootElement;
            if (this.type != null && (rootElement = this.getRootElement(value)) != null && !rootElement.getLocalPart().equals(this.type)) {
                return ErrorNodeFactory.createInvalidXmlExampleNode((String)("Provided object is not of type " + this.type));
            }
            this.schema.newValidator().validate(new StreamSource(new StringReader(value)));
        }
        catch (IOException | XMLStreamException | SAXException e) {
            return ErrorNodeFactory.createInvalidXmlExampleNode((String)e.getMessage());
        }
        return node;
    }

    @Nullable
    public QName getRootElement(String xmlContent) throws XMLStreamException {
        XMLInputFactory f = XMLInputFactory.newInstance();
        XMLStreamReader r = f.createXMLStreamReader(new StringReader(xmlContent));
        r.nextTag();
        return r.getName();
    }

    public String getDescription() {
        return "Xml Schema validation Rule.";
    }
}

