/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.math.BigInteger;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.IntegerValue;

public class BigRangeIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator {
    BigInteger start;
    BigInteger currentValue;
    BigInteger limit;

    public BigRangeIterator(BigInteger start, BigInteger end) throws XPathException {
        if (end.subtract(start).compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new XPathException("Saxon limit on sequence length exceeded (2^32-1)");
        }
        this.start = start;
        this.currentValue = start.subtract(BigInteger.valueOf(1L));
        this.limit = end;
    }

    public boolean hasNext() {
        return this.currentValue.compareTo(this.limit) < 0;
    }

    public IntegerValue next() {
        this.currentValue = this.currentValue.add(BigInteger.valueOf(1L));
        if (this.currentValue.compareTo(this.limit) > 0) {
            return null;
        }
        return IntegerValue.makeIntegerValue(this.currentValue);
    }

    public void close() {
    }

    public int getLength() {
        BigInteger len = this.limit.subtract(this.start).add(BigInteger.valueOf(1L));
        if (len.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new UncheckedXPathException(new XPathException("Sequence exceeds Saxon limit (32-bit integer)"));
        }
        return len.intValue();
    }

    public SequenceIterator getAnother() throws XPathException {
        return new BigRangeIterator(this.start, this.limit);
    }

    public int getProperties() {
        return 6;
    }
}

