/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.requestreply;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.buffer.BoundedFifoBuffer;
import org.mule.DefaultMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessageCollection;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.RequestReplyRequesterMessageProcessor;
import org.mule.api.routing.ResponseTimeoutException;
import org.mule.api.source.MessageSource;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.RoutingNotification;
import org.mule.processor.AbstractInterceptingMessageProcessorBase;
import org.mule.routing.EventProcessingThread;
import org.mule.util.ObjectUtils;
import org.mule.util.concurrent.Latch;
import org.mule.util.concurrent.ThreadNameHelper;
import org.mule.util.store.DeserializationPostInitialisable;

public abstract class AbstractAsyncRequestReplyRequester
extends AbstractInterceptingMessageProcessorBase
implements RequestReplyRequesterMessageProcessor,
FlowConstructAware,
Initialisable,
Startable,
Stoppable,
Disposable {
    public static final int MAX_PROCESSED_GROUPS = 50000;
    public static final int UNCLAIMED_TIME_TO_LIVE = 60000;
    public static int UNCLAIMED_INTERVAL = 60000;
    public static final String NAME_TEMPLATE = "%s.%s.%s.asyncReplies";
    protected String name;
    protected volatile long timeout = -1L;
    protected volatile boolean failOnTimeout = true;
    protected MessageSource replyMessageSource;
    protected FlowConstruct flowConstruct;
    private final MessageProcessor internalAsyncReplyMessageProcessor = new InternalAsyncReplyMessageProcessor();
    private AsyncReplyMonitoringThread replyThread;
    protected final Map<String, Latch> locks = new ConcurrentHashMap<String, Latch>();
    private String storePrefix = "";
    protected final ConcurrentMap<String, MuleEvent> responseEvents = new ConcurrentHashMap<String, MuleEvent>();
    protected final Object processedLock = new Object();
    protected final BoundedFifoBuffer processed = new BoundedFifoBuffer(50000);
    protected ListableObjectStore store;

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.replyMessageSource == null) {
            return this.processNext(event);
        }
        this.locks.put(this.getAsyncReplyCorrelationId(event), this.createEventLock());
        this.sendAsyncRequest(event);
        MuleEvent resultEvent = this.receiveAsyncReply(event);
        if (resultEvent != null) {
            if (resultEvent.getMessage().getInboundProperty("MULE_SESSION") != null) {
                event.getSession().merge(resultEvent.getSession());
            }
            resultEvent = RequestContext.setEvent(new DefaultMuleEvent(resultEvent.getMessage(), event));
        }
        return resultEvent;
    }

    protected Latch createEventLock() {
        return new Latch();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }

    @Override
    public void setReplySource(MessageSource messageSource) {
        this.verifyReplyMessageSource(messageSource);
        this.replyMessageSource = messageSource;
        messageSource.setListener(this.internalAsyncReplyMessageProcessor);
    }

    @Override
    public void initialise() throws InitialisationException {
        this.name = String.format(NAME_TEMPLATE, this.storePrefix, ThreadNameHelper.getPrefix(this.muleContext), this.flowConstruct == null ? "" : this.flowConstruct.getName());
        this.store = (ListableObjectStore)((ObjectStoreManager)this.muleContext.getRegistry().get("_muleObjectStoreManager")).getObjectStore(this.name, false, 50000, 60000, UNCLAIMED_INTERVAL);
    }

    @Override
    public void start() throws MuleException {
        this.replyThread = new AsyncReplyMonitoringThread(this.name);
        this.replyThread.start();
    }

    @Override
    public void stop() throws MuleException {
        if (this.replyThread != null) {
            this.replyThread.stopProcessing();
        }
    }

    @Override
    public void dispose() {
        if (this.store != null) {
            try {
                ((ObjectStoreManager)this.muleContext.getRegistry().get("_muleObjectStoreManager")).disposeStore(this.store);
            }
            catch (ObjectStoreException e) {
                this.logger.debug((Object)"Exception disposingg of store", (Throwable)e);
            }
        }
    }

    public void setStorePrefix(String storePrefix) {
        this.storePrefix = storePrefix;
    }

    protected void verifyReplyMessageSource(MessageSource messageSource) {
    }

    protected String getAsyncReplyCorrelationId(MuleEvent event) {
        String correlationId = "";
        correlationId = event.getMessage() instanceof MuleMessageCollection ? event.getMessage().getCorrelationId() : event.getFlowConstruct().getMessageInfoMapping().getCorrelationId(event.getMessage());
        if (event.getMessage().getCorrelationSequence() > 0) {
            correlationId = correlationId + event.getMessage().getCorrelationSequence();
        }
        return correlationId;
    }

    protected void sendAsyncRequest(MuleEvent event) throws MuleException {
        this.processNext(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MuleEvent receiveAsyncReply(MuleEvent event) throws MessagingException {
        MuleEvent result;
        boolean resultAvailable;
        String asyncReplyCorrelationId;
        block12: {
            asyncReplyCorrelationId = this.getAsyncReplyCorrelationId(event);
            Latch asyncReplyLatch = this.locks.get(asyncReplyCorrelationId);
            boolean interruptedWhileWaiting = false;
            resultAvailable = false;
            result = null;
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Waiting for async reply message with id: " + asyncReplyCorrelationId));
                }
                if (this.timeout <= 0L) {
                    asyncReplyLatch.await();
                    resultAvailable = true;
                } else {
                    resultAvailable = asyncReplyLatch.await(this.timeout, TimeUnit.MILLISECONDS);
                }
                if (!resultAvailable) {
                    this.postLatchAwait(asyncReplyCorrelationId);
                    asyncReplyLatch.await(1000L, TimeUnit.MILLISECONDS);
                    resultAvailable = asyncReplyLatch.getCount() == 0L;
                }
            }
            catch (InterruptedException e) {
                interruptedWhileWaiting = true;
                return interruptedWhileWaiting;
            }
            finally {
                this.locks.remove(asyncReplyCorrelationId);
                result = (MuleEvent)this.responseEvents.remove(asyncReplyCorrelationId);
                if (!interruptedWhileWaiting) break block12;
                Thread.currentThread().interrupt();
                return null;
            }
        }
        if (resultAvailable) {
            if (result == null) {
                throw new IllegalStateException("Response MuleEvent is null");
            }
            return OptimizedRequestContext.criticalSetEvent(result);
        }
        this.addProcessed(asyncReplyCorrelationId);
        if (this.failOnTimeout) {
            event.getMuleContext().fireNotification(new RoutingNotification(event.getMessage(), null, 1302));
            throw new ResponseTimeoutException(CoreMessages.responseTimedOutWaitingForId((int)this.timeout, asyncReplyCorrelationId), event, null);
        }
        return null;
    }

    protected void postLatchAwait(String asyncReplyCorrelationId) throws MessagingException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProcessed(Object id) {
        Object object = this.processedLock;
        synchronized (object) {
            if (this.processed.isFull()) {
                this.processed.remove();
            }
            this.processed.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAlreadyProcessed(Object id) {
        Object object = this.processedLock;
        synchronized (object) {
            return this.processed.contains(id);
        }
    }

    @Override
    public String toString() {
        return ObjectUtils.toString(this);
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    private class AsyncReplyMonitoringThread
    extends EventProcessingThread {
        AsyncReplyMonitoringThread(String name) {
            super(name, 100L);
        }

        @Override
        protected void doRun() {
            try {
                List<Serializable> ids = AbstractAsyncRequestReplyRequester.this.store.allKeys();
                this.logger.debug((Object)("Found " + ids.size() + " objects in store"));
                for (Serializable id : ids) {
                    try {
                        boolean deleteEvent = false;
                        String correlationId = (String)((Object)id);
                        if (AbstractAsyncRequestReplyRequester.this.isAlreadyProcessed(correlationId)) {
                            deleteEvent = true;
                            MuleEvent event = (MuleEvent)AbstractAsyncRequestReplyRequester.this.store.retrieve((Serializable)((Object)correlationId));
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("An event was received for an event group that has already been processed, this is probably because the async-reply timed out. Correlation Id is: " + correlationId + ". Dropping event"));
                            }
                            event.getMuleContext().fireNotification(new RoutingNotification(event.getMessage(), event.getMessageSourceURI().toString(), 1301));
                        } else {
                            Latch l = AbstractAsyncRequestReplyRequester.this.locks.get(correlationId);
                            if (l != null) {
                                MuleEvent event = this.retrieveEvent(correlationId);
                                MuleEvent previousResult = AbstractAsyncRequestReplyRequester.this.responseEvents.putIfAbsent(correlationId, event);
                                if (previousResult != null) {
                                    throw new IllegalStateException("Detected duplicate result message with id: " + correlationId);
                                }
                                AbstractAsyncRequestReplyRequester.this.addProcessed(correlationId);
                                deleteEvent = true;
                                l.countDown();
                            }
                        }
                        if (!deleteEvent) continue;
                        AbstractAsyncRequestReplyRequester.this.store.remove((Serializable)((Object)correlationId));
                    }
                    catch (Exception ex) {
                        this.logger.debug((Object)"Error processing async replies", (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                this.logger.debug((Object)"Error processing async replies", (Throwable)ex);
            }
        }

        private MuleEvent retrieveEvent(String correlationId) throws ObjectStoreException, DefaultMuleException {
            MuleEvent event = (MuleEvent)AbstractAsyncRequestReplyRequester.this.store.retrieve((Serializable)((Object)correlationId));
            if (event.getMuleContext() == null) {
                try {
                    DeserializationPostInitialisable.Implementation.init(event, AbstractAsyncRequestReplyRequester.this.muleContext);
                }
                catch (Exception e) {
                    throw new DefaultMuleException(e);
                }
            }
            return event;
        }
    }

    class InternalAsyncReplyMessageProcessor
    implements MessageProcessor {
        InternalAsyncReplyMessageProcessor() {
        }

        @Override
        public MuleEvent process(MuleEvent event) throws MuleException {
            String messageId = AbstractAsyncRequestReplyRequester.this.getAsyncReplyCorrelationId(event);
            AbstractAsyncRequestReplyRequester.this.store.store((Serializable)((Object)messageId), event);
            AbstractAsyncRequestReplyRequester.this.replyThread.processNow();
            return null;
        }
    }
}

