/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.MessageRequester;
import org.mule.api.transport.PropertyScope;
import org.mule.api.transport.ReceiveException;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.transport.AbstractTransportMessageHandler;
import org.mule.transport.ConnectableLifecycleManager;
import org.mule.transport.NullPayload;

public abstract class AbstractMessageRequester
extends AbstractTransportMessageHandler
implements MessageRequester {
    private List<Transformer> defaultInboundTransformers;

    public AbstractMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
    }

    protected ConnectableLifecycleManager createLifecycleManager() {
        return new ConnectableLifecycleManager<AbstractMessageRequester>(this.getRequesterName(), this);
    }

    @Override
    public final void initialise() throws InitialisationException {
        this.defaultInboundTransformers = this.connector.getDefaultInboundTransformers(this.endpoint);
        super.initialise();
    }

    protected String getRequesterName() {
        return this.getConnector().getName() + ".requester." + System.identityHashCode(this);
    }

    @Override
    public final MuleMessage request(long timeout) throws Exception {
        try {
            EndpointMessageNotification beginNotification = null;
            if (this.connector.isEnableMessageEvents()) {
                DefaultMuleMessage dummyMessage = new DefaultMuleMessage(NullPayload.getInstance(), this.endpoint.getMuleContext());
                beginNotification = new EndpointMessageNotification((MuleMessage)dummyMessage, this.endpoint, null, 804);
            }
            this.connect();
            MuleMessage result = null;
            result = this.doRequest(timeout);
            if (result != null) {
                String rootId = (String)result.getInboundProperty("MULE_ROOT_MESSAGE_ID");
                if (rootId != null) {
                    result.setMessageRootId(rootId);
                    result.removeProperty("MULE_ROOT_MESSAGE_ID", PropertyScope.INBOUND);
                }
                if (beginNotification != null) {
                    result.propagateRootId(beginNotification.getSource());
                }
                if (!this.endpoint.isDisableTransportTransformer()) {
                    this.applyInboundTransformers(result);
                }
                if (beginNotification != null) {
                    this.connector.fireNotification(beginNotification);
                    this.connector.fireNotification(new EndpointMessageNotification(result, this.endpoint, null, 853));
                }
            }
            return result;
        }
        catch (ReceiveException e) {
            this.disposeAndLogException();
            throw e;
        }
        catch (Exception e) {
            this.disposeAndLogException();
            throw new ReceiveException(this.endpoint, timeout, e);
        }
    }

    protected void applyInboundTransformers(MuleMessage message) throws MuleException {
        message.applyTransformers(null, this.defaultInboundTransformers);
    }

    @Override
    protected WorkManager getWorkManager() throws MuleException {
        return this.connector.getRequesterWorkManager();
    }

    @Override
    public InboundEndpoint getEndpoint() {
        return (InboundEndpoint)super.getEndpoint();
    }

    protected abstract MuleMessage doRequest(long var1) throws Exception;
}

