/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.oauth2.internal.authorizationcode;

import java.util.HashMap;
import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.oauth2.internal.AbstractTokenRequestHandler;
import org.mule.module.oauth2.internal.MuleEventLogger;
import org.mule.module.oauth2.internal.StateDecoder;
import org.mule.module.oauth2.internal.TokenNotFoundException;
import org.mule.module.oauth2.internal.TokenResponseProcessor;
import org.mule.module.oauth2.internal.authorizationcode.AbstractAuthorizationCodeTokenRequestHandler;
import org.mule.module.oauth2.internal.authorizationcode.TokenResponseConfiguration;
import org.mule.module.oauth2.internal.authorizationcode.state.ResourceOwnerOAuthContext;
import org.mule.util.StringUtils;

public class AutoAuthorizationCodeTokenRequestHandler
extends AbstractAuthorizationCodeTokenRequestHandler {
    public static final String AUTHORIZATION_STATUS_QUERY_PARAM_KEY = "authorizationStatus";
    public static final int NO_AUTHORIZATION_CODE_STATUS = 100;
    public static final int TOKEN_URL_CALL_FAILED_STATUS = 200;
    public static final int TOKEN_NOT_FOUND_STATUS = 201;
    public static final int FAILURE_PROCESSING_REDIRECT_URL_REQUEST_STATUS = 300;
    private TokenResponseConfiguration tokenResponseConfiguration = new TokenResponseConfiguration();
    private MuleEventLogger muleEventLogger = new MuleEventLogger(this.logger);

    public void setTokenResponseConfiguration(TokenResponseConfiguration tokenResponseConfiguration) {
        this.tokenResponseConfiguration = tokenResponseConfiguration;
    }

    @Override
    public void init() throws MuleException {
        this.createListenerForRedirectUrl();
    }

    @Override
    protected MessageProcessor createRedirectUrlProcessor() {
        return new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                int authorizationStatus = 0;
                int statusCodeToReturn = HttpConstants.HttpStatus.OK.getStatusCode();
                String responseMessage = "Successfully retrieved access token";
                Map queryParams = (Map)event.getMessage().getInboundProperty("http.query.params");
                String state = (String)queryParams.get("state");
                StateDecoder stateDecoder = new StateDecoder(state);
                try {
                    String authorizationCode = AutoAuthorizationCodeTokenRequestHandler.this.processAuthorizationCode(event);
                    if (AutoAuthorizationCodeTokenRequestHandler.this.logger.isDebugEnabled()) {
                        AutoAuthorizationCodeTokenRequestHandler.this.logger.debug("Redirect url request state: " + state);
                        AutoAuthorizationCodeTokenRequestHandler.this.logger.debug("Redirect url request code: " + authorizationCode);
                    }
                    MuleEvent tokenUrlResponse = AutoAuthorizationCodeTokenRequestHandler.this.callTokenUrl(event, authorizationCode);
                    String decodedState = stateDecoder.decodeOriginalState();
                    String encodedResourceOwnerId = stateDecoder.decodeResourceOwnerId();
                    String resourceOwnerId = encodedResourceOwnerId == null ? "default" : encodedResourceOwnerId;
                    ResourceOwnerOAuthContext resourceOwnerOAuthContext = AutoAuthorizationCodeTokenRequestHandler.this.getOauthConfig().getUserOAuthContext().getContextForResourceOwner(resourceOwnerId);
                    AutoAuthorizationCodeTokenRequestHandler.this.logResourceOwnerOAuthContextBeforeUpdate(resourceOwnerOAuthContext);
                    TokenResponseProcessor tokenResponseProcessor = AutoAuthorizationCodeTokenRequestHandler.this.processTokenUrlResponse(tokenUrlResponse);
                    AutoAuthorizationCodeTokenRequestHandler.this.updateResourceOwnerState(resourceOwnerOAuthContext, decodedState, tokenResponseProcessor);
                    AutoAuthorizationCodeTokenRequestHandler.this.getOauthConfig().getUserOAuthContext().updateResourceOwnerOAuthContext(resourceOwnerOAuthContext);
                }
                catch (NoAuthorizationCodeException e) {
                    AutoAuthorizationCodeTokenRequestHandler.this.logger.error("Could not extract authorization code from OAuth provider HTTP request done to the redirect URL");
                    AutoAuthorizationCodeTokenRequestHandler.this.muleEventLogger.logContent(event);
                    authorizationStatus = 100;
                    statusCodeToReturn = HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode();
                    responseMessage = "Failure retrieving access token.\n OAuth Server uri from callback: " + event.getMessage().getInboundProperty("http.request.uri");
                }
                catch (AbstractTokenRequestHandler.TokenUrlResponseException e) {
                    AutoAuthorizationCodeTokenRequestHandler.this.logger.error(String.format("HTTP response from token URL %s returned a failure status code", AutoAuthorizationCodeTokenRequestHandler.this.getTokenUrl()));
                    AutoAuthorizationCodeTokenRequestHandler.this.muleEventLogger.logContent(e.getTokenUrlResponse());
                    authorizationStatus = 200;
                    statusCodeToReturn = HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode();
                    responseMessage = String.format("Failure calling token url %s. Exception message is %s", AutoAuthorizationCodeTokenRequestHandler.this.getTokenUrl(), e.getMessage());
                }
                catch (TokenNotFoundException e) {
                    AutoAuthorizationCodeTokenRequestHandler.this.logger.error(String.format("Could not extract access token from token URL. Access token is %s, Refresh token is %s", e.getTokenResponseProcessor().getAccessToken(), StringUtils.isBlank((String)e.getTokenResponseProcessor().getRefreshToken()) ? "(Not issued)" : e.getTokenResponseProcessor().getRefreshToken()));
                    AutoAuthorizationCodeTokenRequestHandler.this.muleEventLogger.logContent(e.getTokenUrlResponse());
                    authorizationStatus = 201;
                    statusCodeToReturn = HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode();
                    responseMessage = "Failed getting access token or refresh token from token URL response. See logs for details.";
                }
                catch (MuleException e) {
                    AutoAuthorizationCodeTokenRequestHandler.this.logger.error("Fail processing redirect URL request", (Throwable)e);
                    authorizationStatus = 300;
                    statusCodeToReturn = HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode();
                    responseMessage = "Failed processing redirect URL request done from OAuth provider. See logs for details.";
                }
                event.getMessage().setPayload((Object)responseMessage);
                event.getMessage().setOutboundProperty("http.status", (Object)statusCodeToReturn);
                String onCompleteRedirectToValue = stateDecoder.decodeOnCompleteRedirectTo();
                if (!org.springframework.util.StringUtils.isEmpty((Object)onCompleteRedirectToValue)) {
                    event.getMessage().setOutboundProperty("http.status", (Object)HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode());
                    event.getMessage().setOutboundProperty("Location", (Object)HttpParser.appendQueryParam((String)onCompleteRedirectToValue, (String)AutoAuthorizationCodeTokenRequestHandler.AUTHORIZATION_STATUS_QUERY_PARAM_KEY, (String)String.valueOf(authorizationStatus)));
                }
                return event;
            }
        };
    }

    private MuleEvent callTokenUrl(MuleEvent event, String authorizationCode) throws MuleException, AbstractTokenRequestHandler.TokenUrlResponseException {
        this.setMapPayloadWithTokenRequestParameters(event, authorizationCode);
        return this.invokeTokenUrl(event);
    }

    private String processAuthorizationCode(MuleEvent event) throws NoAuthorizationCodeException {
        Map queryParams = (Map)event.getMessage().getInboundProperty("http.query.params");
        String authorizationCode = (String)queryParams.get("code");
        if (authorizationCode == null) {
            this.logger.info("HTTP Request to redirect URL done by the OAuth provider does not contains a code query parameter. Code query parameter is required to get the access token.");
            throw new NoAuthorizationCodeException();
        }
        return authorizationCode;
    }

    private boolean tokenResponseContentIsValid(TokenResponseProcessor tokenResponseProcessor) {
        return tokenResponseProcessor.getAccessToken() != null;
    }

    private void setMapPayloadWithTokenRequestParameters(MuleEvent event, String authorizationCode) {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("code", authorizationCode);
        formData.put("client_id", this.getOauthConfig().getClientId());
        formData.put("client_secret", this.getOauthConfig().getClientSecret());
        formData.put("grant_type", "authorization_code");
        formData.put("redirect_uri", this.getOauthConfig().getRedirectionUrl());
        event.getMessage().setPayload(formData);
    }

    private void setMapPayloadWithRefreshTokenRequestParameters(MuleEvent event, String refreshToken) {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("refresh_token", refreshToken);
        formData.put("client_id", this.getOauthConfig().getClientId());
        formData.put("client_secret", this.getOauthConfig().getClientSecret());
        formData.put("grant_type", "refresh_token");
        formData.put("redirect_uri", this.getOauthConfig().getRedirectionUrl());
        event.getMessage().setPayload(formData);
    }

    private void logResourceOwnerOAuthContextBeforeUpdate(ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Update OAuth Context for resourceOwnerId %s", (Object)resourceOwnerOAuthContext.getResourceOwnerId());
        }
    }

    private TokenResponseProcessor processTokenUrlResponse(MuleEvent tokenUrlResponse) throws TokenNotFoundException {
        TokenResponseProcessor tokenResponseProcessor = TokenResponseProcessor.createAuthorizationCodeProcessor(this.tokenResponseConfiguration, this.getMuleContext().getExpressionManager());
        tokenResponseProcessor.process(tokenUrlResponse);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Retrieved access token, refresh token and expires from token url are: %s, %s, %s", new Object[]{tokenResponseProcessor.getAccessToken(), tokenResponseProcessor.getRefreshToken(), tokenResponseProcessor.getExpiresIn()});
        }
        if (!this.tokenResponseContentIsValid(tokenResponseProcessor)) {
            throw new TokenNotFoundException(tokenUrlResponse, tokenResponseProcessor);
        }
        return tokenResponseProcessor;
    }

    private void updateResourceOwnerState(ResourceOwnerOAuthContext resourceOwnerOAuthContext, String newState, TokenResponseProcessor tokenResponseProcessor) {
        resourceOwnerOAuthContext.setAccessToken(tokenResponseProcessor.getAccessToken());
        if (tokenResponseProcessor.getRefreshToken() != null) {
            resourceOwnerOAuthContext.setRefreshToken(tokenResponseProcessor.getRefreshToken());
        }
        resourceOwnerOAuthContext.setExpiresIn(tokenResponseProcessor.getExpiresIn());
        if (newState != null) {
            resourceOwnerOAuthContext.setState(newState);
        }
        Map<String, Object> customResponseParameters = tokenResponseProcessor.getCustomResponseParameters();
        for (String paramName : customResponseParameters.keySet()) {
            Object paramValue = customResponseParameters.get(paramName);
            if (paramValue == null) continue;
            resourceOwnerOAuthContext.getTokenResponseParameters().put(paramName, paramValue);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("New OAuth State for resourceOwnerId %s is: accessToken(%s), refreshToken(%s), expiresIn(%s), state(%s)", new Object[]{resourceOwnerOAuthContext.getResourceOwnerId(), resourceOwnerOAuthContext.getAccessToken(), StringUtils.isBlank((String)resourceOwnerOAuthContext.getRefreshToken()) ? "Not issued" : resourceOwnerOAuthContext.getRefreshToken(), resourceOwnerOAuthContext.getExpiresIn(), resourceOwnerOAuthContext.getState()});
        }
    }

    @Override
    public void doRefreshToken(MuleEvent currentEvent, ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        try {
            MuleEvent muleEvent = DefaultMuleEvent.copy((MuleEvent)currentEvent);
            muleEvent.getMessage().clearProperties(PropertyScope.OUTBOUND);
            String userRefreshToken = resourceOwnerOAuthContext.getRefreshToken();
            if (userRefreshToken == null) {
                throw new DefaultMuleException(CoreMessages.createStaticMessage((String)"The user with user id %s has no refresh token in his OAuth state so we can't execute the refresh token call", (Object[])new Object[]{resourceOwnerOAuthContext.getResourceOwnerId()}));
            }
            this.setMapPayloadWithRefreshTokenRequestParameters(muleEvent, userRefreshToken);
            MuleEvent refreshTokenResponse = this.invokeTokenUrl(muleEvent);
            this.logResourceOwnerOAuthContextBeforeUpdate(resourceOwnerOAuthContext);
            TokenResponseProcessor tokenResponseProcessor = this.processTokenUrlResponse(refreshTokenResponse);
            this.updateResourceOwnerState(resourceOwnerOAuthContext, null, tokenResponseProcessor);
        }
        catch (TokenNotFoundException e) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)"Access token was not found from the refresh token oauth call"), (Throwable)e);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private class NoAuthorizationCodeException
    extends Exception {
        private NoAuthorizationCodeException() {
        }
    }
}

