/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ftp;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.apache.commons.net.ftp.FTPReply;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.ftp.FtpConnector;
import org.mule.transport.ftp.FtpMuleMessageFactory;

public class FtpMessageRequester
extends AbstractMessageRequester {
    private static final int FTP_LIST_PAGE_SIZE = 25;
    protected final FtpConnector connector;

    public FtpMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (FtpConnector)endpoint.getConnector();
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
        try {
            EndpointURI uri = this.endpoint.getEndpointURI();
            FTPClient client = this.connector.getFtp(uri);
            this.connector.destroyFtp(uri, client);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MuleMessage doRequest(long timeout) throws Exception {
        FTPClient client = null;
        try {
            FTPFile fileToProcess;
            client = this.connector.createFtpClient(this.endpoint);
            if (this.connector.isFile(this.endpoint, client)) {
                fileToProcess = client.listFiles(this.endpoint.getEndpointURI().getPath())[0];
                if (!this.isValid(fileToProcess, this.getFilenameFilter())) {
                    MuleMessage muleMessage = null;
                    return muleMessage;
                }
            } else {
                fileToProcess = this.findFileToProcess(client);
                if (fileToProcess == null) {
                    MuleMessage muleMessage = null;
                    return muleMessage;
                }
            }
            fileToProcess = this.prepareFile(client, fileToProcess);
            FtpMuleMessageFactory messageFactory = this.createMuleMessageFactory(client);
            MuleMessage message = messageFactory.create(fileToProcess, this.endpoint.getEncoding(), this.endpoint.getMuleContext());
            this.postProcess(client, fileToProcess, message);
            MuleMessage muleMessage = message;
            return muleMessage;
        }
        finally {
            this.connector.releaseFtp(this.endpoint.getEndpointURI(), client);
        }
    }

    protected void postProcess(FTPClient client, FTPFile file, MuleMessage message) throws Exception {
        if (!this.connector.isStreaming()) {
            if (!client.deleteFile(file.getName())) {
                throw new IOException(MessageFormat.format("Failed to delete file {0}. Ftp error: {1}", file.getName(), client.getReplyCode()));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Deleted file " + file.getName()));
            }
        }
    }

    protected void initializeMessageFactory() throws InitialisationException {
    }

    protected FtpMuleMessageFactory createMuleMessageFactory(FTPClient client) throws CreateException {
        FtpMuleMessageFactory factory = (FtpMuleMessageFactory)this.createMuleMessageFactory();
        factory.setStreaming(false);
        factory.setFtpClient(client);
        return factory;
    }

    protected FTPFile prepareFile(FTPClient client, FTPFile file) throws IOException {
        return file;
    }

    protected FTPFile findFileToProcess(FTPClient client) throws Exception {
        boolean isFile = this.connector.isFile(this.endpoint, client);
        FTPListParseEngine engine = client.initiateListParsing();
        FTPFile[] files = null;
        while (engine.hasNext() && (files = engine.getNext(25)) != null) {
            FilenameFilter filenameFilter = this.getFilenameFilter();
            for (int i = 0; i < files.length; ++i) {
                FTPFile file = files[i];
                if (!file.isFile() || !this.isValid(file, filenameFilter)) continue;
                return file;
            }
        }
        if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
            throw new IOException("Ftp error: " + client.getReplyCode());
        }
        return null;
    }

    protected boolean isValid(FTPFile file, FilenameFilter filenameFilter) {
        return filenameFilter.accept(null, file.getName()) && this.connector.validateFile(file);
    }

    protected FTPFile[] listFiles(FTPClient client) throws IOException {
        return null;
    }

    protected FilenameFilter getFilenameFilter() {
        if (this.endpoint.getFilter() instanceof FilenameFilter) {
            return (FilenameFilter)this.endpoint.getFilter();
        }
        return new AcceptAllFilenameFilter();
    }

    private static class AcceptAllFilenameFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return true;
        }
    }
}

