/*
 * Decompiled with CFR 0.152.
 */
package mx4j.timer;

import java.util.ArrayList;
import java.util.Collections;
import mx4j.timer.TimeTask;

public class TimeQueue {
    private Thread thread;
    private volatile boolean running;
    private final ArrayList tasks = new ArrayList();
    private final boolean daemon;

    public TimeQueue() {
        this(false);
    }

    public TimeQueue(boolean daemon) {
        this.daemon = daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        TimeQueue timeQueue = this;
        synchronized (timeQueue) {
            if (!this.running) {
                this.running = true;
                this.thread = new Thread((Runnable)new Loop(), "MBean Timer Notification Thread");
                this.thread.setDaemon(this.daemon);
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        TimeQueue timeQueue = this;
        synchronized (timeQueue) {
            if (this.running) {
                this.running = false;
                this.thread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        TimeQueue timeQueue = this;
        synchronized (timeQueue) {
            return this.tasks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(TimeTask task) {
        TimeQueue timeQueue = this;
        synchronized (timeQueue) {
            this.tasks.add(task);
            Collections.sort(this.tasks);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unschedule(TimeTask task) {
        TimeQueue timeQueue = this;
        synchronized (timeQueue) {
            this.tasks.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        TimeQueue timeQueue = this;
        synchronized (timeQueue) {
            this.tasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimeTask getTask() throws InterruptedException {
        TimeQueue timeQueue = this;
        synchronized (timeQueue) {
            while (this.tasks.isEmpty()) {
                this.wait();
            }
            TimeTask task = (TimeTask)this.tasks.get(0);
            return task;
        }
    }

    private class Loop
    implements Runnable {
        private Loop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (TimeQueue.this.running && !TimeQueue.this.thread.isInterrupted()) {
                try {
                    long timeToWait;
                    boolean runTask;
                    TimeTask task = TimeQueue.this.getTask();
                    long now = System.currentTimeMillis();
                    long executionTime = task.getNextExecutionTime();
                    if (executionTime == 0L) {
                        executionTime = now;
                    }
                    boolean bl = runTask = (timeToWait = executionTime - now) <= 0L;
                    if (!runTask) {
                        TimeQueue lock;
                        TimeQueue timeQueue = lock = TimeQueue.this;
                        synchronized (timeQueue) {
                            lock.wait(timeToWait);
                            continue;
                        }
                    }
                    TimeQueue.this.unschedule(task);
                    if (task.isPeriodic()) {
                        if (task.getFixedRate()) {
                            task.setNextExecutionTime(executionTime + task.getPeriod());
                        } else {
                            task.setNextExecutionTime(now + task.getPeriod());
                        }
                        TimeQueue.this.schedule(task);
                    } else {
                        task.setFinished(true);
                    }
                    try {
                        task.run();
                    }
                    catch (Throwable x) {
                        x.printStackTrace();
                    }
                }
                catch (InterruptedException x) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }
}

