/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import java.util.ArrayList;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.MessageSource;
import org.mule.config.i18n.Message;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.construct.AbstractFlowConstuctTestCase;
import org.mule.construct.Flow;
import org.mule.processor.ResponseMessageProcessorAdapter;
import org.mule.processor.chain.DynamicMessageProcessorContainer;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.transformer.simple.StringAppendTransformer;
import org.mule.util.NotificationUtils;

public class FlowTestCase
extends AbstractFlowConstuctTestCase {
    private static final String FLOW_NAME = "test-flow";
    private Flow flow;
    private DynamicMessageProcessorContainer dynamicProcessorContainer;
    private SensingNullMessageProcessor sensingMessageProcessor;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.sensingMessageProcessor = this.getSensingNullMessageProcessor();
        this.flow = new Flow(FLOW_NAME, muleContext);
        this.flow.setMessageSource((MessageSource)this.directInboundMessageSource);
        this.dynamicProcessorContainer = (DynamicMessageProcessorContainer)Mockito.mock(DynamicMessageProcessorContainer.class);
        Mockito.when((Object)this.dynamicProcessorContainer.process((MuleEvent)Matchers.any(MuleEvent.class))).then((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return (MuleEvent)args[0];
            }
        });
        ArrayList<Object> processors = new ArrayList<Object>();
        processors.add(new ResponseMessageProcessorAdapter((MessageProcessor)new StringAppendTransformer("f")));
        processors.add(new ResponseMessageProcessorAdapter((MessageProcessor)new StringAppendTransformer("e")));
        processors.add(new ResponseMessageProcessorAdapter((MessageProcessor)new StringAppendTransformer("d")));
        processors.add(new StringAppendTransformer("a"));
        processors.add(new StringAppendTransformer("b"));
        processors.add(new StringAppendTransformer("c"));
        processors.add(this.dynamicProcessorContainer);
        processors.add(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setOutboundProperty("thread", (Object)Thread.currentThread());
                return event;
            }
        });
        processors.add((Object)this.sensingMessageProcessor);
        this.flow.setMessageProcessors(processors);
    }

    @Override
    protected AbstractFlowConstruct getFlowConstruct() throws Exception {
        return this.flow;
    }

    @Test
    public void testProcessOneWayEndpoint() throws Exception {
        this.flow.initialise();
        this.flow.start();
        MuleEvent response = this.directInboundMessageSource.process(MuleTestUtils.getTestEvent((Object)"hello", MessageExchangePattern.ONE_WAY, muleContext));
        Thread.sleep(50L);
        Assert.assertNull((Object)response);
        Assert.assertEquals((Object)"helloabc", (Object)this.sensingMessageProcessor.event.getMessageAsString());
        Assert.assertNotSame((Object)Thread.currentThread(), (Object)this.sensingMessageProcessor.event.getMessage().getOutboundProperty("thread"));
    }

    @Test
    public void testProcessRequestResponseEndpoint() throws Exception {
        this.flow.initialise();
        this.flow.start();
        MuleEvent response = this.directInboundMessageSource.process(MuleTestUtils.getTestEvent((Object)"hello", MessageExchangePattern.REQUEST_RESPONSE, muleContext));
        Assert.assertEquals((Object)"helloabcdef", (Object)response.getMessageAsString());
        Assert.assertEquals((Object)Thread.currentThread(), (Object)response.getMessage().getOutboundProperty("thread"));
        Assert.assertEquals((Object)"helloabcdef", (Object)this.sensingMessageProcessor.event.getMessageAsString());
        Assert.assertEquals((Object)Thread.currentThread(), (Object)this.sensingMessageProcessor.event.getMessage().getOutboundProperty("thread"));
    }

    @Test
    public void processorPath() throws MuleException {
        this.flow.initialise();
        this.flow.start();
        MessageProcessor processorInSubflow = new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return event;
            }
        };
        Assert.assertThat((Object)this.flow.getProcessorPath((MessageProcessor)this.sensingMessageProcessor), (Matcher)CoreMatchers.is((Object)"/test-flow/processors/8"));
        Assert.assertThat((Object)this.flow.getProcessorPath((MessageProcessor)this.dynamicProcessorContainer), (Matcher)CoreMatchers.is((Object)"/test-flow/processors/6"));
        Assert.assertThat((Object)this.flow.getProcessorPath(processorInSubflow), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Mockito.reset((Object[])new DynamicMessageProcessorContainer[]{this.dynamicProcessorContainer});
        NotificationUtils.FlowMap dynamicContainerFlowMap = (NotificationUtils.FlowMap)Mockito.mock(NotificationUtils.FlowMap.class);
        Mockito.when((Object)dynamicContainerFlowMap.resolvePath(processorInSubflow)).thenReturn((Object)"/sub_dyn/subprocessors/0");
        Mockito.when((Object)dynamicContainerFlowMap.getFlowMap()).thenReturn(Collections.singletonMap(processorInSubflow, "/sub_dyn/subprocessors/0"));
        Mockito.when((Object)this.dynamicProcessorContainer.buildInnerPaths()).thenReturn((Object)dynamicContainerFlowMap);
        Assert.assertThat((Object)this.flow.getProcessorPath(processorInSubflow), (Matcher)CoreMatchers.is((Object)"/sub_dyn/subprocessors/0"));
        ((DynamicMessageProcessorContainer)Mockito.verify((Object)this.dynamicProcessorContainer, (VerificationMode)Mockito.times((int)1))).buildInnerPaths();
        this.flow.getProcessorPath(processorInSubflow);
        ((DynamicMessageProcessorContainer)Mockito.verify((Object)this.dynamicProcessorContainer, (VerificationMode)Mockito.times((int)1))).buildInnerPaths();
    }

    @Test
    public void testProcessStopped() throws Exception {
        this.flow.initialise();
        try {
            this.directInboundMessageSource.process(MuleTestUtils.getTestEvent("hello", muleContext));
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSequentialStageNames() throws Exception {
        int count = 10;
        for (int i = 1; i <= 10; ++i) {
            Assert.assertTrue((boolean)this.flow.getAsyncStageNameSource().getName().endsWith("." + i));
        }
    }

    @Test
    public void testStageNameSourceWithName() throws Exception {
        int count = 10;
        String stageName = "myStage";
        String EXPECTED = String.format("%s.%s", FLOW_NAME, "myStage");
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)EXPECTED, (Object)this.flow.getAsyncStageNameSource("myStage").getName());
        }
    }

    @Test
    public void testDynamicPipeline() throws Exception {
        this.flow.initialise();
        this.flow.start();
        StringAppendTransformer appendPre = new StringAppendTransformer("1");
        StringAppendTransformer appendPost2 = new StringAppendTransformer("4");
        String pipelineId = this.flow.dynamicPipeline(null).injectBefore(new MessageProcessor[]{appendPre, new StringAppendTransformer("2")}).injectAfter(new MessageProcessor[]{new StringAppendTransformer("3"), appendPost2}).resetAndUpdate();
        MuleEvent response = this.directInboundMessageSource.process(MuleTestUtils.getTestEvent((Object)"hello", MessageExchangePattern.REQUEST_RESPONSE, muleContext));
        Assert.assertEquals((Object)"hello12abcdef34", (Object)response.getMessageAsString());
        this.flow.dynamicPipeline(pipelineId).injectBefore(new MessageProcessor[]{new StringAppendTransformer("2")}).injectAfter(new MessageProcessor[]{new StringAppendTransformer("3")}).resetAndUpdate();
        response = this.directInboundMessageSource.process(MuleTestUtils.getTestEvent((Object)"hello", MessageExchangePattern.REQUEST_RESPONSE, muleContext));
        Assert.assertEquals((Object)"hello2abcdef3", (Object)response.getMessageAsString());
        this.flow.dynamicPipeline(pipelineId).reset();
        response = this.directInboundMessageSource.process(MuleTestUtils.getTestEvent((Object)"hello", MessageExchangePattern.REQUEST_RESPONSE, muleContext));
        Assert.assertEquals((Object)"helloabcdef", (Object)response.getMessageAsString());
    }

    @Test
    public void testFailStartingMessageSourceOnLifecycleShouldStopStartedPipelineProcesses() throws Exception {
        MessageSource mockMessageSource = (MessageSource)Mockito.mock(MessageSource.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Startable.class, Stoppable.class}));
        ((Startable)Mockito.doThrow((Throwable)new LifecycleException((Message)Mockito.mock(Message.class), (Object)"Error starting component")).when((Object)((Startable)mockMessageSource))).start();
        this.flow.setMessageSource(mockMessageSource);
        MessageProcessor mockMessageProcessor = (MessageProcessor)Mockito.mock(MessageProcessor.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Startable.class, Stoppable.class}));
        this.flow.getMessageProcessors().add(mockMessageProcessor);
        this.flow.initialise();
        try {
            this.flow.start();
            Assert.fail();
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
        ((Startable)Mockito.verify((Object)((Startable)mockMessageProcessor), (VerificationMode)Mockito.times((int)1))).start();
        ((Stoppable)Mockito.verify((Object)((Stoppable)mockMessageProcessor), (VerificationMode)Mockito.times((int)1))).stop();
        ((Startable)Mockito.verify((Object)((Startable)mockMessageSource), (VerificationMode)Mockito.times((int)1))).start();
        ((Stoppable)Mockito.verify((Object)((Stoppable)mockMessageSource), (VerificationMode)Mockito.times((int)1))).stop();
    }
}

