/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.security.SecurityManager;
import org.mule.config.builders.DefaultsConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.notification.MuleContextNotification;
import org.mule.lifecycle.MuleContextLifecycleManager;
import org.mule.tck.MuleAssert;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.JdkVersionUtils;
import org.mule.util.UUID;
import org.mule.util.queue.QueueManager;

public class MuleContextLifecycleTestCase
extends AbstractMuleTestCase {
    private MuleContextBuilder ctxBuilder;
    private SensingLifecycleManager lifecycleManager;
    private MuleContext ctx;

    @Before
    public void setup() throws Exception {
        this.ctxBuilder = new DefaultMuleContextBuilder();
        this.lifecycleManager = new SensingLifecycleManager();
        this.ctxBuilder.setLifecycleManager((LifecycleManager)this.lifecycleManager);
        this.ctx = this.ctxBuilder.buildMuleContext();
    }

    @After
    public void tearDown() throws Exception {
        if (this.ctx != null && !this.ctx.isDisposed()) {
            this.ctx.dispose();
        }
    }

    @Test
    public void initaliseSuccessful() throws Exception {
        Assert.assertFalse((boolean)this.ctx.isInitialised());
        Assert.assertFalse((boolean)this.ctx.isInitialising());
        Assert.assertFalse((boolean)this.ctx.isStarted());
        Assert.assertFalse((boolean)this.ctx.isDisposed());
        Assert.assertFalse((boolean)this.ctx.isDisposing());
        this.ctx.initialise();
        Assert.assertTrue((boolean)this.ctx.isInitialised());
        Assert.assertFalse((boolean)this.ctx.isInitialising());
        Assert.assertFalse((boolean)this.ctx.isStarted());
        Assert.assertFalse((boolean)this.ctx.isDisposed());
        Assert.assertFalse((boolean)this.ctx.isDisposing());
    }

    @Test(expected=IllegalStateException.class)
    public void initialiseOnInitialised() throws MuleException {
        this.ctx.initialise();
        this.ctx.initialise();
    }

    @Test(expected=IllegalStateException.class)
    public void initialiseOnStarted() throws Exception {
        this.ctx.initialise();
        new DefaultsConfigurationBuilder().configure(this.ctx);
        this.ctx.start();
        this.ctx.initialise();
    }

    @Test(expected=IllegalStateException.class)
    public void initialiseOnStopped() throws Exception {
        this.ctx.initialise();
        new DefaultsConfigurationBuilder().configure(this.ctx);
        this.ctx.start();
        this.ctx.stop();
        this.ctx.initialise();
    }

    @Test(expected=IllegalStateException.class)
    public void initialiseOnDisposed() throws Exception {
        this.ctx.initialise();
        new DefaultsConfigurationBuilder().configure(this.ctx);
        this.ctx.start();
        this.ctx.stop();
        this.ctx.dispose();
        this.ctx.initialise();
    }

    @Test(expected=IllegalStateException.class)
    public void startBeforeInitialise() throws Exception {
        this.ctx.start();
    }

    @Test
    public void startOnInitialised() throws Exception {
        this.ctx.initialise();
        new DefaultsConfigurationBuilder().configure(this.ctx);
        NotificationListener listener = new NotificationListener();
        this.ctx.registerListener((ServerNotificationListener)listener);
        this.ctx.start();
        Assert.assertTrue((boolean)this.ctx.isInitialised());
        Assert.assertFalse((boolean)this.ctx.isInitialising());
        Assert.assertTrue((boolean)this.ctx.isStarted());
        Assert.assertFalse((boolean)this.ctx.isDisposed());
        Assert.assertFalse((boolean)this.ctx.isDisposing());
        MuleAssert.assertTrue("CONTEXT_STARTING notification never fired", listener.startingNotificationFired);
        MuleAssert.assertTrue("CONTEXT_STARTED notification never fired", listener.startedNotificationFired);
    }

    @Test(expected=IllegalStateException.class)
    public void startOnStarted() throws Exception {
        this.ctx.initialise();
        new DefaultsConfigurationBuilder().configure(this.ctx);
        NotificationListener listener = new NotificationListener();
        this.ctx.registerListener((ServerNotificationListener)listener);
        this.ctx.start();
        MuleAssert.assertTrue("CONTEXT_STARTING notification never fired", listener.startingNotificationFired);
        MuleAssert.assertTrue("CONTEXT_STARTED notification never fired", listener.startedNotificationFired);
        this.ctx.start();
    }

    @Test
    public void startOnStopped() throws Exception {
        this.ctx.initialise();
        new DefaultsConfigurationBuilder().configure(this.ctx);
        this.ctx.start();
        this.ctx.stop();
        this.ctx.start();
        Assert.assertTrue((boolean)this.ctx.isInitialised());
        Assert.assertFalse((boolean)this.ctx.isInitialising());
        Assert.assertTrue((boolean)this.ctx.isStarted());
        Assert.assertFalse((boolean)this.ctx.isDisposed());
        Assert.assertFalse((boolean)this.ctx.isDisposing());
    }

    @Test(expected=IllegalStateException.class)
    public void startOnDisposed() throws Exception {
        this.ctx.initialise();
        this.ctx.dispose();
        this.ctx.start();
    }

    @Test(expected=IllegalStateException.class)
    public void stopBeforeInitialise() throws Exception {
        this.ctx.stop();
    }

    @Test(expected=IllegalStateException.class)
    public void stopOnInitialised() throws Exception {
        this.ctx.initialise();
        this.ctx.stop();
    }

    @Test
    public void stopOnStarted() throws Exception {
        this.buildStartedMuleContext();
        this.ctx.stop();
        Assert.assertTrue((boolean)this.ctx.isInitialised());
        Assert.assertFalse((boolean)this.ctx.isInitialising());
        Assert.assertFalse((boolean)this.ctx.isStarted());
        Assert.assertFalse((boolean)this.ctx.isDisposed());
        Assert.assertFalse((boolean)this.ctx.isDisposing());
    }

    @Test(expected=IllegalStateException.class)
    public void stopOnStopped() throws Exception {
        this.buildStartedMuleContext();
        this.ctx.stop();
        this.ctx.stop();
    }

    @Test(expected=IllegalStateException.class)
    public void stopOnDisposed() throws Exception {
        this.buildStartedMuleContext();
        this.ctx.stop();
        this.ctx.dispose();
        this.ctx.stop();
    }

    @Test
    public void disposeBeforeInitialised() {
        this.ctx.dispose();
        Assert.assertFalse((boolean)this.ctx.isInitialised());
        Assert.assertFalse((boolean)this.ctx.isInitialising());
        Assert.assertFalse((boolean)this.ctx.isStarted());
        Assert.assertTrue((boolean)this.ctx.isDisposed());
        Assert.assertFalse((boolean)this.ctx.isDisposing());
        this.assertLifecycleManagerDidApplyPhases("dispose");
    }

    @Test
    public void disposeOnInitialised() throws Exception {
        this.ctx.initialise();
        this.ctx.dispose();
        Assert.assertFalse((boolean)this.ctx.isInitialised());
        Assert.assertFalse((boolean)this.ctx.isInitialising());
        Assert.assertFalse((boolean)this.ctx.isStarted());
        Assert.assertTrue((boolean)this.ctx.isDisposed());
        Assert.assertFalse((boolean)this.ctx.isDisposing());
        this.assertLifecycleManagerDidApplyPhases("initialise", "dispose");
    }

    @Test
    public void disposeOnStarted() throws Exception {
        this.ctx.initialise();
        new DefaultsConfigurationBuilder().configure(this.ctx);
        NotificationListener listener = new NotificationListener();
        this.ctx.registerListener((ServerNotificationListener)listener);
        this.ctx.start();
        this.ctx.dispose();
        Assert.assertFalse((boolean)this.ctx.isInitialised());
        Assert.assertFalse((boolean)this.ctx.isInitialising());
        Assert.assertFalse((boolean)this.ctx.isStarted());
        Assert.assertTrue((boolean)this.ctx.isDisposed());
        Assert.assertFalse((boolean)this.ctx.isDisposing());
        this.assertLifecycleManagerDidApplyAllPhases();
        Assert.assertTrue((String)"CONTEXT_STOPPING notification never fired", (boolean)listener.stoppingNotificationFired.get());
        Assert.assertTrue((String)"CONTEXT_STOPPED notification never fired", (boolean)listener.stoppedNotificationFired.get());
    }

    @Test
    public void disposeOnStopped() throws Exception {
        this.ctx.initialise();
        new DefaultsConfigurationBuilder().configure(this.ctx);
        this.ctx.start();
        this.ctx.stop();
        this.ctx.dispose();
        Assert.assertFalse((boolean)this.ctx.isInitialised());
        Assert.assertFalse((boolean)this.ctx.isInitialising());
        Assert.assertFalse((boolean)this.ctx.isStarted());
        Assert.assertTrue((boolean)this.ctx.isDisposed());
        Assert.assertFalse((boolean)this.ctx.isDisposing());
        this.assertLifecycleManagerDidApplyAllPhases();
    }

    @Test(expected=IllegalStateException.class)
    public void disposeOnDisposed() throws Exception {
        this.ctx.initialise();
        this.ctx.dispose();
        this.ctx.dispose();
    }

    @Test
    public void notificationHasMuleContextRef() throws Exception {
        this.ctx.initialise();
        new DefaultsConfigurationBuilder().configure(this.ctx);
        final AtomicReference contextFromNotification = new AtomicReference();
        final AtomicReference resourceId = new AtomicReference();
        MuleContextNotificationListener<MuleContextNotification> listener = new MuleContextNotificationListener<MuleContextNotification>(){

            public void onNotification(MuleContextNotification notification) {
                contextFromNotification.set(notification.getMuleContext());
                resourceId.set(notification.getResourceIdentifier());
            }
        };
        this.ctx.registerListener((ServerNotificationListener)listener);
        this.ctx.start();
        Assert.assertNotNull(contextFromNotification.get());
        Assert.assertSame((Object)this.ctx, contextFromNotification.get());
        Assert.assertEquals((Object)this.ctx.getConfiguration().getId(), resourceId.get());
    }

    private MuleContext buildStartedMuleContext() throws Exception {
        this.ctx.initialise();
        SecurityManager securityManager = (SecurityManager)Mockito.mock(SecurityManager.class);
        this.ctx.getRegistry().registerObject(UUID.getUUID(), (Object)securityManager);
        QueueManager queueManager = (QueueManager)Mockito.mock(QueueManager.class);
        this.ctx.getRegistry().registerObject(UUID.getUUID(), (Object)queueManager);
        this.ctx.start();
        return this.ctx;
    }

    private void assertLifecycleManagerDidApplyPhases(String ... phaseNames) {
        Assert.assertTrue((boolean)this.lifecycleManager.didApplyPhases(phaseNames));
    }

    private void assertLifecycleManagerDidApplyAllPhases() {
        this.assertLifecycleManagerDidApplyPhases("initialise", "start", "stop", "dispose");
    }

    @Test(expected=InitialisationException.class)
    public void testIsInValidJdk() throws InitialisationException {
        try {
            JdkVersionUtils.validateJdk();
        }
        catch (RuntimeException e) {
            Assert.fail((String)"Jdk version or vendor is invalid. Update the valid versions");
        }
        String javaVersion = System.setProperty("java.version", "1.5.0_12");
        try {
            try {
                JdkVersionUtils.validateJdk();
                Assert.fail((String)"Test is invalid because the Jdk version or vendor is supposed to now be invalid");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            MuleContext ctx = this.ctxBuilder.buildMuleContext();
            Assert.assertFalse((boolean)ctx.isInitialised());
            Assert.assertFalse((boolean)ctx.isInitialising());
            Assert.assertFalse((boolean)ctx.isStarted());
            Assert.assertFalse((boolean)ctx.isDisposed());
            Assert.assertFalse((boolean)ctx.isDisposing());
            ctx.initialise();
        }
        finally {
            System.setProperty("java.version", javaVersion);
        }
    }

    static class NotificationListener
    implements MuleContextNotificationListener<MuleContextNotification> {
        final AtomicBoolean startingNotificationFired = new AtomicBoolean(false);
        final AtomicBoolean startedNotificationFired = new AtomicBoolean(false);
        final AtomicBoolean stoppingNotificationFired = new AtomicBoolean(false);
        final AtomicBoolean stoppedNotificationFired = new AtomicBoolean(false);

        NotificationListener() {
        }

        public void onNotification(MuleContextNotification notification) {
            switch (notification.getAction()) {
                case 103: {
                    this.startingNotificationFired.set(true);
                    break;
                }
                case 104: {
                    this.startedNotificationFired.set(true);
                    break;
                }
                case 105: {
                    this.stoppingNotificationFired.set(true);
                    break;
                }
                case 106: {
                    this.stoppedNotificationFired.set(true);
                }
            }
        }
    }

    private static class SensingLifecycleManager
    extends MuleContextLifecycleManager {
        private List<String> appliedLifecyclePhases = new ArrayList<String>();

        public boolean didApplyPhases(String ... phaseNames) {
            List<String> expectedPhases = Arrays.asList(phaseNames);
            return expectedPhases.equals(this.appliedLifecyclePhases);
        }

        public void fireLifecycle(String phase) throws LifecycleException {
            this.appliedLifecyclePhases.add(phase);
            super.fireLifecycle(phase);
        }
    }
}

