/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.datetime;

import org.junit.Assert;
import org.junit.Test;
import org.mule.el.context.AbstractELTestCase;

public class DateTimeFunctionalTestCase
extends AbstractELTestCase {
    public DateTimeFunctionalTestCase(AbstractELTestCase.Variant variant, String mvelOptimizer) {
        super(variant, mvelOptimizer);
    }

    @Test
    public void iso9601DateTimeRoundTrip() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("time = server.dateTime.withTimeZone('UTC'); time == dateTime(time.toString())")));
    }

    @Test
    public void iso9601DateRoundTrip() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("time = server.dateTime.withTimeZone('UTC').date; time == dateTime(time.toString()).date")));
    }

    @Test
    public void iso9601TimeRoundTrip() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("time = server.dateTime.withTimeZone('UTC').time; time == dateTime(time.toString()).time;")));
    }

    @Test
    public void customFormatDateTimeRoundTrip() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("time = server.dateTime.withTimeZone('UTC'); time == dateTime(time.format('MM/dd/yyZZ-HHmmss.SSS-ZZ'),'MM/dd/yyZZ-HHmmss.SSS-ZZ')")));
    }

    @Test
    public void customFormatDateRoundTrip() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("time = server.dateTime.withTimeZone('UTC').date; time == dateTime(time.format('MM/dd/yy:zz'),'MM/dd/yy:zz').date;")));
    }

    @Test
    public void customFormatTimeRoundTrip() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("time = server.dateTime.withTimeZone('UTC').time; time == dateTime(time.format('HHmmss.SSS-ZZ'),'HHmmss.SSS-ZZ').time")));
    }

    @Test
    public void dateRoundTrip() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("time = server.dateTime; time == dateTime(time.toDate())")));
    }

    @Test
    public void calendarRoundTrip() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("time = server.dateTime; time == dateTime(time.toCalendar())")));
    }

    @Test
    public void xmlCalendarRoundTrip() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("time = server.dateTime.withTimeZone('UTC'); time == dateTime(time.toXMLCalendar())")));
    }

    @Test
    public void chainedManipulation() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("time = server.dateTime; time == time.plusDays(365).plusYears(-1).plusHours(24).plusDays(-2).plusMinutes(60).plusHours(-1)")));
    }

    @Test
    public void parsedTimeIsBeforeServerDateTime() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("server.dateTime.isBefore(dateTime('2100-01-01'))")));
    }

    @Test
    public void parsedTimeIsAfterServerDateTime() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("server.dateTime.isAfter(dateTime('1900-01-01'))")));
    }

    @Test
    public void addDaysAndCompareAfter() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("server.dateTime.plusDays(1).isAfter(server.dateTime)")));
    }

    @Test
    public void substractDaysAndCompareBefore() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("server.dateTime.plusDays(-1).isBefore(server.dateTime)")));
    }

    @Test
    public void iso8601ToSimpleDateFromat() {
        Assert.assertEquals((Object)"1/1/1900", (Object)this.evaluate("dateTime('1900-01-01').format('d/M/yyyy')"));
    }

    @Test
    public void simpleDateFromatToIso8601DateTime() {
        Assert.assertEquals((Object)"1900-01-01T00:00:00Z", (Object)this.evaluate("dateTime('1/1/1900','d/M/yyyy').toString()"));
    }

    @Test
    public void simpleDateFromatToIso8601Date() {
        Assert.assertEquals((Object)"1900-01-01Z", (Object)this.evaluate("dateTime('1/1/1900','d/M/yyyy').withTimeZone('GMT').date.toString()"));
    }

    @Test
    public void simpleDateFromatToIso8601Time() {
        Assert.assertEquals((Object)"00:00:00Z", (Object)this.evaluate("dateTime('1/1/1900','d/M/yyyy').withTimeZone('GMT').time.toString()"));
    }

    @Test
    public void updateIso8601TimeZone() {
        Assert.assertEquals((Object)"1900-01-01T09:00:00-08:00", (Object)this.evaluate("dateTime('1900-01-01T09:00:00Z').withTimeZone('GMT-08:00').toString()"));
    }

    @Test
    public void changeIso8601TimeZone() {
        Assert.assertEquals((Object)"1900-01-01T01:00:00-08:00", (Object)this.evaluate("dateTime('1900-01-01T09:00:00Z').changeTimeZone('GMT-08:00').toString()"));
    }

    @Test
    public void addDays8601String() {
        Assert.assertEquals((Object)"1900-01-03T00:00:00Z", (Object)this.evaluate("dateTime('1900-01-01T00:00:00Z').plusDays(2).toString()"));
    }

    @Test
    public void compareYearIsoAndSimpleDateFormatStrings() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("dateTime('1900-01-01').year==dateTime('1/1/1900','d/M/yyyy').year")));
    }

    @Test
    public void isoStringEquals() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("dateTime('1900-01-01') == dateTime('1900-01-01')")));
    }

    @Test
    public void isoAndSimpleDateFormatEquals() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("dateTime('1900-01-01Z') == dateTime('1/1/1900','d/M/yyyy')")));
    }

    @Test
    public void equalsDate() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("dateTime('1900-01-01') == dateTime('1900-01-01T23:11:34').date")));
    }

    @Test
    public void equalsDate2() {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("dateTime('1900-01-01T11:01:11').date == dateTime('1900-01-01T23:11:34').date")));
    }

    @Test
    public void equalsTime() {
        Assert.assertEquals((Object)this.evaluate("dateTime('23:11:34Z')"), (Object)this.evaluate("dateTime('23:11:34Z').time"));
    }

    @Test
    public void equalsTime2() {
        Assert.assertEquals((Object)this.evaluate("dateTime('23:11:34Z').time"), (Object)this.evaluate("dateTime('1970-01-01T23:11:34Z').time"));
    }

    @Test
    public void dateToString() {
        Assert.assertEquals((Object)"2100-12-12Z", (Object)this.evaluate("dateTime('2100-12-12T23:11:34Z').date.format()"));
    }

    @Test
    public void timeToString() {
        Assert.assertEquals((Object)"23:11:34Z", (Object)this.evaluate("dateTime('2100-12-12T23:11:34Z').time.format()"));
    }
}

