/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.expression.MessageHeaderExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.TypedValue;

public class MessageHeaderExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    private static final String CUSTOM_ENCODING = StandardCharsets.UTF_16.name();
    public static final String PROP_NAME = "testProp";
    public static final String PROP_VALUE = "testValue";
    private HashMap<String, Object> messageProperties;
    private MessageHeaderExpressionEvaluator evaluator = new MessageHeaderExpressionEvaluator();
    private MuleMessage message;

    public MessageHeaderExpressionEvaluatorTestCase() {
        this.setDisposeContextPerClass(true);
    }

    @Override
    public void doSetUp() {
        this.messageProperties = new HashMap(3);
        this.messageProperties.put("foo", "foovalue");
        this.messageProperties.put("bar", "barvalue");
        this.messageProperties.put("baz", "bazvalue");
        this.message = new DefaultMuleMessage((Object)"Test Message", this.messageProperties, muleContext);
    }

    @Test
    public void requiredHeaderWithExistingValueShouldReturnValue() {
        Object result = this.evaluator.evaluate("foo", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"foovalue", (Object)result);
    }

    @Test
    public void requiredHeaderWithExistingValueViaExpressionManagerShouldReturnValue() {
        Object result = muleContext.getExpressionManager().evaluate("#[header:foo]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"foovalue", (Object)result);
    }

    @Test(expected=RequiredValueException.class)
    public void requiredHeaderWithMissingValueShouldFail() {
        this.evaluator.evaluate("nonexistent", this.message);
    }

    @Test(expected=RequiredValueException.class)
    public void requiredHeaderWithMissingValueViaExpressionManagerShouldFail() {
        muleContext.getExpressionManager().evaluate("#[header:fool]", this.message);
    }

    @Test
    public void requiredHeaderWithExplicitPropertyScopeShouldReturnValue() throws Exception {
        this.addInboundMessageProperty(PROP_NAME, "testvalue");
        Object result = this.evaluator.evaluate("INBOUND:testProp", this.message);
        Assert.assertEquals((Object)"testvalue", (Object)result);
    }

    @Test
    public void optionalHeaderWithExistingValueShouldReturnValue() {
        Object result = this.evaluator.evaluate("foo?", this.message);
        Assert.assertEquals((Object)"foovalue", (Object)result);
    }

    @Test
    public void optionalHeaderWithExistingValueViaExpressionManagerShouldReturnValue() {
        Object result = muleContext.getExpressionManager().evaluate("#[header:foo?]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"foovalue", (Object)result);
    }

    @Test
    public void optionalHeaderWithMissingValueShouldReturnNull() {
        Object result = this.evaluator.evaluate("nonexistent?", this.message);
        Assert.assertNull((Object)result);
    }

    @Test
    public void optionalHeaderWithMissingValueViaExpressionManagerShouldReturnNull() {
        Object result = muleContext.getExpressionManager().evaluate("#[header:nonexistent?]", this.message);
        Assert.assertNull((Object)result);
    }

    @Test
    public void optionalHeaderWithMissingValueInDefaultScopeShouldReturnNull() {
        this.addInboundMessageProperty(PROP_NAME, "testvalue");
        Object result = this.evaluator.evaluate("testProp?", this.message);
        Assert.assertNull((Object)result);
    }

    @Test
    public void evaluatesWithType() throws Exception {
        DataType dataType = DataTypeFactory.create(String.class, (String)"text/json");
        dataType.setEncoding(CUSTOM_ENCODING);
        this.message.setProperty(PROP_NAME, (Object)PROP_VALUE, PropertyScope.OUTBOUND, dataType);
        TypedValue typedValue = this.evaluator.evaluateTyped(PROP_NAME, this.message);
        MatcherAssert.assertThat((Object)((String)typedValue.getValue()), (Matcher)Matchers.equalTo((Object)PROP_VALUE));
        MatcherAssert.assertThat((Object)typedValue.getDataType(), DataTypeMatcher.like(String.class, "text/json", CUSTOM_ENCODING));
    }

    @Test
    public void evaluatesUnExistentPropertyWithType() throws Exception {
        TypedValue typedValue = this.evaluator.evaluateTyped("UNKNOWN?", this.message);
        MatcherAssert.assertThat((Object)typedValue.getValue(), (Matcher)Matchers.equalTo(null));
        MatcherAssert.assertThat((Object)typedValue.getDataType(), DataTypeMatcher.like(Object.class, "*/*", null));
    }

    private void addInboundMessageProperty(String key, Object value) {
        Map<String, Object> inboundProperties = Collections.singletonMap(key, value);
        DefaultMuleMessage dmm = (DefaultMuleMessage)this.message;
        dmm.addInboundProperties(inboundProperties);
    }
}

