/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.transformer.Transformer;
import org.mule.expression.MuleExpressionEvaluator;
import org.mule.expression.RegistryExpressionEvaluator;
import org.mule.message.DefaultExceptionPayload;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.FruitBasket;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.FruitBowlToFruitBasket;
import org.mule.util.StringDataSource;

public class MuleExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    private Map props;

    @Override
    protected void doSetUp() throws Exception {
        MuleEvent event = MuleExpressionEvaluatorTestCase.getTestEvent((Object)"testing", MuleExpressionEvaluatorTestCase.getTestService("apple", Apple.class), MuleExpressionEvaluatorTestCase.getTestInboundEndpoint("test", "test://foo"));
        RequestContext.setEvent((MuleEvent)event);
        this.props = new HashMap(3);
        this.props.put("foo", "moo");
        this.props.put("bar", "mar");
        this.props.put("baz", "maz");
    }

    protected MuleMessage createMessageWithAttachments() {
        try {
            HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
            attachments.put("foo", new DataHandler((DataSource)new StringDataSource("moo")));
            attachments.put("bar", new DataHandler((DataSource)new StringDataSource("mar")));
            attachments.put("baz", new DataHandler((DataSource)new StringDataSource("maz")));
            return new DefaultMuleMessage((Object)"test", null, attachments, muleContext);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    @Test
    public void testSingleAttachment() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object result = eval.evaluate("message.attachment(foo)", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DataHandler));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"moo", (Object)baos.toString());
        result = eval.evaluate("message.attachment(foo?)", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DataHandler));
        baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"moo", (Object)baos.toString());
        result = eval.evaluate("message.attachment(fool?)", this.createMessageWithAttachments());
        Assert.assertNull((Object)result);
        try {
            eval.evaluate("message.attachments(fool)", this.createMessageWithAttachments());
            Assert.fail((String)"Attachment 'fool' is not on the nessage and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testMapAttachments() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object result = eval.evaluate("message.attachments(foo, baz)", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertNotNull(((Map)result).get("foo"));
        Assert.assertTrue((boolean)(((Map)result).get("foo") instanceof DataHandler));
        DataHandler dh = (DataHandler)((Map)result).get("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"moo", (Object)baos.toString());
        Assert.assertNotNull(((Map)result).get("baz"));
        Assert.assertTrue((boolean)(((Map)result).get("baz") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("baz");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"maz", (Object)baos.toString());
        result = eval.evaluate("message.attachments(fool?)", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        result = eval.evaluate("message.attachments(foo?, baz)", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertNotNull(((Map)result).get("foo"));
        Assert.assertTrue((boolean)(((Map)result).get("foo") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("foo");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"moo", (Object)baos.toString());
        Assert.assertNotNull(((Map)result).get("baz"));
        Assert.assertTrue((boolean)(((Map)result).get("baz") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("baz");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"maz", (Object)baos.toString());
        try {
            eval.evaluate("message.attachments(fool)", this.createMessageWithAttachments());
            Assert.fail((String)"Attachment 'fool' is not on the nessage and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testListAttachments() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object result = eval.evaluate("message.attachments-list(foo, baz)", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        DataHandler dh = (DataHandler)((List)result).get(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"moo", (Object)baos.toString());
        Assert.assertTrue((boolean)(((List)result).get(1) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(1);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"maz", (Object)baos.toString());
        result = eval.evaluate("message.attachments-list(fool?)", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)0L, (long)((List)result).size());
        result = eval.evaluate("message.attachments-list(foo?, baz)", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(0);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"moo", (Object)baos.toString());
        Assert.assertTrue((boolean)(((List)result).get(1) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(1);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"maz", (Object)baos.toString());
        result = eval.evaluate("message.attachments-list(fool?)", this.createMessageWithAttachments());
        Assert.assertEquals((long)0L, (long)((List)result).size());
        try {
            eval.evaluate("message.attachments-list(fool)", this.createMessageWithAttachments());
            Assert.fail((String)"Attachment 'fool' is not on the message and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSingleAttachmentUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.attachment(foo)]", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DataHandler));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"moo", (Object)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachment(foo?)]", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DataHandler));
        baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"moo", (Object)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachment(fool?)]", this.createMessageWithAttachments());
        Assert.assertNull((Object)result);
        try {
            muleContext.getExpressionManager().evaluate("#[mule:message.attachment(fool)]", this.createMessageWithAttachments());
            Assert.fail((String)"Attachment 'fool' is not on the message and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testMapAttachmentsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments(foo, baz)]", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertNotNull(((Map)result).get("foo"));
        Assert.assertTrue((boolean)(((Map)result).get("foo") instanceof DataHandler));
        DataHandler dh = (DataHandler)((Map)result).get("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"moo", (Object)baos.toString());
        Assert.assertNotNull(((Map)result).get("baz"));
        Assert.assertTrue((boolean)(((Map)result).get("baz") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("baz");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"maz", (Object)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments(foo?, baz)]", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertNotNull(((Map)result).get("foo"));
        Assert.assertTrue((boolean)(((Map)result).get("foo") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("foo");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"moo", (Object)baos.toString());
        Assert.assertNotNull(((Map)result).get("baz"));
        Assert.assertTrue((boolean)(((Map)result).get("baz") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("baz");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"maz", (Object)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments(foo, fool?)]", this.createMessageWithAttachments());
        Assert.assertNotNull(((Map)result).get("foo"));
        try {
            muleContext.getExpressionManager().evaluate("#[mule:message.attachments(foo, fool)]", this.createMessageWithAttachments());
            Assert.fail((String)"Attachment 'fool' is not on the message and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testListAttachmentsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments-list(foo,baz)]", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        DataHandler dh = (DataHandler)((List)result).get(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"moo", (Object)baos.toString());
        Assert.assertTrue((boolean)(((List)result).get(1) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(1);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"maz", (Object)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments-list(fool?)]", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)0L, (long)((List)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments-list(foo?,baz)]", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(0);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"moo", (Object)baos.toString());
        Assert.assertTrue((boolean)(((List)result).get(1) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(1);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"maz", (Object)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments-list(fool?)]", this.createMessageWithAttachments());
        Assert.assertEquals((long)0L, (long)((List)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments-list(foo, fool?)]", this.createMessageWithAttachments());
        Assert.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        Assert.assertEquals((long)1L, (long)((List)result).size());
        try {
            muleContext.getExpressionManager().evaluate("#[mule:message.attachments-list(foo, fool)]", this.createMessageWithAttachments());
            Assert.fail((String)"Attachment 'fool' is not on the message and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGettingAllAttachments() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object result = eval.evaluate("message.attachments(*)", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        result = eval.evaluate("message.attachments-list(*)", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)3L, (long)((List)result).size());
    }

    @Test
    public void testGettingAllAttachmentsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments(*)]", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments-list(*)]", this.createMessageWithAttachments());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)3L, (long)((List)result).size());
    }

    @Test
    public void testSingleHeader() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("message.header(foo)", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"moo", (Object)result);
        result = eval.evaluate("message.header(foo?)", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"moo", (Object)result);
        result = eval.evaluate("message.header(fool?)", (MuleMessage)message);
        Assert.assertNull((Object)result);
        try {
            muleContext.getExpressionManager().evaluate("#[mule:message.header(fool)]", this.createMessageWithAttachments());
            Assert.fail((String)"Header 'fool' is not on the message and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testMapHeaders() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("message.headers(foo, baz)", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("moo"));
        Assert.assertTrue((boolean)((Map)result).values().contains("maz"));
        Assert.assertFalse((boolean)((Map)result).values().contains("mar"));
        result = eval.evaluate("message.headers(foo?, baz)", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("moo"));
        Assert.assertTrue((boolean)((Map)result).values().contains("maz"));
        Assert.assertFalse((boolean)((Map)result).values().contains("mar"));
        result = eval.evaluate("message.headers(fool?)", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        result = eval.evaluate("message.headers(foo, fool?)", (MuleMessage)message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((Object)"moo", ((Map)result).get("foo"));
        Assert.assertEquals((long)1L, (long)((Map)result).size());
        try {
            eval.evaluate("message.headers(foo, fool)", this.createMessageWithAttachments());
            Assert.fail((String)"Header 'fool' is not on the message and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testListHeaders() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("message.headers-list(foo, baz)", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("moo"));
        Assert.assertTrue((boolean)((List)result).contains("maz"));
        Assert.assertFalse((boolean)((List)result).contains("mar"));
        result = eval.evaluate("message.headers(fool?)", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        result = eval.evaluate("message.headers-list(foo?, baz)", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("moo"));
        Assert.assertTrue((boolean)((List)result).contains("maz"));
        Assert.assertFalse((boolean)((List)result).contains("mar"));
        result = eval.evaluate("message.headers(fool?)", (MuleMessage)message);
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        result = eval.evaluate("message.headers-list(foo, fool?)", (MuleMessage)message);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((Object)"moo", ((List)result).get(0));
        Assert.assertEquals((long)1L, (long)((List)result).size());
        try {
            eval.evaluate("message.headers-list(foo, fool)", this.createMessageWithAttachments());
            Assert.fail((String)"Header 'fool' is not on the message and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGettingAllHeaders() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("message.headers(*)", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        result = eval.evaluate("message.headers-list(*)", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)3L, (long)((List)result).size());
    }

    @Test
    public void testGettingAllHeadersUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.headers(*)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers-list(*)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)3L, (long)((List)result).size());
    }

    @Test
    public void testSingleHeaderUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.header(foo)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"moo", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[mule:message.header(foo?)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"moo", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[mule:message.header(fool?)]", (MuleMessage)message);
        Assert.assertNull((Object)result);
        try {
            muleContext.getExpressionManager().evaluate("#[mule:message.header(fool)]", this.createMessageWithAttachments());
            Assert.fail((String)"Header 'fool' is not on the message and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testMapHeadersUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.headers(foo, baz)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("moo"));
        Assert.assertTrue((boolean)((Map)result).values().contains("maz"));
        Assert.assertFalse((boolean)((Map)result).values().contains("mar"));
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers(fool?)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers(foo?, baz)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertTrue((boolean)((Map)result).values().contains("moo"));
        Assert.assertTrue((boolean)((Map)result).values().contains("maz"));
        Assert.assertFalse((boolean)((Map)result).values().contains("mar"));
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers(fool?)]", (MuleMessage)message);
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers(foo, fool?)]", (MuleMessage)message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((Object)"moo", ((Map)result).get("foo"));
        Assert.assertEquals((long)1L, (long)((Map)result).size());
        try {
            muleContext.getExpressionManager().evaluate("#[mule:message.headers(foo, fool)]", this.createMessageWithAttachments());
            Assert.fail((String)"Header 'fool' is not on the message and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testListHeadersUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.headers-list(foo, baz)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("moo"));
        Assert.assertTrue((boolean)((List)result).contains("maz"));
        Assert.assertFalse((boolean)((List)result).contains("mar"));
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers-list(fool?)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)0L, (long)((List)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers-list(foo?, baz)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)((List)result).contains("moo"));
        Assert.assertTrue((boolean)((List)result).contains("maz"));
        Assert.assertFalse((boolean)((List)result).contains("mar"));
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers(fool?)]", (MuleMessage)message);
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers-list(foo, fool?)]", (MuleMessage)message);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((Object)"moo", ((List)result).get(0));
        Assert.assertEquals((long)1L, (long)((List)result).size());
        try {
            muleContext.getExpressionManager().evaluate("#[mule:message.headers-list(foo, fool)]", this.createMessageWithAttachments());
            Assert.fail((String)"Header 'fool' is not on the message and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testContextExpressions() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        MuleExpressionEvaluator extractor = new MuleExpressionEvaluator();
        extractor.setMuleContext(muleContext);
        Object o = extractor.evaluate("context.serviceName", (MuleMessage)message);
        Assert.assertEquals((Object)"apple", (Object)o);
        o = extractor.evaluate("context.modelName", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = extractor.evaluate("context.inboundEndpoint", (MuleMessage)message);
        Assert.assertEquals((Object)"test://foo", (Object)o.toString());
        o = extractor.evaluate("context.serverId", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = extractor.evaluate("context.clusterId", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = extractor.evaluate("context.domainId", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = extractor.evaluate("context.workingDir", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        try {
            extractor.evaluate("context.bork", (MuleMessage)message);
            Assert.fail((String)"bork is not a valid mule context value");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testContextExpressionsFromExtractorManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        Object o = muleContext.getExpressionManager().evaluate("mule:context.serviceName", (MuleMessage)message);
        Assert.assertEquals((Object)"apple", (Object)o);
        o = muleContext.getExpressionManager().evaluate("mule:context.modelName", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = muleContext.getExpressionManager().evaluate("mule:context.inboundEndpoint", (MuleMessage)message);
        Assert.assertEquals((Object)"test://foo", (Object)o.toString());
        o = muleContext.getExpressionManager().evaluate("mule:context.serverId", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = muleContext.getExpressionManager().evaluate("mule:context.clusterId", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = muleContext.getExpressionManager().evaluate("mule:context.domainId", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = muleContext.getExpressionManager().evaluate("mule:context.workingDir", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        try {
            muleContext.getExpressionManager().evaluate("mule:context.bork", (MuleMessage)message);
            Assert.fail((String)"bork is not a valid mule context value");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testMissingEventContext() throws Exception {
        RequestContext.clear();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        MuleExpressionEvaluator extractor = new MuleExpressionEvaluator();
        extractor.setMuleContext(muleContext);
        Object o = extractor.evaluate("context.serverId", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        try {
            extractor.evaluate("context.serviceName", (MuleMessage)message);
            Assert.fail((String)"There is no current event context");
        }
        catch (MuleRuntimeException muleRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testMessagePropertiesUsingEvaluatorDirectly() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        message.setCorrelationId(message.getUniqueId());
        message.setCorrelationSequence(1);
        message.setCorrelationGroupSize(2);
        message.setReplyTo((Object)"foo");
        message.setEncoding("UTF-8");
        Exception e = new Exception("dummy");
        message.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)e));
        Object result = eval.evaluate(null, (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)message, (Object)result);
        result = eval.evaluate(null, null);
        Assert.assertNull((Object)result);
        Assert.assertEquals((Object)message.getUniqueId(), (Object)eval.evaluate("message.id", (MuleMessage)message));
        Assert.assertEquals((Object)message.getUniqueId(), (Object)eval.evaluate("message.correlationId", (MuleMessage)message));
        Assert.assertEquals((Object)new Integer(1), (Object)eval.evaluate("message.correlationSequence", (MuleMessage)message));
        Assert.assertEquals((Object)new Integer(2), (Object)eval.evaluate("message.correlationGroupSize", (MuleMessage)message));
        Assert.assertEquals((Object)"foo", (Object)eval.evaluate("message.replyTo", (MuleMessage)message));
        Assert.assertEquals((Object)e, (Object)eval.evaluate("message.exception", (MuleMessage)message));
        Assert.assertEquals((Object)"UTF-8", (Object)eval.evaluate("message.encoding", (MuleMessage)message));
        Assert.assertEquals((Object)"test", (Object)eval.evaluate("message.payload", (MuleMessage)message));
        try {
            eval.evaluate("message.xxx", (MuleMessage)message);
            Assert.fail((String)"message.xxx is not a supported expresion");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testMessagePropertiesUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        message.setCorrelationId(message.getUniqueId());
        message.setCorrelationSequence(1);
        message.setCorrelationGroupSize(2);
        message.setReplyTo((Object)"foo");
        message.setEncoding("UTF-8");
        Exception e = new Exception("dummy");
        message.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)e));
        Assert.assertEquals((Object)message.getUniqueId(), (Object)muleContext.getExpressionManager().evaluate("#[mule:message.id]", (MuleMessage)message));
        Assert.assertEquals((Object)message.getUniqueId(), (Object)muleContext.getExpressionManager().evaluate("#[mule:message.correlationId]", (MuleMessage)message));
        Assert.assertEquals((Object)new Integer(1), (Object)muleContext.getExpressionManager().evaluate("#[mule:message.correlationSequence]", (MuleMessage)message));
        Assert.assertEquals((Object)new Integer(2), (Object)muleContext.getExpressionManager().evaluate("#[mule:message.correlationGroupSize]", (MuleMessage)message));
        Assert.assertEquals((Object)"foo", (Object)muleContext.getExpressionManager().evaluate("#[mule:message.replyTo]", (MuleMessage)message));
        Assert.assertEquals((Object)e, (Object)muleContext.getExpressionManager().evaluate("#[mule:message.exception]", (MuleMessage)message));
        Assert.assertEquals((Object)"UTF-8", (Object)muleContext.getExpressionManager().evaluate("#[mule:message.encoding]", (MuleMessage)message));
        Assert.assertEquals((Object)"test", (Object)muleContext.getExpressionManager().evaluate("#[mule:message.payload]", (MuleMessage)message));
        try {
            muleContext.getExpressionManager().evaluate("#[mule:message.xxx]", (MuleMessage)message, true);
            Assert.fail((String)"xxx is not a supported expresion");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testMessagePayloadWithNulls() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object result = eval.evaluate(null, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testMessagePayloadWithNullsUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        Assert.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("${payload:}"));
        Assert.assertTrue((boolean)muleContext.getExpressionManager().isValidExpression("#[mule:message.payload]"));
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.payload]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"test", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[mule:message.payload]", (MuleMessage)null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testMessagePayloadWithTransform() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        Object result = eval.evaluate("message.payload(byte[])", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof byte[]));
        Assert.assertEquals((Object)"test", (Object)new String((byte[])result));
        ByteArrayInputStream bais = new ByteArrayInputStream("test2".getBytes());
        result = eval.evaluate("message.payload(java.lang.String)", (MuleMessage)new DefaultMuleMessage((Object)bais, muleContext));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"test2", (Object)result);
    }

    @Test
    public void testMessagePayloadWithTransformUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.payload(byte[])]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof byte[]));
        Assert.assertEquals((Object)"test", (Object)new String((byte[])result));
        ByteArrayInputStream bais = new ByteArrayInputStream("test2".getBytes());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.payload(java.lang.String)]", (MuleMessage)new DefaultMuleMessage((Object)bais, muleContext));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"test2", (Object)result);
    }

    @Test
    public void testMessagePayloadWithMoreComplexTransform() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new FruitBowl(new Apple(), new Banana()), muleContext);
        muleContext.getRegistry().registerTransformer((Transformer)new FruitBowlToFruitBasket());
        Object result = eval.evaluate("message.payload(org.mule.tck.testmodels.fruit.FruitBasket)", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof FruitBasket));
        FruitBasket fb = (FruitBasket)result;
        Assert.assertEquals((long)2L, (long)fb.getFruit().size());
        Assert.assertTrue((boolean)fb.hasBanana());
        Assert.assertTrue((boolean)fb.hasApple());
    }

    @Test
    public void testMessagePayloadWithMoreComplexTransformUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new FruitBowl(new Apple(), new Banana()), muleContext);
        muleContext.getRegistry().registerTransformer((Transformer)new FruitBowlToFruitBasket());
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.payload(org.mule.tck.testmodels.fruit.FruitBasket)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof FruitBasket));
        FruitBasket fb = (FruitBasket)result;
        Assert.assertEquals((long)2L, (long)fb.getFruit().size());
        Assert.assertTrue((boolean)fb.hasBanana());
        Assert.assertTrue((boolean)fb.hasApple());
    }

    @Test
    public void testMapPayloadUsingManager() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("foo", "far");
        map.put("boo", "bar");
        map.put("zoo", "zar");
        DefaultMuleMessage message = new DefaultMuleMessage(map, muleContext);
        Assert.assertTrue((boolean)muleContext.getExpressionManager().isValidExpression("#[mule:message.map-payload(foo)]"));
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(foo)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"far", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(foo?)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"far", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(foot?)]", (MuleMessage)message);
        Assert.assertNull((Object)result);
        try {
            muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(fool)]", (MuleMessage)message);
            Assert.fail((String)"Map payload does not contain property 'fool' but it is required");
        }
        catch (ExpressionRuntimeException expressionRuntimeException) {
            // empty catch block
        }
        result = muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(foo, boo)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(foo?, boo)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(fool?, boo)]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)1L, (long)((Map)result).size());
        try {
            muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(fool, boo)]", (MuleMessage)message);
            Assert.fail((String)"Map payload does not contain property 'fool' but it is required");
        }
        catch (ExpressionRuntimeException expressionRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleRegistryLookup() throws Exception {
        FruitBowlToFruitBasket trans = new FruitBowlToFruitBasket();
        trans.setName("bowlToBasket");
        muleContext.getRegistry().registerTransformer((Transformer)trans);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Apple(), muleContext);
        RegistryExpressionEvaluator eval = new RegistryExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object o = eval.evaluate("bowlToBasket", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((boolean)(o instanceof Transformer));
        o = eval.evaluate("XXbowlToBasket*", (MuleMessage)message);
        Assert.assertNull((Object)o);
        try {
            eval.evaluate("XXbowlToBasket", (MuleMessage)message);
            Assert.fail((String)"Object is not optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleRegistryLookupUsingMAnager() throws Exception {
        FruitBowlToFruitBasket trans = new FruitBowlToFruitBasket();
        trans.setName("bowlToBasket");
        muleContext.getRegistry().registerTransformer((Transformer)trans);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Apple(), muleContext);
        Object o = muleContext.getExpressionManager().evaluate("#[mule:registry.bowlToBasket]", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((boolean)(o instanceof Transformer));
        o = muleContext.getExpressionManager().evaluate("#[mule:registry.XXbowlToBasket*]", (MuleMessage)message);
        Assert.assertNull((Object)o);
        try {
            muleContext.getExpressionManager().evaluate("#[mule:registry.XXbowlToBasket]", (MuleMessage)message);
            Assert.fail((String)"Object is not optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

