/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.chain;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.routing.filter.Filter;
import org.mule.api.service.Service;
import org.mule.api.transport.ReplyToHandler;
import org.mule.construct.Flow;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.NonBlockingMessageProcessor;
import org.mule.processor.ResponseMessageProcessorAdapter;
import org.mule.processor.chain.DefaultMessageProcessorChain;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.ChoiceRouter;
import org.mule.routing.ScatterGatherRouter;
import org.mule.routing.filters.AcceptAllFilter;
import org.mule.tck.SensingNullReplyToHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.simple.StringAppendTransformer;
import org.mule.util.ObjectUtils;

@RunWith(value=Parameterized.class)
@SmallTest
public class DefaultMessageProcessorChainTestCase
extends AbstractMuleTestCase {
    protected MuleContext muleContext;
    protected MessageExchangePattern exchangePattern;
    protected boolean nonBlocking;
    protected boolean synchronous;
    private volatile int threads = 1;
    private Executor executor = Executors.newCachedThreadPool();

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({MessageExchangePattern.REQUEST_RESPONSE, false, true}, {MessageExchangePattern.REQUEST_RESPONSE, false, false}, {MessageExchangePattern.REQUEST_RESPONSE, true, true}, {MessageExchangePattern.REQUEST_RESPONSE, true, false}, {MessageExchangePattern.ONE_WAY, false, true}, {MessageExchangePattern.ONE_WAY, false, false}, {MessageExchangePattern.ONE_WAY, true, true}, {MessageExchangePattern.ONE_WAY, true, false});
    }

    public DefaultMessageProcessorChainTestCase(MessageExchangePattern exchangePattern, boolean nonBlocking, boolean synchronous) {
        this.exchangePattern = exchangePattern;
        this.nonBlocking = nonBlocking;
        this.synchronous = synchronous;
    }

    @Before
    public void before() {
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)muleConfiguration.isContainerMode()).thenReturn((Object)false);
        Mockito.when((Object)muleConfiguration.getId()).thenReturn((Object)RandomStringUtils.randomNumeric((int)3));
        Mockito.when((Object)muleConfiguration.getShutdownTimeout()).thenReturn((Object)1000);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
    }

    @Test
    public void testMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3")});
        Assert.assertEquals((Object)"0123", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 4L : 1L), (long)this.threads);
    }

    @Test
    public void testMPChainWithNullReturn() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingMP mp1 = this.getAppendingMP("1");
        AppendingMP mp2 = this.getAppendingMP("2");
        ReturnNullMP nullmp = new ReturnNullMP();
        AppendingMP mp3 = this.getAppendingMP("3");
        builder.chain(new MessageProcessor[]{mp1, mp2, nullmp, mp3});
        MuleEvent requestEvent = this.getTestEventUsingFlow("0");
        Assert.assertNull((Object)this.process((MessageProcessor)builder.build(), requestEvent));
        Assert.assertSame((Object)requestEvent.getMessage(), (Object)mp1.event.getMessage());
        Assert.assertNotSame((Object)mp1.event, (Object)mp1.resultEvent);
        Assert.assertEquals((Object)"01", (Object)mp1.resultEvent.getMessage().getPayload());
        Assert.assertSame((Object)mp1.resultEvent.getMessage(), (Object)mp2.event.getMessage());
        Assert.assertNotSame((Object)mp2.event, (Object)mp2.resultEvent);
        Assert.assertEquals((Object)"012", (Object)mp2.resultEvent.getMessage().getPayload());
        Assert.assertSame((Object)mp2.resultEvent.getMessage(), (Object)nullmp.event.getMessage());
        Assert.assertEquals((Object)"012", (Object)nullmp.event.getMessage().getPayload());
        Assert.assertNull((Object)mp3.event);
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 3L : 1L), (long)this.threads);
    }

    @Test
    public void testMPChainWithVoidReturn() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingMP mp1 = this.getAppendingMP("1");
        AppendingMP mp2 = this.getAppendingMP("2");
        ReturnVoidMP voidmp = new ReturnVoidMP();
        AppendingMP mp3 = this.getAppendingMP("3");
        builder.chain(new MessageProcessor[]{mp1, mp2, voidmp, mp3});
        MuleEvent requestEvent = this.getTestEventUsingFlow("0");
        Assert.assertEquals((Object)"0123", (Object)this.process((MessageProcessor)builder.build(), requestEvent).getMessage().getPayload());
        Assert.assertNotSame((Object)mp1.event, (Object)mp1.resultEvent);
        Assert.assertNotSame((Object)mp2.event, (Object)mp2.resultEvent);
        Assert.assertEquals((Object)mp2.resultEvent, (Object)voidmp.event);
        Assert.assertNotSame((Object)mp3.event, (Object)mp2.resultEvent);
        Assert.assertEquals((Object)mp2.resultEvent.getMessage().getPayload(), (Object)mp3.event.getMessage().getPayload());
        Assert.assertEquals((Object)mp3.event.getMessage().getPayload(), (Object)"012");
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 4L : 1L), (long)this.threads);
    }

    @Test
    public void testMPChainWithNullReturnAtEnd() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new ReturnNullMP()});
        Assert.assertNull((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 4L : 1L), (long)this.threads);
    }

    @Test
    public void testMPChainWithVoidReturnAtEnd() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new ReturnVoidMP()});
        Assert.assertEquals((Object)"0123", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 4L : 1L), (long)this.threads);
    }

    @Test
    public void testMPChainWithBuilder() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1")});
        builder.chain(new MessageProcessorBuilder[]{new MessageProcessorBuilder(){

            public MessageProcessor build() {
                return DefaultMessageProcessorChainTestCase.this.getAppendingMP("2");
            }
        }});
        builder.chain(new MessageProcessor[]{this.getAppendingMP("3")});
        Assert.assertEquals((Object)"0123", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 4L : 1L), (long)this.threads);
    }

    @Test
    public void testInterceptingMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2"), new AppendingInterceptingMP("3")});
        Assert.assertEquals((Object)"0before1before2before3after3after2after1", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testInterceptingMPChainWithNullReturn() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP lastMP = new AppendingInterceptingMP("3");
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2"), new ReturnNullInterceptongMP(), lastMP});
        Assert.assertNull((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertFalse((boolean)lastMP.invoked);
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testInterceptingMPChainWithVoidReturn() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP lastMP = new AppendingInterceptingMP("3");
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2"), new ReturnNullInterceptongMP(), lastMP});
        Assert.assertNull((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertFalse((boolean)lastMP.invoked);
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMixedMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMixedMPChainWithNullReturn1() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new ReturnNullInterceptongMP(), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertNull((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMixedMPChainWithVoidReturn1() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new ReturnVoidMPInterceptongMP(), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertSame((Object)"0", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMixedMPChainWithNullReturn2() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), new ReturnNullInterceptongMP(), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertNull((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMixedMPChainWithVoidlReturn2() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), new ReturnVoidMPInterceptongMP(), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertEquals((Object)"0before12after1", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMixedMPChainWithNullReturn3() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new ReturnNullMP(), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertNull((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMixedMPChainWithVoidReturn3() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new ReturnVoidMP(), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMixedMPChainWithNullReturn4() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), new ReturnNullMP(), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertNull((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMixedMPChainWithVoidReturn4() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), new ReturnVoidMP(), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMixedMPChainWithNullReturn5() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new ReturnNullMP(), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertNull((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMixedMPChainWithVoidReturn5() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new ReturnVoidMP(), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMixedMPChainWithNullReturnAtEnd() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5"), new ReturnNullMP()});
        Assert.assertNull((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMixedMPChainWithVoidReturnAtEnd() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5"), new ReturnVoidMP()});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testNestedMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{this.getAppendingMP("a"), this.getAppendingMP("b")}).build(), this.getAppendingMP("2")});
        Assert.assertEquals((Object)"01ab2", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 5L : 1L), (long)this.threads);
    }

    @Test
    public void testNestedMPChainWithNullReturn() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{this.getAppendingMP("a"), new ReturnNullMP(), this.getAppendingMP("b")}).build(), new ReturnNullMP(), this.getAppendingMP("2")});
        Assert.assertNull((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 3L : 1L), (long)this.threads);
    }

    @Test
    public void testNestedMPChainWithVoidReturn() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{this.getAppendingMP("a"), new ReturnVoidMP(), this.getAppendingMP("b")}).build(), new ReturnVoidMP(), this.getAppendingMP("2")});
        Assert.assertEquals((Object)"01ab2", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 5L : 1L), (long)this.threads);
    }

    @Test
    public void testNestedMPChainWithNullReturnAtEndOfNestedChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{this.getAppendingMP("a"), this.getAppendingMP("b"), new ReturnNullMP()}).build(), this.getAppendingMP("2")});
        Assert.assertNull((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 4L : 1L), (long)this.threads);
    }

    @Test
    public void testNestedMPChainWithVoidReturnAtEndOfNestedChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{this.getAppendingMP("a"), this.getAppendingMP("b"), new ReturnVoidMP()}).build(), this.getAppendingMP("2")});
        Assert.assertEquals((Object)"01ab2", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 5L : 1L), (long)this.threads);
    }

    @Test
    public void testNestedMPChainWithNullReturnAtEndOfNestedChainWithNonInterceptingWrapper() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        MessageProcessorChain nested = new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{this.getAppendingMP("a"), this.getAppendingMP("b"), new ReturnNullMP()}).build();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), new MessageProcessor((MessageProcessor)nested){
            final /* synthetic */ MessageProcessor val$nested;
            {
                this.val$nested = messageProcessor;
            }

            public MuleEvent process(MuleEvent event) throws MuleException {
                return this.val$nested.process(event);
            }
        }, this.getAppendingMP("2")});
        Assert.assertNull((String)"012", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 4L : 1L), (long)this.threads);
    }

    @Test
    public void testNestedMPChainWithVoidReturnAtEndOfNestedChainWithNonInterceptingWrapper() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        MessageProcessorChain nested = new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{this.getAppendingMP("a"), this.getAppendingMP("b"), new ReturnVoidMP()}).build();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), new MessageProcessor((MessageProcessor)nested){
            final /* synthetic */ MessageProcessor val$nested;
            {
                this.val$nested = messageProcessor;
            }

            public MuleEvent process(MuleEvent event) throws MuleException {
                return this.val$nested.process((MuleEvent)new DefaultMuleEvent(event.getMessage(), MessageExchangePattern.REQUEST_RESPONSE, event.getFlowConstruct()));
            }
        }, this.getAppendingMP("2")});
        Assert.assertEquals((Object)"01ab2", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 2L : 1L), (long)this.threads);
    }

    @Test
    public void testNestedInterceptingMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingInterceptingMP("a"), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("2")});
        Assert.assertEquals((Object)"0before1beforeabeforebafterbafterabefore2after2after1", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testNestedInterceptingMPChainWithNullReturn() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingInterceptingMP("a"), new ReturnNullInterceptongMP(), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("2")});
        Assert.assertNull((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testNestedInterceptingMPChainWithVoidReturn() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingInterceptingMP("a"), new ReturnVoidMPInterceptongMP(), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("2")});
        Assert.assertEquals((Object)"0before1before2after2after1", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testNestedMixedMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingInterceptingMP("a"), this.getAppendingMP("b")}).build(), new AppendingInterceptingMP("2")});
        Assert.assertEquals((Object)"01beforeabafterabefore2after2", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 2L : 1L), (long)this.threads);
    }

    @Test
    public void testInterceptingMPChainStopFlow() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2", true), new AppendingInterceptingMP("3")});
        Assert.assertEquals((Object)"0before1after1", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testNestedInterceptingMPChainStopFlow() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingInterceptingMP("a", true), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("3")});
        Assert.assertEquals((Object)"0before1before3after3after1", (Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMPChainLifecycle() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP mp1 = new AppendingInterceptingMP("1");
        AppendingInterceptingMP mp2 = new AppendingInterceptingMP("2");
        MessageProcessorChain chain = builder.chain(new MessageProcessor[]{mp1, mp2}).build();
        ((MuleContextAware)chain).setMuleContext((MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        ((FlowConstructAware)chain).setFlowConstruct((FlowConstruct)Mockito.mock(FlowConstruct.class));
        ((Lifecycle)chain).initialise();
        ((Lifecycle)chain).start();
        ((Lifecycle)chain).stop();
        ((Lifecycle)chain).dispose();
        this.assertLifecycle(mp1);
        this.assertLifecycle(mp2);
    }

    @Test
    public void testNestedMPChainLifecycle() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        DefaultMessageProcessorChainBuilder nestedBuilder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP mp1 = new AppendingInterceptingMP("1");
        AppendingInterceptingMP mp2 = new AppendingInterceptingMP("2");
        AppendingInterceptingMP mpa = new AppendingInterceptingMP("a");
        AppendingInterceptingMP mpb = new AppendingInterceptingMP("b");
        MessageProcessorChain chain = builder.chain(new MessageProcessor[]{mp1, nestedBuilder.chain(new MessageProcessor[]{mpa, mpb}).build(), mp2}).build();
        ((MuleContextAware)chain).setMuleContext((MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        ((FlowConstructAware)chain).setFlowConstruct((FlowConstruct)Mockito.mock(FlowConstruct.class));
        ((Lifecycle)chain).initialise();
        ((Lifecycle)chain).start();
        ((Lifecycle)chain).stop();
        ((Lifecycle)chain).dispose();
        this.assertLifecycle(mp1);
        this.assertLifecycle(mp2);
        this.assertLifecycle(mpa);
        this.assertLifecycle(mpb);
    }

    @Test
    public void testNoneIntercepting() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new TestNonIntercepting(), new TestNonIntercepting(), new TestNonIntercepting()});
        MuleEvent restul = this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"MessageProcessorMessageProcessorMessageProcessor", (Object)restul.getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testAllIntercepting() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new TestIntercepting(), new TestIntercepting(), new TestIntercepting()});
        MuleEvent restul = this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"InterceptingMessageProcessorInterceptingMessageProcessorInterceptingMessageProcessor", (Object)restul.getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMix() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting()});
        MuleEvent restul = this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"InterceptingMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessor", (Object)restul.getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMixStaticFactoryt() throws Exception {
        MessageProcessorChain chain = DefaultMessageProcessorChain.from((MessageProcessor[])new MessageProcessor[]{new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting()});
        MuleEvent restul = chain.process(this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"InterceptingMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessor", (Object)restul.getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMix2() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting()});
        MuleEvent restul = this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"MessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessor", (Object)restul.getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testMix2StaticFactory() throws Exception {
        MessageProcessorChain chain = DefaultMessageProcessorChain.from((MessageProcessor[])new MessageProcessor[]{new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting()});
        MuleEvent restul = chain.process(this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"MessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessor", (Object)restul.getMessage().getPayload());
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testOneWayOutboundEndpointWithService() throws Exception {
        MuleEvent event = this.getTestEventUsingFlow("");
        Mockito.when((Object)event.getFlowConstruct()).thenReturn(Mockito.mock(Service.class));
        MessageProcessor mp = (MessageProcessor)Mockito.mock(MessageProcessor.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{OutboundEndpoint.class}));
        OutboundEndpoint outboundEndpoint = (OutboundEndpoint)mp;
        Mockito.when((Object)outboundEndpoint.getExchangePattern()).thenReturn((Object)MessageExchangePattern.ONE_WAY);
        MessageProcessorChain chain = new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{mp}).build();
        MuleEvent response = chain.process(event);
        Assert.assertNull((Object)response);
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testOneWayOutboundEndpointWithFlow() throws Exception {
        MuleEvent event = this.getTestEventUsingFlow("");
        MessageProcessor mp = (MessageProcessor)Mockito.mock(MessageProcessor.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{OutboundEndpoint.class}));
        OutboundEndpoint outboundEndpoint = (OutboundEndpoint)mp;
        Mockito.when((Object)outboundEndpoint.getExchangePattern()).thenReturn((Object)MessageExchangePattern.ONE_WAY);
        Mockito.when((Object)mp.process((MuleEvent)Matchers.any(MuleEvent.class))).thenReturn((Object)VoidMuleEvent.getInstance());
        MessageProcessorChain chain = new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{mp}).build();
        MuleEvent response = chain.process(event);
        Assert.assertThat((Object)event.getId(), (Matcher)CoreMatchers.is((Object)response.getId()));
        Assert.assertThat((Object)event.getMessage(), (Matcher)CoreMatchers.is((Object)response.getMessage()));
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testResponseProcessor() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), new ResponseMessageProcessorAdapter((MessageProcessor)this.getAppendingMP("3")), this.getAppendingMP("2")});
        Assert.assertThat((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessageAsString(), (Matcher)CoreMatchers.equalTo((Object)"0123"));
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 4L : 1L), (long)this.threads);
    }

    @Test
    public void testResponseProcessorInNestedChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), DefaultMessageProcessorChain.from((MessageProcessor[])new MessageProcessor[]{this.getAppendingMP("a"), new ResponseMessageProcessorAdapter((MessageProcessor)this.getAppendingMP("c")), this.getAppendingMP("b")}), this.getAppendingMP("2")});
        Assert.assertThat((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessageAsString(), (Matcher)CoreMatchers.equalTo((Object)"01abc2"));
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 6L : 1L), (long)this.threads);
    }

    @Test
    public void testNestedResponseProcessor() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), new ResponseMessageProcessorAdapter((MessageProcessor)DefaultMessageProcessorChain.from((MessageProcessor[])new MessageProcessor[]{new ResponseMessageProcessorAdapter((MessageProcessor)this.getAppendingMP("4")), this.getAppendingMP("3")})), this.getAppendingMP("2")});
        this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessageAsString();
        Assert.assertThat((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessageAsString(), (Matcher)CoreMatchers.equalTo((Object)"01234"));
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 9L : 1L), (long)this.threads);
    }

    @Test
    public void testNestedResponseProcessorEndOfChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new ResponseMessageProcessorAdapter((MessageProcessor)DefaultMessageProcessorChain.from((MessageProcessor)this.getAppendingMP("1")))});
        this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessageAsString();
        Assert.assertThat((Object)this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0")).getMessageAsString(), (Matcher)CoreMatchers.equalTo((Object)"01"));
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 3L : 1L), (long)this.threads);
    }

    @Test
    public void testAll() throws MuleException, Exception {
        ScatterGatherRouter scatterGatherRouter = new ScatterGatherRouter();
        scatterGatherRouter.addRoute((MessageProcessor)this.getAppendingMP("1"));
        scatterGatherRouter.addRoute((MessageProcessor)this.getAppendingMP("2"));
        scatterGatherRouter.addRoute((MessageProcessor)this.getAppendingMP("3"));
        ThreadingProfile tp = ThreadingProfile.DEFAULT_THREADING_PROFILE;
        tp.setMuleContext(this.muleContext);
        scatterGatherRouter.setThreadingProfile(tp);
        scatterGatherRouter.setMuleContext(this.muleContext);
        scatterGatherRouter.initialise();
        scatterGatherRouter.start();
        MuleEvent event = this.getTestEventUsingFlow("0");
        Assert.assertThat((Object)((List)this.process((MessageProcessor)DefaultMessageProcessorChain.from((MessageProcessor)scatterGatherRouter), (MuleEvent)new DefaultMuleEvent(event.getMessage(), event)).getMessage().getPayload()).toArray(), (Matcher)CoreMatchers.equalTo((Object)new String[]{"01", "02", "03"}));
        Assert.assertEquals((long)1L, (long)this.threads);
    }

    @Test
    public void testChoice() throws MuleException, Exception {
        ChoiceRouter choiceRouter = new ChoiceRouter();
        choiceRouter.addRoute((MessageProcessor)this.getAppendingMP("1"), (Filter)new AcceptAllFilter());
        choiceRouter.addRoute((MessageProcessor)this.getAppendingMP("2"), (Filter)new AcceptAllFilter());
        choiceRouter.addRoute((MessageProcessor)this.getAppendingMP("3"), (Filter)new AcceptAllFilter());
        Assert.assertThat((Object)this.process((MessageProcessor)DefaultMessageProcessorChain.from((MessageProcessor)choiceRouter), this.getTestEventUsingFlow("0")).getMessageAsString(), (Matcher)CoreMatchers.equalTo((Object)"01"));
        Assert.assertEquals((long)(this.isMultipleThreadsUsed() ? 2L : 1L), (long)this.threads);
    }

    @Test(expected=MessagingException.class)
    public void testExceptionAfter() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr()});
        this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0"));
    }

    @Test(expected=MessagingException.class)
    public void testExceptionBefore() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr(), this.getAppendingMP("1")});
        this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0"));
    }

    @Test(expected=MessagingException.class)
    public void testExceptionBetween() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{this.getAppendingMP("1"), new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr(), this.getAppendingMP("2")});
        this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0"));
    }

    @Test(expected=MessagingException.class)
    public void testExceptionInResponse() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new ResponseMessageProcessorAdapter((MessageProcessor)new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr()), this.getAppendingMP("1")});
        this.process((MessageProcessor)builder.build(), this.getTestEventUsingFlow("0"));
    }

    private MuleEvent process(MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        MuleEvent result;
        if (this.nonBlocking && this.exchangePattern.hasResponse()) {
            SensingNullReplyToHandler nullReplyToHandler = new SensingNullReplyToHandler();
            event = new DefaultMuleEvent(event, (ReplyToHandler)nullReplyToHandler);
            result = messageProcessor.process(event);
            if (NonBlockingVoidMuleEvent.getInstance() == result) {
                nullReplyToHandler.latch.await(1000L, TimeUnit.MILLISECONDS);
                if (nullReplyToHandler.exception != null) {
                    throw nullReplyToHandler.exception;
                }
                result = nullReplyToHandler.event;
            }
        } else {
            result = messageProcessor.process(event);
        }
        return result;
    }

    private AppendingMP getAppendingMP(String append) {
        if (this.nonBlocking) {
            return new NonBlockingAppendingMP(append);
        }
        return new AppendingMP(append);
    }

    private boolean isMultipleThreadsUsed() {
        return this.nonBlocking && this.exchangePattern.hasResponse() && !this.synchronous;
    }

    private void assertLifecycle(AppendingMP mp) {
        Assert.assertTrue((boolean)mp.flowConstuctInjected);
        Assert.assertTrue((boolean)mp.muleContextInjected);
        Assert.assertTrue((boolean)mp.initialised);
        Assert.assertTrue((boolean)mp.started);
        Assert.assertTrue((boolean)mp.stopped);
        Assert.assertTrue((boolean)mp.disposed);
    }

    private void assertLifecycle(AppendingInterceptingMP mp) {
        Assert.assertTrue((boolean)mp.flowConstuctInjected);
        Assert.assertTrue((boolean)mp.muleContextInjected);
        Assert.assertTrue((boolean)mp.initialised);
        Assert.assertTrue((boolean)mp.started);
        Assert.assertTrue((boolean)mp.stopped);
        Assert.assertTrue((boolean)mp.disposed);
    }

    protected MuleEvent getTestEventUsingFlow(Object data) throws Exception {
        MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
        DefaultMuleMessage message = new DefaultMuleMessage(data, this.muleContext);
        Mockito.when((Object)event.getId()).thenReturn((Object)RandomStringUtils.randomNumeric((int)3));
        Mockito.when((Object)event.getMessage()).thenReturn((Object)message);
        Mockito.when((Object)event.getExchangePattern()).thenReturn((Object)this.exchangePattern);
        Mockito.when((Object)event.getMuleContext()).thenReturn((Object)this.muleContext);
        Mockito.when((Object)event.getFlowConstruct()).thenReturn(Mockito.mock(Flow.class));
        Mockito.when((Object)event.getSession()).thenReturn(Mockito.mock(MuleSession.class));
        Mockito.when((Object)event.isSynchronous()).thenReturn((Object)this.synchronous);
        Mockito.when((Object)event.isAllowNonBlocking()).thenReturn((Object)(!this.synchronous && this.exchangePattern.hasResponse() ? 1 : 0));
        return event;
    }

    static class ReturnVoidMPInterceptongMP
    extends AbstractInterceptingMessageProcessor {
        ReturnVoidMPInterceptongMP() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            return VoidMuleEvent.getInstance();
        }
    }

    private static class ReturnVoidMP
    implements MessageProcessor {
        MuleEvent event;

        private ReturnVoidMP() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.event = event;
            return VoidMuleEvent.getInstance();
        }
    }

    static class ReturnNullInterceptongMP
    extends AbstractInterceptingMessageProcessor {
        ReturnNullInterceptongMP() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            return null;
        }
    }

    static class ReturnNullMP
    implements MessageProcessor {
        MuleEvent event;

        ReturnNullMP() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.event = event;
            return null;
        }
    }

    class AppendingInterceptingMP
    extends AbstractInterceptingMessageProcessor
    implements FlowConstructAware,
    Lifecycle {
        String appendString;
        boolean muleContextInjected;
        boolean flowConstuctInjected;
        boolean initialised;
        boolean started;
        boolean stopped;
        boolean disposed;
        MuleEvent event;
        MuleEvent resultEvent;
        private boolean stopProcessing;
        boolean invoked = false;

        public AppendingInterceptingMP(String appendString) {
            this(appendString, false);
        }

        public AppendingInterceptingMP(String appendString, boolean stopProcessing) {
            this.appendString = appendString;
            this.stopProcessing = stopProcessing;
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            if (this.stopProcessing) {
                return event;
            }
            DefaultMuleEvent intermediateEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)(event.getMessage().getPayload() + "before" + this.appendString), DefaultMessageProcessorChainTestCase.this.muleContext), event);
            MuleEvent result = this.processNext((MuleEvent)intermediateEvent);
            if (result != null && !result.equals(VoidMuleEvent.getInstance()) && !result.equals(NonBlockingVoidMuleEvent.getInstance())) {
                return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)(result.getMessage().getPayload() + "after" + this.appendString), DefaultMessageProcessorChainTestCase.this.muleContext), result);
            }
            return result;
        }

        public void initialise() throws InitialisationException {
            this.initialised = true;
        }

        public void start() throws MuleException {
            this.started = true;
        }

        public void stop() throws MuleException {
            this.stopped = true;
        }

        public void dispose() {
            this.disposed = true;
        }

        public String toString() {
            return ObjectUtils.toString((Object)((Object)this));
        }

        public void setMuleContext(MuleContext context) {
            this.muleContextInjected = true;
        }

        public void setFlowConstruct(FlowConstruct flowConstruct) {
            this.flowConstuctInjected = true;
        }
    }

    class AppendingMP
    implements MessageProcessor,
    Lifecycle,
    FlowConstructAware,
    MuleContextAware {
        String appendString;
        boolean muleContextInjected;
        boolean flowConstuctInjected;
        boolean initialised;
        boolean started;
        boolean stopped;
        boolean disposed;
        MuleEvent event;
        MuleEvent resultEvent;

        public AppendingMP(String append) {
            this.appendString = append;
        }

        public MuleEvent process(final MuleEvent event) throws MuleException {
            if (DefaultMessageProcessorChainTestCase.this.nonBlocking && event.isAllowNonBlocking()) {
                DefaultMessageProcessorChainTestCase.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DefaultMessageProcessorChainTestCase.this.threads++;
                            event.getReplyToHandler().processReplyTo(AppendingMP.this.innerProcess(event), null, null);
                        }
                        catch (MessagingException e) {
                            event.getReplyToHandler().processExceptionReplyTo(e, null);
                        }
                        catch (MuleException e) {
                            e.printStackTrace();
                        }
                    }
                });
                return NonBlockingVoidMuleEvent.getInstance();
            }
            return this.innerProcess(event);
        }

        private MuleEvent innerProcess(MuleEvent event) {
            this.event = event;
            DefaultMuleEvent result = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)(event.getMessage().getPayload() + this.appendString), DefaultMessageProcessorChainTestCase.this.muleContext), event);
            this.resultEvent = result;
            return result;
        }

        public void initialise() throws InitialisationException {
            this.initialised = true;
        }

        public void start() throws MuleException {
            this.started = true;
        }

        public void stop() throws MuleException {
            this.stopped = true;
        }

        public void dispose() {
            this.disposed = true;
        }

        public String toString() {
            return ObjectUtils.toString((Object)this);
        }

        public void setMuleContext(MuleContext context) {
            this.muleContextInjected = true;
        }

        public void setFlowConstruct(FlowConstruct flowConstruct) {
            this.flowConstuctInjected = true;
        }
    }

    class NonBlockingAppendingMP
    extends AppendingMP
    implements NonBlockingMessageProcessor {
        public NonBlockingAppendingMP(String append) {
            super(append);
        }
    }

    static class TestIntercepting
    extends AbstractInterceptingMessageProcessor {
        TestIntercepting() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            return this.processNext(new StringAppendTransformer("InterceptingMessageProcessor").process(event));
        }
    }

    static class TestNonIntercepting
    implements MessageProcessor {
        TestNonIntercepting() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            return new StringAppendTransformer("MessageProcessor").process(event);
        }
    }
}

