/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.chain;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.MessageExchangePattern;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorContainer;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.api.processor.ProcessorExecutor;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.NonBlockingProcessorExecutor;
import org.mule.processor.chain.BlockingProcessorExecutorTestCase;
import org.mule.tck.SensingNullReplyToHandler;

@RunWith(value=MockitoJUnitRunner.class)
public class NonBlockingProcessorExecutorTestCase
extends BlockingProcessorExecutorTestCase {
    private static final int LATCH_TIMEOUT = 50;
    private static final String TEST_MESSAGE = "abc";
    private SensingNullReplyToHandler nullReplyToHandler = new SensingNullReplyToHandler();

    @Override
    public void before() throws MessagingException {
        super.before();
        Mockito.when((Object)this.event.getReplyToHandler()).thenReturn((Object)this.nullReplyToHandler);
        Mockito.when((Object)this.event.getExchangePattern()).thenReturn((Object)MessageExchangePattern.REQUEST_RESPONSE);
        Mockito.when((Object)this.event.isSynchronous()).thenReturn((Object)false);
        Mockito.when((Object)this.event.isAllowNonBlocking()).thenReturn((Object)true);
    }

    @Override
    protected Matcher<MuleEvent> requestResponseMatecher() {
        return CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)this.event));
    }

    @Test
    public void executeRequestResponseNonBlocking() throws MuleException, InterruptedException {
        this.setupNonBlockingRequestResponseEvent();
        this.assertNonBlockingExecution(this.processors);
    }

    @Test
    public void executeRequestResponseWithInterceptingMPBlocking() throws MuleException, InterruptedException {
        this.processors.clear();
        this.processors.add(new AbstractInterceptingMessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return this.processNext(event);
            }
        });
        this.processors.add(this.processor1);
        this.processors.add(this.processor2);
        this.processors.add(this.processor3);
        this.assertBlockingExecution(this.processors, (Matcher<MuleEvent>)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)this.event)));
        Assert.assertThat((Object)this.processor1.event.getReplyToHandler(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void executeRequestResponseWithMPContainerBlocking() throws MuleException, InterruptedException {
        this.processors.clear();
        this.processors.add(new TestContainerMessageProcessor());
        this.processors.add(this.processor2);
        this.processors.add(this.processor3);
        this.assertBlockingExecution(this.processors, (Matcher<MuleEvent>)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)this.event)));
        Assert.assertThat((Object)this.processor1.event.getReplyToHandler(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void executeRequestResponseNonBlockingNullResponse() throws MuleException, InterruptedException {
        this.processors.add(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return null;
            }
        });
        this.setupNonBlockingRequestResponseEvent();
        this.createProcessorExecutor(this.processors).execute();
        Assert.assertThat((Object)this.nullReplyToHandler.latch.await(50L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.nullReplyToHandler.event, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void executeRequestResponseNonBlockingVoidResponse() throws MuleException, InterruptedException {
        VoidMuleEvent voidResult = VoidMuleEvent.getInstance();
        this.processors.add(new MessageProcessor((MuleEvent)voidResult){
            final /* synthetic */ MuleEvent val$voidResult;
            {
                this.val$voidResult = muleEvent;
            }

            public MuleEvent process(MuleEvent event) throws MuleException {
                return this.val$voidResult;
            }
        });
        this.setupNonBlockingRequestResponseEvent();
        MuleEvent request = this.event;
        this.createProcessorExecutor(this.processors).execute();
        Assert.assertThat((Object)this.nullReplyToHandler.latch.await(50L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.nullReplyToHandler.event, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)this.nullReplyToHandler.event, (Matcher)CoreMatchers.not((Object)VoidMuleEvent.getInstance()));
    }

    @Override
    protected ProcessorExecutor createProcessorExecutor(List<MessageProcessor> processors) {
        return new NonBlockingProcessorExecutor(this.event, processors, this.executionTemplate, true);
    }

    private void assertNonBlockingExecution(List<MessageProcessor> processors) throws MuleException, InterruptedException {
        ProcessorExecutor executor = this.createProcessorExecutor(processors);
        if (this.event.getExchangePattern() == MessageExchangePattern.REQUEST_RESPONSE) {
            Assert.assertThat((Object)executor.execute(), (Matcher)CoreMatchers.equalTo((Object)NonBlockingVoidMuleEvent.getInstance()));
        } else {
            Assert.assertThat((Object)executor.execute(), (Matcher)CoreMatchers.equalTo((Object)this.event));
        }
        Assert.assertThat((Object)this.nullReplyToHandler.latch.await(50L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.processor1.event, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.processor1.thread, (Matcher)CoreMatchers.equalTo((Object)Thread.currentThread()));
        Assert.assertThat((Object)this.processor2.event, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.processor2.thread, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.processor1.thread)));
        Assert.assertThat((Object)this.processor3.event, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.processor3.thread, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.processor2.thread)));
        Assert.assertThat((Object)this.nullReplyToHandler.event.getMessageAsString(), (Matcher)CoreMatchers.equalTo((Object)RESULT));
    }

    private void setupNonBlockingRequestResponseEvent() {
        Mockito.when((Object)this.event.getExchangePattern()).thenReturn((Object)MessageExchangePattern.REQUEST_RESPONSE);
        Mockito.when((Object)this.event.isSynchronous()).thenReturn((Object)false);
        Mockito.when((Object)this.event.isAllowNonBlocking()).thenReturn((Object)true);
        Mockito.when((Object)this.event.getReplyToHandler()).thenReturn((Object)this.nullReplyToHandler);
    }

    private class TestContainerMessageProcessor
    implements MessageProcessor,
    MessageProcessorContainer {
        private TestContainerMessageProcessor() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            return NonBlockingProcessorExecutorTestCase.this.processor1.process(event);
        }

        public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
        }
    }
}

