/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.ExceptionPayload;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.retry.RetryPolicyExhaustedException;
import org.mule.routing.AsynchronousUntilSuccessfulProcessingStrategy;
import org.mule.routing.UntilSuccessfulConfiguration;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.concurrent.Latch;
import org.mule.util.store.SimpleMemoryObjectStore;

@SmallTest
public class AsynchronousUntilSuccessfulProcessingStrategyTestCase
extends AbstractMuleTestCase {
    private static final String EXPECTED_FAILURE_MSG = "expected failure";
    private static final int DEFAULT_RETRIES = 4;
    private static final int DEFAULT_TRIES = 5;
    private final Latch exceptionHandlingLatch = new Latch();
    private UntilSuccessfulConfiguration mockUntilSuccessfulConfiguration = (UntilSuccessfulConfiguration)Mockito.mock(UntilSuccessfulConfiguration.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private MuleEvent mockEvent = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private MessageProcessor mockRoute = (MessageProcessor)Mockito.mock(MessageProcessor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ExpressionFilter mockAlwaysTrueFailureExpressionFilter = (ExpressionFilter)Mockito.mock(ExpressionFilter.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ThreadPoolExecutor mockPool = (ThreadPoolExecutor)Mockito.mock(ThreadPoolExecutor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ScheduledThreadPoolExecutor mockScheduledPool = (ScheduledThreadPoolExecutor)Mockito.mock(ScheduledThreadPoolExecutor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private SimpleMemoryObjectStore<MuleEvent> objectStore = new SimpleMemoryObjectStore();
    private MessageProcessor mockDLQ = (MessageProcessor)Mockito.mock(MessageProcessor.class);
    private FailCallback failRoute = new FailCallback(){

        @Override
        public void doFail() throws MessagingException {
        }
    };
    private CountDownLatch routeCountDownLatch;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.mockAlwaysTrueFailureExpressionFilter.accept((MuleMessage)Matchers.any(MuleMessage.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getRoute()).thenReturn((Object)this.mockRoute);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getAckExpression()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getMaxRetries()).thenReturn((Object)4);
        Mockito.when((Object)this.mockEvent.getMessage().getInvocationProperty("process.attempt.count", (Object)1)).thenAnswer((Answer)new Answer<Object>(){
            private int numberOfAttempts = 0;

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return this.numberOfAttempts++;
            }
        });
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getThreadingProfile().createPool(Matchers.anyString())).thenReturn((Object)this.mockPool);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.createScheduledRetriesPool(Matchers.anyString())).thenReturn((Object)this.mockScheduledPool);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getObjectStore()).thenReturn(this.objectStore);
        this.objectStore.clear();
        this.configureMockPoolToInvokeRunnableInNewThread();
        this.configureMockScheduledPoolToInvokeRunnableInNewThread();
        this.configureMockRouteToCountDownRouteLatch();
        this.configureExceptionStrategyToReleaseLatchWhenExecuted();
        this.configureDLQToReleaseLatchWhenExecuted();
    }

    @Test(expected=InitialisationException.class)
    public void failWhenObjectStoreIsNull() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getObjectStore()).thenReturn(null);
        this.createProcessingStrategy();
    }

    @Test
    public void alwaysFail() throws Exception {
        this.executeUntilSuccessfulFailingRoute(new FailCallback(){

            @Override
            public void doFail() {
                throw new RuntimeException(AsynchronousUntilSuccessfulProcessingStrategyTestCase.EXPECTED_FAILURE_MSG);
            }
        });
        this.waitUntilRouteIsExecuted();
    }

    @Test
    public void alwaysFailUsingFailureExpression() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        this.executeUntilSuccessfulFailingRoute(new FailCallback(){

            @Override
            public void doFail() {
                throw new RuntimeException(AsynchronousUntilSuccessfulProcessingStrategyTestCase.EXPECTED_FAILURE_MSG);
            }
        });
        this.waitUntilRouteIsExecuted();
        this.waitUntilExceptionIsHandled();
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockEvent.getFlowConstruct().getExceptionListener(), (VerificationMode)Mockito.times((int)1))).handleException((Exception)Matchers.argThat((Matcher)new ArgumentMatcher<Exception>(){

            public boolean matches(Object item) {
                return item instanceof RetryPolicyExhaustedException && AsynchronousUntilSuccessfulProcessingStrategyTestCase.EXPECTED_FAILURE_MSG.equals(((RetryPolicyExhaustedException)item).getCause().getMessage());
            }
        }), (MuleEvent)Matchers.eq((Object)this.mockEvent));
        ((MessageProcessor)Mockito.verify((Object)this.mockDLQ, (VerificationMode)Mockito.never())).process((MuleEvent)Matchers.any(MuleEvent.class));
    }

    @Test
    public void alwaysFailMessageUsingFailureExpression() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        this.executeUntilSuccessfulFailingRoute(new FailCallback(){

            @Override
            public void doFail() throws MessagingException {
                throw new MessagingException(CoreMessages.createStaticMessage((String)AsynchronousUntilSuccessfulProcessingStrategyTestCase.EXPECTED_FAILURE_MSG), AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.mockEvent, AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.mockRoute);
            }
        });
        this.waitUntilRouteIsExecuted();
        this.waitUntilExceptionIsHandled();
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockEvent.getFlowConstruct().getExceptionListener(), (VerificationMode)Mockito.times((int)1))).handleException((Exception)Matchers.argThat((Matcher)new ArgumentMatcher<Exception>(){

            public boolean matches(Object item) {
                return item instanceof RetryPolicyExhaustedException && ((RetryPolicyExhaustedException)item).getMessage().contains("until-successful retries exhausted. Last exception message was: expected failure");
            }
        }), (MuleEvent)Matchers.eq((Object)this.mockEvent));
        ((MessageProcessor)Mockito.verify((Object)this.mockDLQ, (VerificationMode)Mockito.never())).process((MuleEvent)Matchers.any(MuleEvent.class));
    }

    @Test
    public void alwaysFailMessageWrapUsingFailureExpression() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        this.executeUntilSuccessfulFailingRoute(new FailCallback(){

            @Override
            public void doFail() throws MessagingException {
                throw new MessagingException(AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.mockEvent, (Throwable)new RuntimeException(AsynchronousUntilSuccessfulProcessingStrategyTestCase.EXPECTED_FAILURE_MSG));
            }
        });
        this.waitUntilRouteIsExecuted();
        this.waitUntilExceptionIsHandled();
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockEvent.getFlowConstruct().getExceptionListener(), (VerificationMode)Mockito.times((int)1))).handleException((Exception)Matchers.argThat((Matcher)new ArgumentMatcher<Exception>(){

            public boolean matches(Object item) {
                return item instanceof RetryPolicyExhaustedException && ((RetryPolicyExhaustedException)item).getMessage().contains("until-successful retries exhausted. Last exception message was: expected failure");
            }
        }), (MuleEvent)Matchers.eq((Object)this.mockEvent));
        ((MessageProcessor)Mockito.verify((Object)this.mockDLQ, (VerificationMode)Mockito.never())).process((MuleEvent)Matchers.any(MuleEvent.class));
    }

    @Test
    public void alwaysFailUsingFailureExpressionDLQ() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn((Object)this.mockDLQ);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        this.executeUntilSuccessfulFailingRoute(new FailCallback(){

            @Override
            public void doFail() {
                throw new RuntimeException(AsynchronousUntilSuccessfulProcessingStrategyTestCase.EXPECTED_FAILURE_MSG);
            }
        });
        this.waitUntilRouteIsExecuted();
        this.waitUntilExceptionIsHandled();
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockEvent.getFlowConstruct().getExceptionListener(), (VerificationMode)Mockito.never())).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class));
        ((MessageProcessor)Mockito.verify((Object)this.mockDLQ, (VerificationMode)Mockito.times((int)1))).process((MuleEvent)Matchers.argThat((Matcher)new ArgumentMatcher<MuleEvent>(){

            public boolean matches(Object argument) {
                MuleEvent argEvent = (MuleEvent)argument;
                ((MuleMessage)Mockito.verify((Object)argEvent.getMessage(), (VerificationMode)Mockito.times((int)1))).setExceptionPayload((ExceptionPayload)Matchers.argThat((Matcher)new ArgumentMatcher<ExceptionPayload>(){

                    public boolean matches(Object argument) {
                        Assert.assertThat((Object)((ExceptionPayload)argument).getException().getMessage(), (Matcher)CoreMatchers.containsString((String)"until-successful retries exhausted. Last exception message was: expected failure"));
                        return true;
                    }
                }));
                return true;
            }
        }));
    }

    @Test
    public void alwaysFailMessageUsingFailureExpressionDLQ() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn((Object)this.mockDLQ);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        this.executeUntilSuccessfulFailingRoute(new FailCallback(){

            @Override
            public void doFail() throws MessagingException {
                throw new MessagingException(CoreMessages.createStaticMessage((String)AsynchronousUntilSuccessfulProcessingStrategyTestCase.EXPECTED_FAILURE_MSG), AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.mockEvent, AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.mockRoute);
            }
        });
        this.waitUntilRouteIsExecuted();
        this.waitUntilExceptionIsHandled();
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockEvent.getFlowConstruct().getExceptionListener(), (VerificationMode)Mockito.never())).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class));
        ((MessageProcessor)Mockito.verify((Object)this.mockDLQ, (VerificationMode)Mockito.times((int)1))).process((MuleEvent)Matchers.argThat((Matcher)new ArgumentMatcher<MuleEvent>(){

            public boolean matches(Object argument) {
                MuleEvent argEvent = (MuleEvent)argument;
                ((MuleMessage)Mockito.verify((Object)argEvent.getMessage(), (VerificationMode)Mockito.times((int)1))).setExceptionPayload((ExceptionPayload)Matchers.argThat((Matcher)new ArgumentMatcher<ExceptionPayload>(){

                    public boolean matches(Object argument) {
                        Assert.assertThat((Object)((ExceptionPayload)argument).getException().getMessage(), (Matcher)CoreMatchers.containsString((String)"until-successful retries exhausted. Last exception message was: expected failure"));
                        return true;
                    }
                }));
                return true;
            }
        }));
    }

    @Test
    public void alwaysFailMessageWrapUsingFailureExpressionDLQ() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn((Object)this.mockDLQ);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        this.executeUntilSuccessfulFailingRoute(new FailCallback(){

            @Override
            public void doFail() throws MessagingException {
                throw new MessagingException(AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.mockEvent, (Throwable)new RuntimeException(AsynchronousUntilSuccessfulProcessingStrategyTestCase.EXPECTED_FAILURE_MSG));
            }
        });
        this.waitUntilRouteIsExecuted();
        this.waitUntilExceptionIsHandled();
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockEvent.getFlowConstruct().getExceptionListener(), (VerificationMode)Mockito.never())).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class));
        ((MessageProcessor)Mockito.verify((Object)this.mockDLQ, (VerificationMode)Mockito.times((int)1))).process((MuleEvent)Matchers.argThat((Matcher)new ArgumentMatcher<MuleEvent>(){

            public boolean matches(Object argument) {
                MuleEvent argEvent = (MuleEvent)argument;
                ((MuleMessage)Mockito.verify((Object)argEvent.getMessage(), (VerificationMode)Mockito.times((int)1))).setExceptionPayload((ExceptionPayload)Matchers.argThat((Matcher)new ArgumentMatcher<ExceptionPayload>(){

                    public boolean matches(Object argument) {
                        Assert.assertThat((Object)((ExceptionPayload)argument).getException().getMessage(), (Matcher)CoreMatchers.containsString((String)"until-successful retries exhausted. Last exception message was: expected failure"));
                        return true;
                    }
                }));
                return true;
            }
        }));
    }

    @Test
    public void successfulExecution() throws Exception {
        this.executeUntilSuccessful();
        this.waitUntilRouteIsExecuted();
        ((MessageProcessor)Mockito.verify((Object)this.mockRoute, (VerificationMode)Mockito.times((int)1))).process(this.mockEvent);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockEvent.getFlowConstruct().getExceptionListener(), (VerificationMode)Mockito.never())).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.eq((Object)this.mockEvent));
    }

    @Test
    public void successfulExecutionWithAckExpression() throws Exception {
        String ackExpression = "some-expression";
        String expressionEvalutaionResult = "new payload";
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getAckExpression()).thenReturn((Object)ackExpression);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getMuleContext().getExpressionManager().evaluate(ackExpression, this.mockEvent)).thenReturn((Object)expressionEvalutaionResult);
        this.executeUntilSuccessful();
        this.waitUntilRouteIsExecuted();
        ((MessageProcessor)Mockito.verify((Object)this.mockRoute, (VerificationMode)Mockito.times((int)1))).process(this.mockEvent);
        ((ExpressionManager)Mockito.verify((Object)this.mockUntilSuccessfulConfiguration.getMuleContext().getExpressionManager(), (VerificationMode)Mockito.times((int)1))).evaluate(ackExpression, this.mockEvent);
        ((MuleMessage)Mockito.verify((Object)this.mockEvent.getMessage(), (VerificationMode)Mockito.times((int)1))).setPayload((Object)expressionEvalutaionResult);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockEvent.getFlowConstruct().getExceptionListener(), (VerificationMode)Mockito.never())).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.eq((Object)this.mockEvent));
    }

    private void executeUntilSuccessfulFailingRoute(FailCallback failCallback) throws Exception {
        this.failRoute = failCallback;
        this.routeCountDownLatch = new CountDownLatch(5);
        AsynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        processingStrategy.route(this.mockEvent);
    }

    private void executeUntilSuccessful() throws Exception {
        this.routeCountDownLatch = new Latch();
        AsynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        processingStrategy.route(this.mockEvent);
    }

    private void configureMockRouteToCountDownRouteLatch() throws MuleException {
        Mockito.when((Object)this.mockRoute.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.routeCountDownLatch.countDown();
                AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.failRoute.doFail();
                return invocationOnMock.getArguments()[0];
            }
        });
    }

    private void configureMockPoolToInvokeRunnableInNewThread() {
        ((ThreadPoolExecutor)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(final InvocationOnMock invocationOnMock) throws Throwable {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ((Runnable)invocationOnMock.getArguments()[0]).run();
                    }
                }).start();
                return null;
            }
        }).when((Object)this.mockPool)).execute((Runnable)Matchers.any(Runnable.class));
    }

    private void configureMockScheduledPoolToInvokeRunnableInNewThread() {
        Mockito.when(this.mockScheduledPool.schedule((Callable)Matchers.any(Callable.class), Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(final InvocationOnMock invocationOnMock) throws Throwable {
                Assert.assertThat((Object)((Long)invocationOnMock.getArguments()[1]), (Matcher)CoreMatchers.is((Object)AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.mockUntilSuccessfulConfiguration.getMillisBetweenRetries()));
                Assert.assertThat((Object)((Object)((TimeUnit)((Object)invocationOnMock.getArguments()[2]))), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.MILLISECONDS)));
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((Callable)invocationOnMock.getArguments()[0]).call();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }).start();
                return null;
            }
        });
    }

    private void waitUntilRouteIsExecuted() throws InterruptedException {
        if (!this.routeCountDownLatch.await(200000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)("route should be executed " + this.routeCountDownLatch.getCount() + " times"));
        }
    }

    private AsynchronousUntilSuccessfulProcessingStrategy createProcessingStrategy() throws Exception {
        AsynchronousUntilSuccessfulProcessingStrategy processingStrategy = new AsynchronousUntilSuccessfulProcessingStrategy(){

            protected MuleEvent threadSafeCopy(MuleEvent event) {
                return event;
            }
        };
        processingStrategy.setUntilSuccessfulConfiguration(this.mockUntilSuccessfulConfiguration);
        processingStrategy.setMessagingExceptionHandler(this.mockEvent.getFlowConstruct().getExceptionListener());
        processingStrategy.initialise();
        processingStrategy.start();
        return processingStrategy;
    }

    private void waitUntilExceptionIsHandled() throws InterruptedException {
        if (!this.exceptionHandlingLatch.await(100000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"exception should be handled");
        }
    }

    private void configureExceptionStrategyToReleaseLatchWhenExecuted() {
        Mockito.when((Object)this.mockEvent.getFlowConstruct().getExceptionListener().handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.exceptionHandlingLatch.release();
                return null;
            }
        });
    }

    private void configureDLQToReleaseLatchWhenExecuted() throws MuleException {
        Mockito.when((Object)this.mockDLQ.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.exceptionHandlingLatch.release();
                return null;
            }
        });
    }

    private static interface FailCallback {
        public void doFail() throws Exception;
    }
}

