/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMessageCollection;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.routing.RouterResultsHandler;
import org.mule.construct.Flow;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.processor.strategy.SynchronousProcessingStrategy;
import org.mule.routing.DefaultRouterResultsHandler;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transaction.MuleTransactionConfig;

public class DefaultRouterResultsHandlerTestCase
extends AbstractMuleContextTestCase {
    protected RouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
    protected MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    protected MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
    protected InboundEndpoint endpoint = (InboundEndpoint)Mockito.mock(InboundEndpoint.class);
    protected Flow flow = (Flow)Mockito.mock(Flow.class);

    @Before
    public void setupMocks() throws EndpointException {
        Mockito.when((Object)this.endpoint.getEndpointURI()).thenReturn((Object)new MuleEndpointURI("test://test", this.muleContext));
        Mockito.when((Object)this.endpoint.getTransactionConfig()).thenReturn((Object)new MuleTransactionConfig());
        Mockito.when((Object)this.endpoint.getExchangePattern()).thenReturn((Object)MessageExchangePattern.ONE_WAY);
        Mockito.when((Object)this.flow.getProcessingStrategy()).thenReturn((Object)new SynchronousProcessingStrategy());
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn(Mockito.mock(MuleConfiguration.class));
    }

    @Test
    public void aggregateNoEvent() {
        MuleEvent result = this.resultsHandler.aggregateResults(Collections.singletonList(null), (MuleEvent)Mockito.mock(MuleEvent.class), this.muleContext);
        Assert.assertNull((Object)result);
    }

    @Test
    public void aggregateSingleEvent() {
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A", this.muleContext);
        message1.setInvocationProperty("key1", (Object)"value1");
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, this.endpoint, (FlowConstruct)this.flow);
        event1.getSession().setProperty("key", (Serializable)((Object)"value"));
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B", this.muleContext);
        message2.setInvocationProperty("key2", (Object)"value2");
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)message2, this.endpoint, (FlowConstruct)this.flow);
        event2.getSession().setProperty("key", (Serializable)((Object)"valueNEW"));
        event2.getSession().setProperty("key1", (Serializable)((Object)"value1"));
        MuleEvent result = this.resultsHandler.aggregateResults(Collections.singletonList(event2), (MuleEvent)event1, this.muleContext);
        Assert.assertSame((Object)event2, (Object)result);
        Assert.assertNull((Object)result.getMessage().getInvocationProperty("key1"));
        Assert.assertEquals((Object)"value2", (Object)result.getMessage().getInvocationProperty("key2"));
        Assert.assertEquals((Object)"valueNEW", (Object)result.getSession().getProperty("key"));
        Assert.assertEquals((Object)"value1", (Object)result.getSession().getProperty("key1"));
    }

    @Test
    public void aggregateMultipleEvents() throws Exception {
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A", this.muleContext);
        message1.setInvocationProperty("key1", (Object)"value1");
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B", this.muleContext);
        message2.setInvocationProperty("key2", (Object)"value2");
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)"test event C", this.muleContext);
        message3.setInvocationProperty("key3", (Object)"value3");
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, this.endpoint, (FlowConstruct)this.flow);
        MuleSession session = event1.getSession();
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)message2, this.endpoint, (FlowConstruct)this.flow, session);
        DefaultMuleEvent event3 = new DefaultMuleEvent((MuleMessage)message3, this.endpoint, (FlowConstruct)this.flow, session);
        event1.getSession().setProperty("key", (Serializable)((Object)"value"));
        event2.getSession().setProperty("key1", (Serializable)((Object)"value1"));
        event2.getSession().setProperty("key2", (Serializable)((Object)"value2"));
        event3.getSession().setProperty("KEY2", (Serializable)((Object)"value2NEW"));
        event3.getSession().setProperty("key3", (Serializable)((Object)"value3"));
        ArrayList<DefaultMuleEvent> events = new ArrayList<DefaultMuleEvent>();
        events.add(event2);
        events.add(event3);
        MuleEvent result = this.resultsHandler.aggregateResults(events, (MuleEvent)event1, this.muleContext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(DefaultMessageCollection.class, result.getMessage().getClass());
        Assert.assertEquals((long)2L, (long)((MuleMessageCollection)result.getMessage()).size());
        Assert.assertTrue((boolean)(result.getMessage().getPayload() instanceof List));
        Assert.assertEquals((Object)message2, (Object)((MuleMessageCollection)result.getMessage()).getMessage(0));
        Assert.assertEquals((Object)message3, (Object)((MuleMessageCollection)result.getMessage()).getMessage(1));
        Assert.assertNull((Object)result.getMessage().getInvocationProperty("key2"));
        Assert.assertNull((Object)result.getMessage().getInvocationProperty("key3"));
        Assert.assertEquals((Object)event1.getMessage().getMessageRootId(), (Object)result.getMessage().getMessageRootId());
        Assert.assertEquals((Object)"value", (Object)result.getSession().getProperty("key"));
        Assert.assertEquals((Object)"value1", (Object)result.getSession().getProperty("key1"));
        Assert.assertEquals((Object)"value2NEW", (Object)result.getSession().getProperty("key2"));
        Assert.assertEquals((Object)"value3", (Object)result.getSession().getProperty("key3"));
        Assert.assertNull((Object)result.getSession().getProperty("key4"));
    }

    @Test
    public void aggregateMultipleEventsAllButOneNull() {
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A", this.muleContext);
        message1.setInvocationProperty("key", (Object)"value");
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B", this.muleContext);
        message2.setInvocationProperty("key2", (Object)"value2");
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, this.endpoint, (FlowConstruct)this.flow);
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)message2, this.endpoint, (FlowConstruct)this.flow);
        ArrayList<DefaultMuleEvent> events = new ArrayList<DefaultMuleEvent>();
        events.add(null);
        events.add(event2);
        MuleEvent result = this.resultsHandler.aggregateResults(events, (MuleEvent)event1, this.muleContext);
        Assert.assertSame((Object)event2, (Object)result);
        Assert.assertNull((Object)result.getMessage().getInvocationProperty("key1"));
        Assert.assertEquals((Object)"value2", (Object)result.getMessage().getInvocationProperty("key2"));
    }

    @Test
    public void aggregateSingleMuleMessageCollection() {
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A", this.muleContext);
        message1.setInvocationProperty("key1", (Object)"value1");
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, this.endpoint, (FlowConstruct)this.flow);
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B", this.muleContext);
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)"test event C", this.muleContext);
        DefaultMessageCollection messageCollection = new DefaultMessageCollection(this.muleContext);
        messageCollection.setInvocationProperty("key2", (Object)"value2");
        messageCollection.addMessage((MuleMessage)message2);
        messageCollection.addMessage((MuleMessage)message3);
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)messageCollection, this.endpoint, (FlowConstruct)this.flow);
        MuleEvent result = this.resultsHandler.aggregateResults(Collections.singletonList(event2), (MuleEvent)event1, this.muleContext);
        Assert.assertSame((Object)event2, (Object)result);
        Assert.assertNull((Object)result.getMessage().getInvocationProperty("key1"));
        Assert.assertEquals((Object)"value2", (Object)result.getMessage().getInvocationProperty("key2"));
    }

    @Test
    public void aggregateMultipleMuleMessageCollections() {
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A", this.muleContext);
        message1.setInvocationProperty("key1", (Object)"value1");
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, this.endpoint, (FlowConstruct)this.flow);
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B", this.muleContext);
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)"test event C", this.muleContext);
        DefaultMuleMessage message4 = new DefaultMuleMessage((Object)"test event D", this.muleContext);
        DefaultMuleMessage message5 = new DefaultMuleMessage((Object)"test event E", this.muleContext);
        DefaultMessageCollection messageCollection = new DefaultMessageCollection(this.muleContext);
        messageCollection.setInvocationProperty("key2", (Object)"value2");
        messageCollection.addMessage((MuleMessage)message2);
        messageCollection.addMessage((MuleMessage)message3);
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)messageCollection, this.endpoint, (FlowConstruct)this.flow);
        DefaultMessageCollection messageCollection2 = new DefaultMessageCollection(this.muleContext);
        messageCollection.setInvocationProperty("key3", (Object)"value3");
        messageCollection.addMessage((MuleMessage)message4);
        messageCollection.addMessage((MuleMessage)message5);
        DefaultMuleEvent event3 = new DefaultMuleEvent((MuleMessage)messageCollection2, this.endpoint, (FlowConstruct)this.flow);
        ArrayList<DefaultMuleEvent> events = new ArrayList<DefaultMuleEvent>();
        events.add(event2);
        events.add(event3);
        MuleEvent result = this.resultsHandler.aggregateResults(events, (MuleEvent)event1, this.muleContext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(DefaultMessageCollection.class, result.getMessage().getClass());
        Assert.assertEquals((long)2L, (long)((MuleMessageCollection)result.getMessage()).size());
        Assert.assertTrue((boolean)(result.getMessage().getPayload() instanceof List));
        Assert.assertEquals((Object)messageCollection, (Object)((MuleMessageCollection)result.getMessage()).getMessage(0));
        Assert.assertEquals((Object)messageCollection2, (Object)((MuleMessageCollection)result.getMessage()).getMessage(1));
        Assert.assertNull((Object)result.getMessage().getInvocationProperty("key2"));
        Assert.assertNull((Object)result.getMessage().getInvocationProperty("key3"));
        Assert.assertEquals((Object)event1.getMessage().getMessageRootId(), (Object)result.getMessage().getMessageRootId());
    }
}

