/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.codec;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.transformer.Transformer;
import org.mule.transformer.AbstractTransformerTestCase;
import org.mule.transformer.codec.Base64Decoder;
import org.mule.transformer.codec.Base64Encoder;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.Base64;

public class Base64TransformersTestCase
extends AbstractTransformerTestCase {
    private static final String TEST_DATA = "the quick brown fox jumped over the lazy dog";

    @Override
    public Object getResultData() {
        try {
            return Base64.encodeBytes((byte[])TEST_DATA.getBytes());
        }
        catch (Exception ex) {
            Assert.fail();
            return null;
        }
    }

    @Override
    public Object getTestData() {
        return TEST_DATA;
    }

    @Override
    public Transformer getTransformer() {
        return new Base64Encoder();
    }

    @Override
    public Transformer getRoundTripTransformer() {
        Base64Decoder t = new Base64Decoder();
        t.setReturnDataType(DataTypeFactory.STRING);
        return t;
    }

    @Test
    public void decodeUnpaddedString() throws Exception {
        String encodeBytes = (String)this.getResultData();
        Assert.assertThat((Object)encodeBytes, (Matcher)CoreMatchers.endsWith((String)"="));
        while (encodeBytes.endsWith("=")) {
            encodeBytes = encodeBytes.substring(0, encodeBytes.length() - 1);
        }
        Assert.assertThat((Object)encodeBytes, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.endsWith((String)"=")));
        String resultString = (String)this.getRoundTripTransformer().transform((Object)encodeBytes);
        Assert.assertThat((Object)resultString, (Matcher)CoreMatchers.is((Object)TEST_DATA));
    }
}

