/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.util.Locale;
import org.glassfish.grizzly.http.server.LocaleParser;

class LegacyLocaleParser
implements LocaleParser {
    LegacyLocaleParser() {
    }

    @Override
    public Locale parseLocale(String source) {
        String variant;
        String country;
        String language;
        int dash = source.indexOf(45);
        if (dash < 0) {
            language = source;
            country = "";
            variant = "";
        } else {
            language = source.substring(0, dash);
            country = source.substring(dash + 1);
            int vDash = country.indexOf(45);
            if (vDash > 0) {
                String cTemp = country.substring(0, vDash);
                variant = country.substring(vDash + 1);
                country = cTemp;
            } else {
                variant = "";
            }
        }
        if (!(LegacyLocaleParser.isAlpha(language) && LegacyLocaleParser.isAlpha(country) && LegacyLocaleParser.isAlpha(variant))) {
            return null;
        }
        return new Locale(language, country, variant);
    }

    private static boolean isAlpha(String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }
}

