/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.abdera.i18n.templates.Context;
import org.apache.abdera.i18n.templates.DelegatingContext;
import org.apache.abdera.i18n.templates.HashMapContext;
import org.apache.abdera.i18n.templates.ObjectContext;
import org.apache.abdera.i18n.templates.Template;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateTargetBuilder
implements TargetBuilder {
    protected final Map<Object, Template> templates = new HashMap<Object, Template>();

    public TemplateTargetBuilder() {
    }

    public TemplateTargetBuilder(Map<Object, Template> templates) {
        for (Map.Entry<Object, Template> entry : templates.entrySet()) {
            this.setTemplate(entry.getKey(), entry.getValue());
        }
    }

    public TemplateTargetBuilder setTemplate(Object key, String template) {
        return this.setTemplate(key, new Template(template));
    }

    public TemplateTargetBuilder setTemplate(Object key, Template template) {
        template = new Template(this.doReplacements(template.getPattern()));
        this.templates.put(key, template);
        return this;
    }

    private String doReplacements(String template) {
        for (Variable var : Variable.values()) {
            String rep = var.getReplacement();
            if (rep == null) continue;
            template = template.replaceAll("\\Q{" + var.name().toLowerCase() + "}\\E", rep);
        }
        return template;
    }

    public static Context getContext(RequestContext request, Object param) {
        Object context = null;
        if (param != null) {
            context = param instanceof Map ? new HashMapContext((Map)param, true) : (param instanceof Context ? (Context)param : new ObjectContext(param, true));
        }
        return new TemplateContext(request, (Context)context);
    }

    public static <T> List<T> asList(Iterator<T> i) {
        ArrayList<T> list = new ArrayList<T>();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }

    @Override
    public String urlFor(RequestContext request, Object key, Object param) {
        Template template = this.templates.get(key);
        return template != null ? template.expand(TemplateTargetBuilder.getContext(request, param)) : null;
    }

    private static String toVar(Variable variable, String label) {
        return variable.name().toLowerCase() + "_" + label;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variable {
        REQUEST_CONTEXT_PATH("{-opt|/|request_context_path}{-listjoin|/|request_context_path}"),
        REQUEST_CONTENT_TYPE,
        REQUEST_URI,
        REQUEST_RESOLVED_URI,
        REQUEST_PARAMETER,
        REQUEST_LANGUAGE,
        REQUEST_CHARSET,
        REQUEST_USER,
        SESSION_ATTRIBUTE,
        REQUEST_ATTRIBUTE,
        REQUEST_HEADER,
        TARGET_PARAMETER,
        TARGET_IDENTITY,
        TARGET_PATH("{-opt|/|target_path}{-listjoin|/|target_path}"),
        TARGET_BASE("{-opt|/|target_base}{-listjoin|/|target_base}");

        private final Pattern p = Pattern.compile("\\Q" + this.name() + "_\\E.*", 2);
        private final String replacement;

        static Variable get(String var) {
            if (REQUEST_PARAMETER.match(var)) {
                return REQUEST_PARAMETER;
            }
            if (SESSION_ATTRIBUTE.match(var)) {
                return SESSION_ATTRIBUTE;
            }
            if (REQUEST_ATTRIBUTE.match(var)) {
                return REQUEST_ATTRIBUTE;
            }
            if (REQUEST_HEADER.match(var)) {
                return REQUEST_HEADER;
            }
            if (TARGET_PARAMETER.match(var)) {
                return TARGET_PARAMETER;
            }
            try {
                return Variable.valueOf(var.toUpperCase());
            }
            catch (Exception e) {
                return null;
            }
        }

        private Variable() {
            this(null);
        }

        private Variable(String replacement) {
            this.replacement = replacement;
        }

        String getReplacement() {
            return this.replacement;
        }

        boolean match(String var) {
            return this.p.matcher(var).matches();
        }

        String label(String var) {
            return var.substring(this.name().length() + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TemplateContext
    extends DelegatingContext {
        private static final long serialVersionUID = 4332356546022014897L;
        private final RequestContext request;

        public TemplateContext(RequestContext request, Context subcontext) {
            super(subcontext);
            this.request = request;
        }

        private String[] split(String val) {
            if (val.equals("")) {
                return null;
            }
            String[] segments = val.split("/");
            return segments.length > 0 ? segments : null;
        }

        protected <T> T resolveActual(String var) {
            Variable variable = Variable.get(var);
            if (variable == null) {
                return (T)(this.subcontext != null ? this.subcontext.resolve(var) : null);
            }
            switch (variable) {
                case REQUEST_URI: {
                    return (T)this.request.getUri().toString();
                }
                case REQUEST_RESOLVED_URI: {
                    return (T)this.request.getResolvedUri().toString();
                }
                case REQUEST_CONTENT_TYPE: {
                    return (T)this.request.getContentType().toString();
                }
                case REQUEST_CONTEXT_PATH: {
                    return (T)this.split(this.request.getContextPath());
                }
                case REQUEST_PARAMETER: {
                    String name = Variable.REQUEST_PARAMETER.label(var);
                    return (T)this.request.getParameter(name);
                }
                case REQUEST_LANGUAGE: {
                    return (T)this.request.getAcceptLanguage();
                }
                case REQUEST_CHARSET: {
                    return (T)this.request.getAcceptCharset();
                }
                case REQUEST_USER: {
                    Principal p = this.request.getPrincipal();
                    return (T)(p != null ? p.getName() : null);
                }
                case SESSION_ATTRIBUTE: {
                    String name = Variable.SESSION_ATTRIBUTE.label(var);
                    return (T)this.request.getAttribute(RequestContext.Scope.SESSION, name);
                }
                case REQUEST_ATTRIBUTE: {
                    String name = Variable.REQUEST_ATTRIBUTE.label(var);
                    return (T)this.request.getAttribute(RequestContext.Scope.REQUEST, name);
                }
                case REQUEST_HEADER: {
                    String name = Variable.REQUEST_HEADER.label(var);
                    return (T)this.request.getHeader(name);
                }
                case TARGET_PARAMETER: {
                    String name = Variable.TARGET_PARAMETER.label(var);
                    return (T)this.request.getTarget().getParameter(name);
                }
                case TARGET_IDENTITY: {
                    return (T)this.request.getTarget().getIdentity();
                }
                case TARGET_PATH: {
                    return (T)this.split(this.request.getTargetPath());
                }
                case TARGET_BASE: {
                    return (T)this.split(this.request.getTargetBasePath());
                }
            }
            return (T)(this.subcontext != null ? this.subcontext.resolve(var) : null);
        }

        public Iterator<String> iterator() {
            ArrayList<String> vars = new ArrayList<String>();
            for (String var : this.subcontext) {
                vars.add(var);
            }
            for (String var : this.request.getParameterNames()) {
                vars.add(TemplateTargetBuilder.toVar(Variable.REQUEST_PARAMETER, var));
            }
            for (String var : this.request.getAttributeNames(RequestContext.Scope.SESSION)) {
                vars.add(TemplateTargetBuilder.toVar(Variable.SESSION_ATTRIBUTE, var));
            }
            for (String var : this.request.getAttributeNames(RequestContext.Scope.REQUEST)) {
                vars.add(TemplateTargetBuilder.toVar(Variable.REQUEST_ATTRIBUTE, var));
            }
            for (String var : this.request.getHeaderNames()) {
                vars.add(TemplateTargetBuilder.toVar(Variable.REQUEST_HEADER, var));
            }
            Target target = this.request.getTarget();
            for (String var : target.getParameterNames()) {
                vars.add(TemplateTargetBuilder.toVar(Variable.TARGET_PARAMETER, var));
            }
            vars.add(Variable.REQUEST_CONTEXT_PATH.name().toLowerCase());
            vars.add(Variable.REQUEST_CONTENT_TYPE.name().toLowerCase());
            vars.add(Variable.REQUEST_URI.name().toLowerCase());
            vars.add(Variable.REQUEST_RESOLVED_URI.name().toLowerCase());
            vars.add(Variable.REQUEST_LANGUAGE.name().toLowerCase());
            vars.add(Variable.REQUEST_CHARSET.name().toLowerCase());
            vars.add(Variable.REQUEST_USER.name().toLowerCase());
            vars.add(Variable.TARGET_IDENTITY.name().toLowerCase());
            vars.add(Variable.TARGET_PATH.name().toLowerCase());
            vars.add(Variable.TARGET_BASE.name().toLowerCase());
            return vars.iterator();
        }
    }
}

