/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;

public class JsonSchemaGenerator {
    protected final ObjectMapper _mapper;
    private final WrapperFactory _wrapperFactory;

    public JsonSchemaGenerator(ObjectMapper mapper) {
        this(mapper, null);
    }

    public JsonSchemaGenerator(ObjectMapper mapper, WrapperFactory wrapperFactory) {
        this._mapper = mapper;
        this._wrapperFactory = wrapperFactory == null ? new WrapperFactory() : wrapperFactory;
    }

    public JsonSchema generateSchema(Class<?> type) throws JsonMappingException {
        SchemaFactoryWrapper visitor = this._wrapperFactory.getWrapper(this._mapper == null ? null : this._mapper.getSerializerProvider());
        this._mapper.acceptJsonFormatVisitor(type, (JsonFormatVisitorWrapper)visitor);
        return visitor.finalSchema();
    }

    public JsonSchema generateSchema(JavaType type) throws JsonMappingException {
        SchemaFactoryWrapper visitor = this._wrapperFactory.getWrapper(this._mapper == null ? null : this._mapper.getSerializerProvider());
        this._mapper.acceptJsonFormatVisitor(type, (JsonFormatVisitorWrapper)visitor);
        return visitor.finalSchema();
    }
}

