/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.util.concurrent.Semaphore;
import org.mule.module.pgp.AbstractTransformPolicy;

public class TransformPerRequestPolicy
extends AbstractTransformPolicy {
    private Semaphore writeSemaphore = new Semaphore(1);

    @Override
    public void readRequest(long length) {
        super.readRequest(length);
        this.writeSemaphore.release();
    }

    @Override
    public void release() {
        this.writeSemaphore.release();
        super.release();
    }

    @Override
    protected Thread getCopyingThread() {
        return new PerRequestWork();
    }

    private class PerRequestWork
    extends AbstractTransformPolicy.TransformerWork {
        private PerRequestWork() {
            super(TransformPerRequestPolicy.this);
        }

        @Override
        protected void execute() throws Exception {
            TransformPerRequestPolicy.this.getTransformer().initialize(TransformPerRequestPolicy.this.getInputStream().getOut());
            boolean finishWriting = false;
            while (!finishWriting && !TransformPerRequestPolicy.this.isClosed) {
                TransformPerRequestPolicy.this.writeSemaphore.acquire();
                finishWriting = TransformPerRequestPolicy.this.getTransformer().write(TransformPerRequestPolicy.this.getInputStream().getOut(), TransformPerRequestPolicy.this.getBytesRequested());
            }
        }
    }
}

