/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.multipart;

import com.ning.http.client.RandomAccessBody;
import com.ning.http.client.multipart.AbstractFilePart;
import com.ning.http.client.multipart.ByteArrayPart;
import com.ning.http.client.multipart.FilePart;
import com.ning.http.client.multipart.MultipartUtils;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.multipart.StringPart;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartBody
implements RandomAccessBody {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipartBody.class);
    private final byte[] boundary;
    private final long contentLength;
    private final String contentType;
    private final List<Part> parts;
    private final List<RandomAccessFile> pendingOpenFiles = new ArrayList<RandomAccessFile>();
    private boolean transfertDone = false;
    private int currentPart = 0;
    private byte[] currentBytes;
    private int currentBytesPosition = -1;
    private boolean doneWritingParts = false;
    private FileLocation fileLocation = FileLocation.NONE;
    private FileChannel currentFileChannel;

    public MultipartBody(List<Part> parts, String contentType, long contentLength, byte[] boundary) {
        this.boundary = boundary;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.parts = parts;
    }

    @Override
    public void close() throws IOException {
        for (RandomAccessFile file : this.pendingOpenFiles) {
            file.close();
        }
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getBoundary() {
        return this.boundary;
    }

    @Override
    public long transferTo(long position, WritableByteChannel target) throws IOException {
        if (this.transfertDone) {
            return -1L;
        }
        long overallLength = 0L;
        for (Part part : this.parts) {
            overallLength += part.write(target, this.boundary);
        }
        this.transfertDone = true;
        return overallLength += MultipartUtils.writeBytesToChannel(target, MultipartUtils.getMessageEnd(this.boundary));
    }

    @Override
    public long read(ByteBuffer buffer) throws IOException {
        try {
            int overallLength = 0;
            int maxLength = buffer.remaining();
            if (this.currentPart == this.parts.size() && this.transfertDone) {
                return -1L;
            }
            boolean full = false;
            while (!full && !this.doneWritingParts) {
                Part part = null;
                if (this.currentPart < this.parts.size()) {
                    part = this.parts.get(this.currentPart);
                }
                if (this.currentFileChannel != null) {
                    full = (overallLength += this.writeCurrentFile(buffer)) == maxLength;
                    continue;
                }
                if (this.currentBytesPosition > -1) {
                    boolean bl = full = (overallLength += this.writeCurrentBytes(buffer, maxLength - overallLength)) == maxLength;
                    if (this.currentPart != this.parts.size() || !this.currentBytesFullyRead()) continue;
                    this.doneWritingParts = true;
                    continue;
                }
                if (part instanceof StringPart) {
                    StringPart stringPart = (StringPart)part;
                    this.initializeCurrentBytes(stringPart.getBytes(this.boundary));
                    ++this.currentPart;
                    continue;
                }
                if (!(part instanceof AbstractFilePart)) continue;
                AbstractFilePart filePart = (AbstractFilePart)part;
                switch (this.fileLocation) {
                    case NONE: {
                        this.initializeCurrentBytes(filePart.generateFileStart(this.boundary));
                        this.fileLocation = FileLocation.START;
                        break;
                    }
                    case START: {
                        this.initializeFileBody(filePart);
                        this.fileLocation = FileLocation.MIDDLE;
                        break;
                    }
                    case MIDDLE: {
                        this.initializeCurrentBytes(filePart.generateFileEnd());
                        this.fileLocation = FileLocation.END;
                        break;
                    }
                    case END: {
                        ++this.currentPart;
                        this.fileLocation = FileLocation.NONE;
                        if (this.currentPart != this.parts.size()) break;
                        this.doneWritingParts = true;
                    }
                }
            }
            if (this.doneWritingParts) {
                if (this.currentBytesPosition == -1) {
                    this.initializeCurrentBytes(MultipartUtils.getMessageEnd(this.boundary));
                }
                if (this.currentBytesPosition > -1) {
                    overallLength += this.writeCurrentBytes(buffer, maxLength - overallLength);
                    if (this.currentBytesFullyRead()) {
                        this.currentBytes = null;
                        this.currentBytesPosition = -1;
                        this.transfertDone = true;
                    }
                }
            }
            return overallLength;
        }
        catch (Exception e) {
            LOGGER.error("Read exception", (Throwable)e);
            return 0L;
        }
    }

    private boolean currentBytesFullyRead() {
        return this.currentBytes == null || this.currentBytesPosition >= this.currentBytes.length - 1;
    }

    private void initializeFileBody(AbstractFilePart part) throws IOException {
        if (part instanceof FilePart) {
            RandomAccessFile raf = new RandomAccessFile(((FilePart)FilePart.class.cast(part)).getFile(), "r");
            this.pendingOpenFiles.add(raf);
            this.currentFileChannel = raf.getChannel();
        } else if (part instanceof ByteArrayPart) {
            this.initializeCurrentBytes(((ByteArrayPart)ByteArrayPart.class.cast(part)).getBytes());
        } else {
            throw new IllegalArgumentException("Unknow AbstractFilePart type");
        }
    }

    private void initializeCurrentBytes(byte[] bytes) throws IOException {
        this.currentBytes = bytes;
        this.currentBytesPosition = 0;
    }

    private int writeCurrentFile(ByteBuffer buffer) throws IOException {
        int read = this.currentFileChannel.read(buffer);
        if (this.currentFileChannel.position() == this.currentFileChannel.size()) {
            this.currentFileChannel.close();
            this.currentFileChannel = null;
            int currentFile = this.pendingOpenFiles.size() - 1;
            this.pendingOpenFiles.get(currentFile).close();
            this.pendingOpenFiles.remove(currentFile);
        }
        return read;
    }

    private int writeCurrentBytes(ByteBuffer buffer, int length) throws IOException {
        if (this.currentBytes.length == 0) {
            this.currentBytesPosition = -1;
            this.currentBytes = null;
            return 0;
        }
        int available = this.currentBytes.length - this.currentBytesPosition;
        int writeLength = Math.min(available, length);
        if (writeLength > 0) {
            buffer.put(this.currentBytes, this.currentBytesPosition, writeLength);
            if (available <= length) {
                this.currentBytesPosition = -1;
                this.currentBytes = null;
            } else {
                this.currentBytesPosition += writeLength;
            }
        }
        return writeLength;
    }

    static enum FileLocation {
        NONE,
        START,
        MIDDLE,
        END;

    }
}

