/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import org.apache.cxf.common.util.SpringAopClassHelper;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.SystemPropertyAction;

public class ClassHelper {
    static final ClassHelper HELPER = ClassHelper.getClassHelper();

    protected ClassHelper() {
    }

    private static ClassHelper getClassHelper() {
        boolean useSpring = true;
        String s = SystemPropertyAction.getPropertyOrNull("org.apache.cxf.useSpringClassHelpers");
        if (!StringUtils.isEmpty(s)) {
            boolean bl = useSpring = "1".equals(s) || Boolean.parseBoolean(s);
        }
        if (useSpring) {
            try {
                return new SpringAopClassHelper();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new ClassHelper();
    }

    protected Class<?> getRealClassInternal(Object o) {
        return o.getClass();
    }

    protected Class<?> getRealClassFromClassInternal(Class<?> cls) {
        return cls;
    }

    protected Object getRealObjectInternal(Object o) {
        return o;
    }

    public static Class<?> getRealClass(Object o) {
        return HELPER.getRealClassInternal(o);
    }

    public static Class<?> getRealClassFromClass(Class<?> cls) {
        return HELPER.getRealClassFromClassInternal(cls);
    }

    public static Object getRealObject(Object o) {
        return HELPER.getRealObjectInternal(o);
    }
}

