/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.introspection;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.mule.api.registry.ServiceRegistry;
import org.mule.common.MuleVersion;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.ExtensionFactory;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.Parameter;
import org.mule.extension.introspection.declaration.DescribingContext;
import org.mule.extension.introspection.declaration.fluent.ConfigurationDeclaration;
import org.mule.extension.introspection.declaration.fluent.Declaration;
import org.mule.extension.introspection.declaration.fluent.Descriptor;
import org.mule.extension.introspection.declaration.fluent.OperationDeclaration;
import org.mule.extension.introspection.declaration.fluent.ParameterDeclaration;
import org.mule.extension.introspection.declaration.spi.DescriberPostProcessor;
import org.mule.module.extension.internal.DefaultDescribingContext;
import org.mule.module.extension.internal.introspection.ImmutableConfiguration;
import org.mule.module.extension.internal.introspection.ImmutableExtension;
import org.mule.module.extension.internal.introspection.ImmutableOperation;
import org.mule.module.extension.internal.introspection.ImmutableParameter;
import org.mule.module.extension.internal.util.MuleExtensionUtils;
import org.mule.util.Preconditions;

public final class DefaultExtensionFactory
implements ExtensionFactory {
    private final List<DescriberPostProcessor> postProcessors;

    public DefaultExtensionFactory(ServiceRegistry serviceRegistry) {
        this.postProcessors = this.searchPostProcessors(serviceRegistry);
    }

    public Extension createFrom(Descriptor descriptor) {
        return this.createFrom(descriptor, new DefaultDescribingContext(descriptor.getRootDeclaration()));
    }

    public Extension createFrom(Descriptor descriptor, DescribingContext describingContext) {
        this.applyPostProcessors(describingContext);
        return this.toExtension(descriptor.getRootDeclaration().getDeclaration());
    }

    private Extension toExtension(Declaration declaration) {
        this.validateMuleVersion(declaration);
        return new ImmutableExtension(declaration.getName(), declaration.getDescription(), declaration.getVersion(), this.sortConfigurations(this.toConfigurations(declaration.getConfigurations())), MuleExtensionUtils.alphaSortDescribedList(this.toOperations(declaration.getOperations())), declaration.getCapabilities());
    }

    private List<Configuration> sortConfigurations(List<Configuration> configurations) {
        ArrayList<Configuration> sorted = new ArrayList<Configuration>(configurations.size());
        sorted.add(configurations.get(0));
        if (configurations.size() > 1) {
            sorted.addAll(MuleExtensionUtils.alphaSortDescribedList(configurations.subList(1, configurations.size())));
        }
        return sorted;
    }

    private List<Configuration> toConfigurations(List<ConfigurationDeclaration> declarations) {
        Preconditions.checkArgument((!declarations.isEmpty() ? 1 : 0) != 0, (String)"A extension must have at least one configuration");
        ArrayList<Configuration> configurations = new ArrayList<Configuration>(declarations.size());
        for (ConfigurationDeclaration declaration : declarations) {
            configurations.add(this.toConfiguration(declaration));
        }
        return configurations;
    }

    private Configuration toConfiguration(ConfigurationDeclaration declaration) {
        return new ImmutableConfiguration(declaration.getName(), declaration.getDescription(), declaration.getConfigurationInstantiator(), this.toConfigParameters(declaration.getParameters()), declaration.getCapabilities());
    }

    private List<Operation> toOperations(List<OperationDeclaration> declarations) {
        if (declarations.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<Operation> operations = new ArrayList<Operation>(declarations.size());
        for (OperationDeclaration declaration : declarations) {
            operations.add(this.toOperation(declaration));
        }
        return operations;
    }

    private Operation toOperation(OperationDeclaration declaration) {
        List<Parameter> parameters = this.toOperationParameters(declaration.getParameters());
        return new ImmutableOperation(declaration.getName(), declaration.getDescription(), declaration.getExecutorFactory(), parameters, declaration.getCapabilities());
    }

    private List<Parameter> toConfigParameters(List<ParameterDeclaration> declarations) {
        List<Parameter> parameters = this.toParameters(declarations);
        MuleExtensionUtils.alphaSortDescribedList(parameters);
        return parameters;
    }

    private List<Parameter> toOperationParameters(List<ParameterDeclaration> declarations) {
        return this.toParameters(declarations);
    }

    private List<Parameter> toParameters(List<ParameterDeclaration> declarations) {
        if (declarations.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(declarations.size());
        for (ParameterDeclaration declaration : declarations) {
            parameters.add(this.toParameter(declaration));
        }
        return parameters;
    }

    private Parameter toParameter(ParameterDeclaration parameter) {
        return new ImmutableParameter(parameter.getName(), parameter.getDescription(), parameter.getType(), parameter.isRequired(), parameter.isDynamic(), parameter.getDefaultValue(), parameter.getCapabilities());
    }

    private void validateMuleVersion(Declaration declaration) {
        try {
            new MuleVersion(declaration.getVersion());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid version %s for capability '%s'", declaration.getVersion(), declaration.getName()));
        }
    }

    private void applyPostProcessors(DescribingContext describingContext) {
        for (DescriberPostProcessor postProcessor : this.postProcessors) {
            postProcessor.postProcess(describingContext);
        }
    }

    private List<DescriberPostProcessor> searchPostProcessors(ServiceRegistry serviceRegistry) {
        return ImmutableList.builder().addAll((Iterable)serviceRegistry.lookupProviders(DescriberPostProcessor.class, this.getClass().getClassLoader())).build();
    }
}

