/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transport.OutputHandler;
import org.mule.transport.sftp.notification.SftpNotifier;
import org.mule.util.StringUtils;

public class SftpClient {
    public static final String CHANNEL_SFTP = "sftp";
    public static final String STRICT_HOST_KEY_CHECKING = "StrictHostKeyChecking";
    public static final String PREFERRED_AUTHENTICATION_METHODS = "PreferredAuthentications";
    private Log logger = LogFactory.getLog(this.getClass());
    private ChannelSftp channelSftp;
    private JSch jsch;
    private SftpNotifier notifier;
    private Session session;
    private final String host;
    private int port = 22;
    private File knownHostsFile;
    private String home;
    private String currentDirectory = "";
    private static final Object lock = new Object();
    private String preferredAuthenticationMethods;
    private int connectionTimeoutMillis = 0;

    public SftpClient(String host) {
        this(host, null);
    }

    public SftpClient(String host, SftpNotifier notifier) {
        this.host = host;
        this.notifier = notifier;
        this.jsch = new JSch();
    }

    public void changeWorkingDirectory(String wd) throws IOException {
        this.currentDirectory = wd;
        try {
            wd = this.getAbsolutePath(wd);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Attempting to cwd to: " + wd));
            }
            this.channelSftp.cd(wd);
        }
        catch (SftpException e) {
            String message = "Error '" + e.getMessage() + "' occurred when trying to CDW to '" + wd + "'.";
            this.logger.error((Object)message);
            throw new IOException(message);
        }
    }

    public String getAbsolutePath(String path) {
        if (path.startsWith("/~")) {
            return this.home + path.substring(2, path.length());
        }
        return path;
    }

    public void login(String user, String password) throws IOException {
        try {
            Properties hash = new Properties();
            this.configureHostChecking(hash);
            if (!StringUtils.isEmpty((String)this.preferredAuthenticationMethods)) {
                hash.put(PREFERRED_AUTHENTICATION_METHODS, this.preferredAuthenticationMethods);
            }
            this.session = this.jsch.getSession(user, this.host);
            this.session.setConfig(hash);
            this.session.setPort(this.port);
            this.session.setPassword(password);
            this.session.setTimeout(this.connectionTimeoutMillis);
            this.session.connect();
            Channel channel = this.session.openChannel(CHANNEL_SFTP);
            channel.connect();
            this.channelSftp = (ChannelSftp)channel;
            this.setHome(this.channelSftp.pwd());
        }
        catch (JSchException e) {
            this.logAndThrowLoginError(user, (Exception)((Object)e));
        }
        catch (SftpException e) {
            this.logAndThrowLoginError(user, (Exception)((Object)e));
        }
    }

    public void login(String user, String identityFile, String passphrase) throws IOException {
        if (!new File(identityFile).exists()) {
            throw new IOException("IdentityFile '" + identityFile + "' not found");
        }
        try {
            if (passphrase == null || "".equals(passphrase)) {
                this.jsch.addIdentity(new File(identityFile).getAbsolutePath());
            } else {
                this.jsch.addIdentity(new File(identityFile).getAbsolutePath(), passphrase);
            }
            Properties hash = new Properties();
            this.configureHostChecking(hash);
            if (!StringUtils.isEmpty((String)this.preferredAuthenticationMethods)) {
                hash.put(PREFERRED_AUTHENTICATION_METHODS, this.preferredAuthenticationMethods);
            }
            this.session = this.jsch.getSession(user, this.host);
            this.session.setConfig(hash);
            this.session.setPort(this.port);
            this.session.setTimeout(this.connectionTimeoutMillis);
            this.session.connect();
            Channel channel = this.session.openChannel(CHANNEL_SFTP);
            channel.connect();
            this.channelSftp = (ChannelSftp)channel;
            this.setHome(this.channelSftp.pwd());
        }
        catch (JSchException e) {
            this.logAndThrowLoginError(user, (Exception)((Object)e));
        }
        catch (SftpException e) {
            this.logAndThrowLoginError(user, (Exception)((Object)e));
        }
    }

    protected void configureHostChecking(Properties hash) throws JSchException {
        if (this.getKnownHostsFile() == null) {
            hash.put(STRICT_HOST_KEY_CHECKING, "no");
        } else {
            hash.put(STRICT_HOST_KEY_CHECKING, "ask");
            this.jsch.setKnownHosts(this.getKnownHostsFile().getAbsolutePath());
        }
    }

    public File getKnownHostsFile() {
        return this.knownHostsFile;
    }

    public void setKnownHostsFile(File knownHostsFile) {
        this.knownHostsFile = knownHostsFile;
    }

    private void logAndThrowLoginError(String user, Exception e) throws IOException {
        this.logger.error((Object)("Error during login to " + user + "@" + this.host), (Throwable)e);
        throw new IOException("Error during login to " + user + "@" + this.host + ": " + e.getMessage());
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public void rename(String filename, String dest) throws IOException {
        if (this.notifier != null) {
            this.notifier.notify(200003, "from: " + this.currentDirectory + "/" + filename + " - to: " + dest);
        }
        String absolutePath = this.getAbsolutePath(dest);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Will try to rename " + this.currentDirectory + "/" + filename + " to " + absolutePath));
            }
            this.channelSftp.rename(filename, absolutePath);
        }
        catch (SftpException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void deleteFile(String fileName) throws IOException {
        this.notifyAction(200004, fileName);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Will try to delete " + fileName));
            }
            this.channelSftp.rm(fileName);
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
    }

    public void disconnect() {
        if (this.channelSftp != null) {
            this.channelSftp.disconnect();
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
    }

    public boolean isConnected() {
        return this.channelSftp != null && this.channelSftp.isConnected() && !this.channelSftp.isClosed() && this.session != null && this.session.isConnected();
    }

    public String[] listFiles() throws IOException {
        return this.listFiles(".");
    }

    public String[] listFiles(String path) throws IOException {
        return this.listDirectory(path, true, false);
    }

    public String[] listDirectories() throws IOException {
        return this.listDirectory(".", false, true);
    }

    public String[] listDirectories(String path) throws IOException {
        return this.listDirectory(path, false, true);
    }

    private String[] listDirectory(String path, boolean includeFiles, boolean includeDirectories) throws IOException {
        try {
            Vector entries = this.channelSftp.ls(path);
            if (entries != null) {
                ArrayList<String> ret = new ArrayList<String>();
                for (ChannelSftp.LsEntry entry : entries) {
                    if (includeFiles && !entry.getAttrs().isDir()) {
                        ret.add(entry.getFilename());
                    }
                    if (!includeDirectories || !entry.getAttrs().isDir() || entry.getFilename().equals(".") || entry.getFilename().equals("..")) continue;
                    ret.add(entry.getFilename());
                }
                return ret.toArray(new String[ret.size()]);
            }
        }
        catch (SftpException e) {
            throw new IOException(e.getMessage(), e);
        }
        return null;
    }

    public InputStream retrieveFile(String fileName) throws IOException {
        long size = this.getSize(fileName);
        if (this.notifier != null) {
            this.notifier.notify(200001, this.currentDirectory + "/" + fileName, size);
        }
        try {
            return this.channelSftp.get(fileName);
        }
        catch (SftpException e) {
            throw new IOException(e.getMessage() + ".  Filename is " + fileName);
        }
    }

    public void storeFile(String fileName, InputStream stream) throws IOException {
        this.storeFile(fileName, stream, WriteMode.OVERWRITE);
    }

    public void storeFile(String fileName, InputStream stream, WriteMode mode) throws IOException {
        try {
            this.notifyAction(200002, fileName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Sending to SFTP service: Stream = " + stream + " , filename = " + fileName));
            }
            this.channelSftp.put(stream, fileName, mode.intValue());
        }
        catch (SftpException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void storeFile(String fileName, MuleEvent event, OutputHandler outputHandler) throws IOException {
        this.storeFile(fileName, event, outputHandler, WriteMode.OVERWRITE);
    }

    public void storeFile(String fileName, MuleEvent event, OutputHandler outputHandler, WriteMode mode) throws IOException {
        try (OutputStream os = null;){
            this.notifyAction(200002, fileName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Sending to SFTP service: OutputHandler = " + outputHandler + " , filename = " + fileName));
            }
            os = this.channelSftp.put(fileName, mode.intValue());
            outputHandler.write(event, os);
        }
    }

    public void storeFile(String fileNameLocal, String fileNameRemote) throws IOException {
        this.storeFile(fileNameLocal, fileNameRemote, WriteMode.OVERWRITE);
    }

    public void storeFile(String fileNameLocal, String fileNameRemote, WriteMode mode) throws IOException {
        try {
            this.channelSftp.put(fileNameLocal, fileNameRemote, mode.intValue());
        }
        catch (SftpException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void notifyAction(int action, String fileName) {
        if (this.notifier != null) {
            this.notifier.notify(action, this.currentDirectory + "/" + fileName);
        }
    }

    public long getSize(String filename) throws IOException {
        try {
            return this.channelSftp.stat(filename).getSize();
        }
        catch (SftpException e) {
            throw new IOException(e.getMessage() + " (" + this.currentDirectory + "/" + filename + ")");
        }
    }

    public long getLastModifiedTime(String filename) throws IOException {
        try {
            SftpATTRS attrs = this.channelSftp.stat("./" + filename);
            return (long)attrs.getMTime() * 1000L;
        }
        catch (SftpException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void mkdir(String directoryName) throws IOException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Will try to create directory " + directoryName));
            }
            this.channelSftp.mkdir(directoryName);
        }
        catch (SftpException e) {
            throw new IOException("Could not create the directory '" + directoryName + "', caused by: " + e.getMessage());
        }
    }

    public void deleteDirectory(String path) throws IOException {
        path = this.getAbsolutePath(path);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Will try to delete directory " + path));
            }
            this.channelSftp.rmdir(path);
        }
        catch (SftpException e) {
            throw new IOException(e.getMessage());
        }
    }

    void setHome(String home) {
        this.home = home;
    }

    public ChannelSftp getChannelSftp() {
        return this.channelSftp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSftpDirIfNotExists(ImmutableEndpoint endpoint, String newDir) throws IOException {
        String newDirAbs = endpoint.getEndpointURI().getPath() + "/" + newDir;
        String currDir = this.currentDirectory;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("CHANGE DIR FROM " + this.currentDirectory + " TO " + newDirAbs));
        }
        Object object = lock;
        synchronized (object) {
            try {
                this.changeWorkingDirectory(newDirAbs);
            }
            catch (IOException e) {
                this.logger.info((Object)("Got an exception when trying to change the working directory to the new dir. Will try to create the directory " + newDirAbs));
                this.changeWorkingDirectory(endpoint.getEndpointURI().getPath());
                this.mkdir(newDir);
                this.changeWorkingDirectory(newDirAbs);
            }
            finally {
                this.changeWorkingDirectory(currDir);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("DIR IS NOW BACK TO " + this.currentDirectory));
                }
            }
        }
    }

    public String duplicateHandling(String destDir, String filename, String duplicateHandling) throws IOException {
        if (duplicateHandling.equals("addSeqNo")) {
            filename = this.createUniqueName(destDir, filename);
        } else if (duplicateHandling.equals("throwException") && this.fileAlreadyExists(destDir, filename)) {
            throw new IOException("File already exists: " + filename);
        }
        return filename;
    }

    private boolean fileAlreadyExists(String destDir, String filename) throws IOException {
        String[] files;
        this.logger.warn((Object)("listing files for: " + destDir + "/" + filename));
        for (String file : files = this.listFiles(destDir)) {
            if (!file.equals(filename)) continue;
            return true;
        }
        return false;
    }

    private String createUniqueName(String dir, String path) throws IOException {
        String fileType;
        String filename;
        int fileIdx = 1;
        int fileTypeIdx = path.lastIndexOf(46);
        if (fileTypeIdx == -1) {
            filename = path;
            fileType = "";
        } else {
            fileType = path.substring(fileTypeIdx);
            filename = path.substring(0, fileTypeIdx);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Create a unique name for: " + path + " (" + dir + " - " + filename + " - " + fileType + ")"));
        }
        String uniqueFilename = filename;
        String[] existingFiles = this.listFiles(this.getAbsolutePath(dir));
        while (this.existsFile(existingFiles, uniqueFilename, fileType)) {
            uniqueFilename = filename + '_' + fileIdx++;
        }
        if (!path.equals(uniqueFilename = uniqueFilename + fileType) && this.logger.isInfoEnabled()) {
            this.logger.info((Object)("A file with the original filename (" + dir + "/" + path + ") already exists, new name: " + uniqueFilename));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Unique name returned: " + uniqueFilename));
        }
        return uniqueFilename;
    }

    private boolean existsFile(String[] files, String filename, String fileType) {
        boolean existsFile = false;
        filename = filename + fileType;
        for (String file : files) {
            if (!file.equals(filename)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found existing file: " + file));
            }
            existsFile = true;
        }
        return existsFile;
    }

    public void chmod(String path, int permissions) throws SftpException {
        path = this.getAbsolutePath(path);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Will try to chmod directory '" + path + "' to permission " + permissions));
        }
        this.channelSftp.chmod(permissions, path);
    }

    public void setNotifier(SftpNotifier notifier) {
        this.notifier = notifier;
    }

    public String getHost() {
        return this.host;
    }

    public void recursivelyDeleteDirectory(String dir) throws IOException {
        int i;
        this.changeWorkingDirectory(dir);
        String[] directories = this.listDirectories();
        String[] files = this.listFiles();
        for (i = 0; i < directories.length; ++i) {
            this.recursivelyDeleteDirectory(directories[i]);
        }
        for (i = 0; i < files.length; ++i) {
            this.deleteFile(files[i]);
        }
        this.changeWorkingDirectory("..");
        this.deleteDirectory(dir);
    }

    public void setPreferredAuthenticationMethods(String preferredAuthenticationMethods) {
        this.preferredAuthenticationMethods = preferredAuthenticationMethods;
    }

    public static enum WriteMode {
        APPEND{

            @Override
            public int intValue() {
                return 2;
            }
        }
        ,
        OVERWRITE{

            @Override
            public int intValue() {
                return 0;
            }
        };


        public abstract int intValue();
    }
}

