/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.ConnectorException;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractConnector;
import org.mule.transport.file.ExpressionFilenameParser;
import org.mule.transport.file.FilenameParser;
import org.mule.transport.sftp.AuthenticationMethodValidator;
import org.mule.transport.sftp.SftpClient;
import org.mule.transport.sftp.SftpConnectionFactory;
import org.mule.transport.sftp.notification.SftpNotifier;

public class SftpConnector
extends AbstractConnector {
    public static final String PROPERTY_POLLING_FREQUENCY = "pollingFrequency";
    public static final String PROPERTY_DIRECTORY = "directory";
    public static final String PROPERTY_OUTPUT_PATTERN = "outputPattern";
    public static final String PROPERTY_FILENAME = "filename";
    public static final String PROPERTY_ORIGINAL_FILENAME = "originalFilename";
    public static final String PROPERTY_SELECT_EXPRESSION = "selectExpression";
    public static final String PROPERTY_FILE_EXTENSION = "fileExtension";
    public static final String PROPERTY_INCLUDE_SUBFOLDERS = "includeSubfolders";
    public static final String PROPERTY_IDENTITY_FILE = "identityFile";
    public static final String PROPERTY_PASS_PHRASE = "passphrase";
    public static final String PROPERTY_KNOWN_HOSTS_FILE = "knownHostsFile";
    public static final String PROPERTY_FILE_AGE = "fileAge";
    public static final String PROPERTY_TEMP_DIR = "tempDir";
    public static final String PROPERTY_SIZE_CHECK_WAIT_TIME = "sizeCheckWaitTime";
    public static final String PROPERTY_ARCHIVE_DIR = "archiveDir";
    public static final String PROPERTY_ARCHIVE_TEMP_RECEIVING_DIR = "archiveTempReceivingDir";
    public static final String PROPERTY_ARCHIVE_TEMP_SENDING_DIR = "archiveTempSendingDir";
    public static final String PROPERTY_DUPLICATE_HANDLING = "duplicateHandling";
    public static final String PROPERTY_USE_TEMP_FILE_TIMESTAMP_SUFFIX = "useTempFileTimestampSuffix";
    public static final String PROPERTY_DUPLICATE_HANDLING_THROW_EXCEPTION = "throwException";
    public static final String PROPERTY_DUPLICATE_HANDLING_OVERWRITE = "overwrite";
    public static final String PROPERTY_DUPLICATE_HANDLING_APPEND = "append";
    public static final String PROPERTY_DUPLICATE_HANDLING_ASS_SEQ_NO = "addSeqNo";
    public static final String PROPERTY_MAX_CONNECTION_POOL_SIZE = "maxConnectionPoolSize";
    public static final String PROPERTY_KEEP_FILE_ON_ERROR = "keepFileOnError";
    public static final int DEFAULT_POLLING_FREQUENCY = 1000;
    protected static final Log logger = LogFactory.getLog(SftpConnector.class);
    private FilenameParser filenameParser = new ExpressionFilenameParser();
    private long pollingFrequency;
    private boolean autoDelete = true;
    private String outputPattern;
    private String identityFile;
    private String passphrase;
    private String knownHostsFile;
    private boolean checkFileAge = false;
    private long fileAge = 0L;
    private String tempDirInbound = null;
    private String tempDirOutbound = null;
    private Map<EndpointURI, GenericObjectPool> pools = new HashMap<EndpointURI, GenericObjectPool>();
    private String duplicateHandling = null;
    private Boolean useTempFileTimestampSuffix = null;
    private Long sizeCheckWaitTime = null;
    private String archiveDir = "";
    private String archiveTempReceivingDir = "";
    private String archiveTempSendingDir = "";
    private String preferredAuthenticationMethods;
    private Boolean keepFileOnError;
    private int maxConnectionPoolSize;
    private static final Integer overrideMaxConnectionPoolSize;

    public SftpConnector(MuleContext context) {
        super(context);
        this.filenameParser = new ExpressionFilenameParser();
    }

    public String getProtocol() {
        return "sftp";
    }

    public MessageReceiver createReceiver(FlowConstruct flow, InboundEndpoint endpoint) throws Exception {
        long polling = this.pollingFrequency;
        String tempPolling = (String)endpoint.getProperty((Object)PROPERTY_POLLING_FREQUENCY);
        if (tempPolling != null) {
            polling = Long.parseLong(tempPolling);
        }
        if (polling <= 0L) {
            polling = 1000L;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set polling frequency to: " + polling));
        }
        return this.serviceDescriptor.createMessageReceiver((Connector)this, flow, endpoint, new Object[]{polling});
    }

    public SftpClient createSftpClient(ImmutableEndpoint endpoint) throws Exception {
        return this.createSftpClient(endpoint, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpClient createSftpClient(ImmutableEndpoint endpoint, SftpNotifier notifier) throws Exception {
        SftpClient client = null;
        boolean ok = false;
        try {
            if (this.useConnectionPool()) {
                ObjectPool pool = this.getClientPool(endpoint);
                client = (SftpClient)pool.borrowObject();
            } else {
                client = SftpConnectionFactory.createClient(endpoint, this.preferredAuthenticationMethods);
            }
            String dir = endpoint.getEndpointURI().getPath();
            client.changeWorkingDirectory(dir);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully changed working directory to: " + dir));
            }
            client.setNotifier(notifier);
            ok = true;
        }
        finally {
            if (!ok && client != null) {
                this.releaseClient(endpoint, client);
            }
        }
        return client;
    }

    public boolean useConnectionPool() {
        return this.getMaxConnectionPoolSize() != 0;
    }

    public void releaseClient(ImmutableEndpoint endpoint, SftpClient client) throws Exception {
        if (this.useConnectionPool()) {
            if (this.getDispatcherFactory().isCreateDispatcherPerRequest()) {
                this.destroyClient(endpoint, client);
            } else if (client != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Releasing connection for endpoint " + endpoint.getEndpointURI()));
                }
                if (!client.isConnected()) {
                    this.doDestroyClient(endpoint, client);
                } else {
                    ObjectPool pool = this.getClientPool(endpoint);
                    pool.returnObject((Object)client);
                }
            }
        } else {
            client.disconnect();
        }
    }

    public void destroyClient(ImmutableEndpoint endpoint, SftpClient client) throws Exception {
        if (this.useConnectionPool() && client != null) {
            this.doDestroyClient(endpoint, client);
        }
    }

    protected void doDestroyClient(ImmutableEndpoint endpoint, SftpClient client) throws Exception {
        ObjectPool pool = this.getClientPool(endpoint);
        pool.invalidateObject((Object)client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectPool getClientPool(ImmutableEndpoint endpoint) {
        GenericObjectPool pool = this.pools.get(endpoint.getEndpointURI());
        if (pool == null) {
            Map<EndpointURI, GenericObjectPool> map = this.pools;
            synchronized (map) {
                pool = this.pools.get(endpoint.getEndpointURI());
                if (pool == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Pool is null - creating one for endpoint " + endpoint.getEndpointURI() + " with max size " + this.getMaxConnectionPoolSize()));
                    }
                    SftpConnectionFactory factory = new SftpConnectionFactory(endpoint);
                    factory.setPreferredAuthenticationMethods(this.preferredAuthenticationMethods);
                    pool = new GenericObjectPool((PoolableObjectFactory)factory, this.getMaxConnectionPoolSize());
                    pool.setTestOnBorrow(this.isValidateConnections());
                    this.pools.put(endpoint.getEndpointURI(), pool);
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Using existing pool for endpoint " + endpoint.getEndpointURI() + ". Active: " + pool.getNumActive() + ", Idle:" + pool.getNumIdle()));
                }
            }
        }
        return pool;
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }

    protected void doInitialise() throws InitialisationException {
        if (this.filenameParser != null) {
            this.filenameParser.setMuleContext(this.muleContext);
        }
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Stopping all pools");
        }
        try {
            for (ObjectPool objectPool : this.pools.values()) {
                objectPool.close();
            }
        }
        catch (Exception e) {
            throw new ConnectorException(CoreMessages.failedToStop((String)"SFTP Connector"), (Connector)this, (Throwable)e);
        }
        finally {
            this.pools.clear();
        }
    }

    public long getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(long pollingFrequency) {
        this.pollingFrequency = pollingFrequency;
    }

    public FilenameParser getFilenameParser() {
        return this.filenameParser;
    }

    public void setFilenameParser(FilenameParser filenameParser) {
        this.filenameParser = filenameParser;
        if (filenameParser != null) {
            filenameParser.setMuleContext(this.muleContext);
        }
    }

    public String getOutputPattern() {
        return this.outputPattern;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public String getIdentityFile() {
        return this.identityFile;
    }

    public void setIdentityFile(String identityFile) {
        this.identityFile = identityFile;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    public void setKnownHostsFile(String knownHostsFile) {
        this.knownHostsFile = knownHostsFile;
    }

    public long getFileAge() {
        return this.fileAge;
    }

    public void setFileAge(long fileAge) {
        this.fileAge = fileAge;
        this.checkFileAge = true;
    }

    public boolean getCheckFileAge() {
        return this.checkFileAge;
    }

    public String getTempDirInbound() {
        return this.tempDirInbound;
    }

    public void setTempDirInbound(String pTempDirInbound) {
        this.tempDirInbound = pTempDirInbound;
    }

    public String getTempDirOutbound() {
        return this.tempDirOutbound;
    }

    public void setTempDirOutbound(String pTempDirOutbound) {
        this.tempDirOutbound = pTempDirOutbound;
    }

    public void setDuplicateHandling(String duplicateHandling) {
        this.duplicateHandling = duplicateHandling;
    }

    public String getDuplicateHandling() {
        return this.duplicateHandling;
    }

    public void setUseTempFileTimestampSuffix(Boolean useTempFileTimestampSuffix) {
        this.useTempFileTimestampSuffix = useTempFileTimestampSuffix;
    }

    public Boolean isUseTempFileTimestampSuffix() {
        return this.useTempFileTimestampSuffix;
    }

    public void setSizeCheckWaitTime(Long sizeCheckWaitTime) {
        this.sizeCheckWaitTime = sizeCheckWaitTime;
    }

    public Long getSizeCheckWaitTime() {
        return this.sizeCheckWaitTime;
    }

    public void setArchiveDir(String archiveDir) {
        this.archiveDir = archiveDir;
    }

    public String getArchiveDir() {
        return this.archiveDir;
    }

    public void setArchiveTempReceivingDir(String archiveTempReceivingDir) {
        this.archiveTempReceivingDir = archiveTempReceivingDir;
    }

    public String getArchiveTempReceivingDir() {
        return this.archiveTempReceivingDir;
    }

    public void setArchiveTempSendingDir(String archiveTempSendingDir) {
        this.archiveTempSendingDir = archiveTempSendingDir;
    }

    public String getArchiveTempSendingDir() {
        return this.archiveTempSendingDir;
    }

    public void setMaxConnectionPoolSize(int maxConnectionPoolSize) {
        this.maxConnectionPoolSize = maxConnectionPoolSize;
    }

    public int getMaxConnectionPoolSize() {
        if (overrideMaxConnectionPoolSize != null) {
            return overrideMaxConnectionPoolSize;
        }
        return this.maxConnectionPoolSize;
    }

    public Boolean isKeepFileOnError() {
        return this.keepFileOnError;
    }

    public void setKeepFileOnError(Boolean pKeepFileOnError) {
        this.keepFileOnError = pKeepFileOnError;
    }

    public String getPreferredAuthenticationMethods() {
        return this.preferredAuthenticationMethods;
    }

    public void setPreferredAuthenticationMethods(String preferredAuthenticationMethods) {
        AuthenticationMethodValidator.validateAuthenticationMethods(preferredAuthenticationMethods);
        this.preferredAuthenticationMethods = preferredAuthenticationMethods;
    }

    public void connect() throws Exception {
        this.setConnected(true);
        this.connectConnectorAndReceivers();
    }

    public void disconnect() throws Exception {
        this.setConnected(false);
    }

    static {
        String propValue = System.getProperty("mule.sftp.transport.maxConnectionPoolSize");
        if (propValue != null) {
            logger.info((Object)("Will override the maxConnectionPoolSize to " + propValue + " from the system property 'mule.sftp.transport.maxConnectionPoolSize'."));
            overrideMaxConnectionPoolSize = Integer.parseInt(propValue);
        } else {
            overrideMaxConnectionPoolSize = null;
        }
    }
}

