/*
 * Decompiled with CFR 0.152.
 */
package org.mule.retry.async;

import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.retry.RetryContext;

public class FutureRetryContext
implements RetryContext {
    private RetryContext delegate;

    void setDelegateContext(RetryContext context) {
        this.delegate = context;
    }

    public boolean isReady() {
        return this.delegate != null;
    }

    protected void checkState() {
        if (!this.isReady()) {
            throw new IllegalStateException("Cannot perform operations on a FutureRetryContext until isReady() returns true");
        }
    }

    @Override
    public void addReturnMessage(MuleMessage result) {
        this.checkState();
        this.delegate.addReturnMessage(result);
    }

    @Override
    public String getDescription() {
        this.checkState();
        return this.delegate.getDescription();
    }

    @Override
    public MuleMessage getFirstReturnMessage() {
        this.checkState();
        return this.delegate.getFirstReturnMessage();
    }

    @Override
    public Map<Object, Object> getMetaInfo() {
        this.checkState();
        return this.delegate.getMetaInfo();
    }

    @Override
    public MuleMessage[] getReturnMessages() {
        this.checkState();
        return this.delegate.getReturnMessages();
    }

    @Override
    public void setReturnMessages(MuleMessage[] returnMessages) {
        this.checkState();
        this.delegate.setReturnMessages(returnMessages);
    }

    @Override
    public Throwable getLastFailure() {
        this.checkState();
        return this.delegate.getLastFailure();
    }

    @Override
    public void setOk() {
        this.checkState();
        this.delegate.setOk();
    }

    @Override
    public void setFailed(Throwable lastFailure) {
        this.checkState();
        this.delegate.setFailed(lastFailure);
    }

    @Override
    public boolean isOk() {
        this.checkState();
        return this.delegate.isOk();
    }

    @Override
    public MuleContext getMuleContext() {
        this.checkState();
        return this.delegate.getMuleContext();
    }
}

