/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.routing.RouterResultsHandler;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.routing.CorrelationMode;
import org.mule.routing.DefaultRouterResultsHandler;
import org.mule.routing.MessageSequence;
import org.mule.routing.outbound.PartitionedMessageSequence;

public abstract class AbstractMessageSequenceSplitter
extends AbstractInterceptingMessageProcessor
implements MuleContextAware {
    protected MuleContext muleContext;
    protected RouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
    protected CorrelationMode enableCorrelation = CorrelationMode.IF_NOT_SET;
    protected MessageInfoMapping messageInfoMapping;
    protected int batchSize;
    protected String counterVariableName;

    @Override
    public final MuleEvent process(MuleEvent event) throws MuleException {
        if (this.isSplitRequired(event)) {
            MessageSequence<?> seq = this.splitMessageIntoSequence(event);
            if (!seq.isEmpty()) {
                MuleEvent aggregatedResults = this.resultsHandler.aggregateResults(this.processParts(seq, event), event, this.muleContext);
                if (aggregatedResults instanceof VoidMuleEvent) {
                    return null;
                }
                return aggregatedResults;
            }
            this.logger.warn((Object)"Splitter returned no results. If this is not expected, please check your split expression");
            return VoidMuleEvent.getInstance();
        }
        return this.processNext(event);
    }

    protected boolean isSplitRequired(MuleEvent event) {
        return true;
    }

    protected abstract MessageSequence<?> splitMessageIntoSequence(MuleEvent var1) throws MuleException;

    protected List<MuleEvent> processParts(MessageSequence<?> seq, MuleEvent originalEvent) throws MuleException {
        if (this.messageInfoMapping == null) {
            this.messageInfoMapping = originalEvent.getFlowConstruct().getMessageInfoMapping();
        }
        String correlationId = this.messageInfoMapping.getCorrelationId(originalEvent.getMessage());
        ArrayList<MuleEvent> resultEvents = new ArrayList<MuleEvent>();
        int correlationSequence = 0;
        MessageSequence<?> messageSequence = seq;
        if (this.batchSize > 1) {
            messageSequence = new PartitionedMessageSequence(seq, this.batchSize);
        }
        int count = messageSequence.size();
        MuleEvent currentEvent = originalEvent;
        while (messageSequence.hasNext()) {
            Object payload = messageSequence.next();
            MuleMessage message = this.createMessage(payload, originalEvent.getMessage());
            ++correlationSequence;
            if (this.counterVariableName != null) {
                message.setInvocationProperty(this.counterVariableName, correlationSequence);
            }
            if (this.enableCorrelation != CorrelationMode.NEVER) {
                boolean correlationSet;
                boolean bl = correlationSet = message.getCorrelationId() != null;
                if (!correlationSet && this.enableCorrelation == CorrelationMode.IF_NOT_SET || this.enableCorrelation == CorrelationMode.ALWAYS) {
                    message.setCorrelationId(correlationId);
                }
                message.setCorrelationGroupSize(count);
                message.setCorrelationSequence(correlationSequence);
            }
            message.propagateRootId(originalEvent.getMessage());
            MuleEvent resultEvent = this.processNext(RequestContext.setEvent(new DefaultMuleEvent(message, originalEvent, currentEvent.getSession())));
            if (resultEvent == null || VoidMuleEvent.getInstance().equals(resultEvent)) continue;
            currentEvent = resultEvent;
            resultEvents.add(resultEvent);
        }
        if (correlationSequence == 1) {
            this.logger.debug((Object)"Splitter only returned a single result. If this is not expected, please check your split expression");
        }
        return resultEvents;
    }

    private MuleMessage createMessage(Object payload, MuleMessage originalMessage) {
        if (payload instanceof MuleMessage) {
            return (MuleMessage)payload;
        }
        DefaultMuleMessage message = new DefaultMuleMessage(originalMessage, this.muleContext);
        message.setPayload(payload);
        return message;
    }

    public void setEnableCorrelation(CorrelationMode enableCorrelation) {
        this.enableCorrelation = enableCorrelation;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setMessageInfoMapping(MessageInfoMapping messageInfoMapping) {
        this.messageInfoMapping = messageInfoMapping;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setCounterVariableName(String counterVariableName) {
        this.counterVariableName = counterVariableName;
    }
}

