/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.launcher.ArchiveDeployer;
import org.mule.module.launcher.ArtifactDeploymentTemplate;
import org.mule.module.launcher.CompositeDeploymentListener;
import org.mule.module.launcher.DefaultArchiveDeployer;
import org.mule.module.launcher.DefaultArtifactDeployer;
import org.mule.module.launcher.DeploymentDirectoryWatcher;
import org.mule.module.launcher.DeploymentException;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.DeploymentStatusTracker;
import org.mule.module.launcher.DomainArchiveDeployer;
import org.mule.module.launcher.DomainDeploymentTemplate;
import org.mule.module.launcher.PluginClassLoaderManager;
import org.mule.module.launcher.StartupListener;
import org.mule.module.launcher.StartupSummaryDeploymentListener;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.application.ApplicationClassLoaderFactory;
import org.mule.module.launcher.application.ApplicationFactory;
import org.mule.module.launcher.application.CompositeApplicationClassLoaderFactory;
import org.mule.module.launcher.application.DefaultApplicationFactory;
import org.mule.module.launcher.application.MuleApplicationClassLoaderFactory;
import org.mule.module.launcher.domain.DefaultDomainFactory;
import org.mule.module.launcher.domain.Domain;
import org.mule.module.launcher.domain.DomainFactory;
import org.mule.module.launcher.domain.MuleDomainClassLoaderRepository;
import org.mule.module.launcher.nativelib.DefaultNativeLibraryFinderFactory;
import org.mule.module.launcher.util.DebuggableReentrantLock;
import org.mule.module.launcher.util.ObservableList;
import org.mule.util.Preconditions;

public class MuleDeploymentService
implements DeploymentService {
    public static final String ARTIFACT_ANCHOR_SUFFIX = "-anchor.txt";
    public static final IOFileFilter ZIP_ARTIFACT_FILTER = new AndFileFilter((IOFileFilter)new SuffixFileFilter(".zip"), FileFileFilter.FILE);
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private final ReentrantLock deploymentLock = new DebuggableReentrantLock(true);
    private final ObservableList<Application> applications = new ObservableList();
    private final ObservableList<Domain> domains = new ObservableList();
    private final List<StartupListener> startupListeners = new ArrayList<StartupListener>();
    private final CompositeDeploymentListener applicationDeploymentListener = new CompositeDeploymentListener();
    private final CompositeDeploymentListener domainDeploymentListener = new CompositeDeploymentListener();
    private final ArchiveDeployer<Domain> domainDeployer;
    private final DeploymentDirectoryWatcher deploymentDirectoryWatcher;
    private DefaultArchiveDeployer<Application> applicationDeployer;

    public MuleDeploymentService(PluginClassLoaderManager pluginClassLoaderManager) {
        MuleDomainClassLoaderRepository domainClassLoaderRepository = new MuleDomainClassLoaderRepository();
        ApplicationClassLoaderFactory applicationClassLoaderFactory = new MuleApplicationClassLoaderFactory(domainClassLoaderRepository, new DefaultNativeLibraryFinderFactory());
        applicationClassLoaderFactory = new CompositeApplicationClassLoaderFactory(applicationClassLoaderFactory, pluginClassLoaderManager);
        DefaultDomainFactory domainFactory = new DefaultDomainFactory(domainClassLoaderRepository);
        domainFactory.setDeploymentListener(this.domainDeploymentListener);
        DefaultApplicationFactory applicationFactory = new DefaultApplicationFactory(applicationClassLoaderFactory, domainFactory);
        applicationFactory.setDeploymentListener(this.applicationDeploymentListener);
        DefaultArtifactDeployer applicationMuleDeployer = new DefaultArtifactDeployer();
        DefaultArtifactDeployer domainMuleDeployer = new DefaultArtifactDeployer();
        this.applicationDeployer = new DefaultArchiveDeployer<Application>(applicationMuleDeployer, applicationFactory, this.applications, this.deploymentLock, ArtifactDeploymentTemplate.NOP_ARTIFACT_DEPLOYMENT_TEMPLATE);
        this.applicationDeployer.setDeploymentListener(this.applicationDeploymentListener);
        this.domainDeployer = new DomainArchiveDeployer(new DefaultArchiveDeployer<Domain>(domainMuleDeployer, domainFactory, this.domains, this.deploymentLock, new DomainDeploymentTemplate(this.applicationDeployer, this)), this.applicationDeployer, applicationMuleDeployer, this);
        this.domainDeployer.setDeploymentListener(this.domainDeploymentListener);
        this.deploymentDirectoryWatcher = new DeploymentDirectoryWatcher(this.domainDeployer, this.applicationDeployer, this.domains, this.applications, this.deploymentLock);
    }

    @Override
    public void start() {
        DeploymentStatusTracker deploymentStatusTracker = new DeploymentStatusTracker();
        this.addDeploymentListener(deploymentStatusTracker.getApplicationDeploymentStatusTracker());
        this.addDomainDeploymentListener(deploymentStatusTracker.getDomainDeploymentStatusTracker());
        StartupSummaryDeploymentListener summaryDeploymentListener = new StartupSummaryDeploymentListener(deploymentStatusTracker, this);
        this.addStartupListener(summaryDeploymentListener);
        this.deploymentDirectoryWatcher.start();
        for (StartupListener listener : this.startupListeners) {
            try {
                listener.onAfterStartup();
            }
            catch (Throwable t) {
                this.logger.error((Object)t);
            }
        }
    }

    @Override
    public void stop() {
        this.deploymentDirectoryWatcher.stop();
    }

    @Override
    public Domain findDomain(String domainName) {
        return this.deploymentDirectoryWatcher.findArtifact(domainName, this.domains);
    }

    @Override
    public Application findApplication(String appName) {
        return this.deploymentDirectoryWatcher.findArtifact(appName, this.applications);
    }

    @Override
    public Collection<Application> findDomainApplications(final String domain) {
        Preconditions.checkArgument((domain != null ? 1 : 0) != 0, (String)"Domain name cannot be null");
        return CollectionUtils.select(this.applications, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((Application)object).getDomain().getArtifactName().equals(domain);
            }
        });
    }

    @Override
    public List<Application> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    @Override
    public List<Domain> getDomains() {
        return Collections.unmodifiableList(this.domains);
    }

    Map<URL, Long> getZombieApplications() {
        return this.applicationDeployer.getArtifactsZombieMap();
    }

    Map<URL, Long> getZombieDomains() {
        return this.domainDeployer.getArtifactsZombieMap();
    }

    public void setAppFactory(ApplicationFactory appFactory) {
        this.applicationDeployer.setArtifactFactory(appFactory);
    }

    @Override
    public ReentrantLock getLock() {
        return this.deploymentLock;
    }

    @Override
    public void undeploy(String appName) {
        this.applicationDeployer.undeployArtifact(appName);
    }

    @Override
    public void deploy(URL appArchiveUrl) throws IOException {
        this.applicationDeployer.deployPackagedArtifact(appArchiveUrl);
    }

    @Override
    public void redeploy(String artifactName) {
        block2: {
            try {
                this.applicationDeployer.redeploy(this.findApplication(artifactName));
            }
            catch (DeploymentException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)("Failure while redeploying application: " + artifactName), (Throwable)((Object)e));
            }
        }
    }

    @Override
    public void undeployDomain(String domainName) {
        this.domainDeployer.undeployArtifact(domainName);
    }

    @Override
    public void deployDomain(URL domainArchiveUrl) throws IOException {
        this.domainDeployer.deployPackagedArtifact(domainArchiveUrl);
    }

    @Override
    public void redeployDomain(String domainName) {
        this.domainDeployer.redeploy(this.findDomain(domainName));
    }

    @Override
    public void addStartupListener(StartupListener listener) {
        this.startupListeners.add(listener);
    }

    @Override
    public void removeStartupListener(StartupListener listener) {
        this.startupListeners.remove(listener);
    }

    @Override
    public void addDeploymentListener(DeploymentListener listener) {
        this.applicationDeploymentListener.addDeploymentListener(listener);
    }

    @Override
    public void removeDeploymentListener(DeploymentListener listener) {
        this.applicationDeploymentListener.removeDeploymentListener(listener);
    }

    @Override
    public void addDomainDeploymentListener(DeploymentListener listener) {
        this.domainDeploymentListener.addDeploymentListener(listener);
    }

    @Override
    public void removeDomainDeploymentListener(DeploymentListener listener) {
        this.domainDeploymentListener.removeDeploymentListener(listener);
    }

    public void setDomainFactory(DomainFactory domainFactory) {
        this.domainDeployer.setArtifactFactory(domainFactory);
    }

    void undeploy(Application app) {
        this.applicationDeployer.undeployArtifact(app.getArtifactName());
    }

    void undeploy(Domain domain) {
        this.domainDeployer.undeployArtifact(domain.getArtifactName());
    }
}

