/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.Serializable;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.construct.Flow;
import org.mule.construct.flow.DefaultFlowProcessingStrategy;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.processor.strategy.NonBlockingProcessingStrategy;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.types.DataTypeFactory;

@SmallTest
public class DefaultMuleEventTestCase
extends AbstractMuleTestCase {
    public static final String CUSTOM_ENCODING = "UTF-8";
    public static final String PROPERTY_NAME = "test";
    public static final String PROPERTY_VALUE = "foo";
    private final MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)"test-data", (Map)null, this.muleContext);
    private final DefaultMuleEvent muleEvent = new DefaultMuleEvent((MuleMessage)this.muleMessage, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)null);

    @Test
    public void setFlowVariableDefaultDataType() throws Exception {
        this.muleEvent.setFlowVariable(PROPERTY_NAME, (Object)PROPERTY_VALUE);
        DataType dataType = this.muleEvent.getFlowVariableDataType(PROPERTY_NAME);
        MatcherAssert.assertThat((Object)dataType, DataTypeMatcher.like(String.class, "*/*", null));
    }

    @Test
    public void setFlowVariableCustomDataType() throws Exception {
        DataType dataType = DataTypeFactory.create(String.class, (String)"application/xml");
        dataType.setEncoding(CUSTOM_ENCODING);
        this.muleEvent.setFlowVariable(PROPERTY_NAME, (Object)PROPERTY_VALUE, dataType);
        DataType actualDataType = this.muleEvent.getFlowVariableDataType(PROPERTY_NAME);
        MatcherAssert.assertThat((Object)actualDataType, DataTypeMatcher.like(String.class, "application/xml", CUSTOM_ENCODING));
    }

    @Test
    public void setSessionVariableDefaultDataType() throws Exception {
        this.muleEvent.setSessionVariable(PROPERTY_NAME, (Object)PROPERTY_VALUE);
        DataType dataType = this.muleEvent.getSessionVariableDataType(PROPERTY_NAME);
        MatcherAssert.assertThat((Object)dataType, DataTypeMatcher.like(String.class, "*/*", null));
    }

    @Test
    public void setSessionVariableCustomDataType() throws Exception {
        DataType dataType = DataTypeFactory.create(String.class, (String)"application/xml");
        dataType.setEncoding(CUSTOM_ENCODING);
        this.muleEvent.setSessionVariable(PROPERTY_NAME, (Serializable)((Object)PROPERTY_VALUE), dataType);
        DataType actualDataType = this.muleEvent.getSessionVariableDataType(PROPERTY_NAME);
        MatcherAssert.assertThat((Object)actualDataType, DataTypeMatcher.like(String.class, "application/xml", CUSTOM_ENCODING));
    }

    @Test
    public void defaultProcessingStrategyRequestResponse() throws Exception {
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.getProcessingStrategy()).thenReturn((Object)new DefaultFlowProcessingStrategy());
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.muleMessage, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)flow);
        MatcherAssert.assertThat((Object)event.isSynchronous(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)event.isTransacted(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void defaultProcessingStrategyOneWay() throws Exception {
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.getProcessingStrategy()).thenReturn((Object)new DefaultFlowProcessingStrategy());
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.muleMessage, MessageExchangePattern.ONE_WAY, (FlowConstruct)flow);
        MatcherAssert.assertThat((Object)event.isSynchronous(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)event.isTransacted(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void syncProcessingStrategyRequestResponse() throws Exception {
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.isSynchronous()).thenReturn((Object)true);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.muleMessage, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)flow);
        MatcherAssert.assertThat((Object)event.isSynchronous(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)event.isTransacted(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void syncProcessingStrategyOneWay() throws Exception {
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.isSynchronous()).thenReturn((Object)true);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.muleMessage, MessageExchangePattern.ONE_WAY, (FlowConstruct)flow);
        MatcherAssert.assertThat((Object)event.isSynchronous(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)event.isTransacted(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void inboundPropertyForceSyncRequestResponse() throws Exception {
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.isSynchronous()).thenReturn((Object)false);
        this.muleMessage.setProperty("MULE_FORCE_SYNC", (Object)true, PropertyScope.INBOUND);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.muleMessage, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)flow);
        MatcherAssert.assertThat((Object)event.isSynchronous(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)event.isTransacted(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void inboundPropertyForceSyncOneWay() throws Exception {
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.isSynchronous()).thenReturn((Object)false);
        this.muleMessage.setProperty("MULE_FORCE_SYNC", (Object)true, PropertyScope.INBOUND);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.muleMessage, MessageExchangePattern.ONE_WAY, (FlowConstruct)flow);
        MatcherAssert.assertThat((Object)event.isSynchronous(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)event.isTransacted(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void nonBlockingProcessingStrategyRequestResponse() throws Exception {
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.isSynchronous()).thenReturn((Object)false);
        Mockito.when((Object)flow.getProcessingStrategy()).thenReturn((Object)new NonBlockingProcessingStrategy());
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.muleMessage, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)flow);
        MatcherAssert.assertThat((Object)event.isSynchronous(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)event.isTransacted(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void nonBlockingProcessingStrategyOneWay() throws Exception {
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.isSynchronous()).thenReturn((Object)false);
        Mockito.when((Object)flow.getProcessingStrategy()).thenReturn((Object)new NonBlockingProcessingStrategy());
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.muleMessage, MessageExchangePattern.ONE_WAY, (FlowConstruct)flow);
        MatcherAssert.assertThat((Object)event.isSynchronous(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)event.isTransacted(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void transactedRequestResponse() throws Exception {
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.isSynchronous()).thenReturn((Object)false);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.muleMessage, this.createMockTransactionalInboundEndpoint(), (FlowConstruct)flow);
        MatcherAssert.assertThat((Object)event.isSynchronous(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)event.isTransacted(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void transactedOneWay() throws Exception {
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.isSynchronous()).thenReturn((Object)false);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)this.muleMessage, this.createMockTransactionalInboundEndpoint(), (FlowConstruct)flow);
        MatcherAssert.assertThat((Object)event.isSynchronous(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)event.isTransacted(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    private InboundEndpoint createMockTransactionalInboundEndpoint() throws EndpointException {
        InboundEndpoint inboundEndpoint = (InboundEndpoint)Mockito.mock(InboundEndpoint.class);
        TransactionConfig transactionConfig = (TransactionConfig)Mockito.mock(TransactionConfig.class);
        Mockito.when((Object)transactionConfig.isTransacted()).thenReturn((Object)true);
        Mockito.when((Object)inboundEndpoint.getTransactionConfig()).thenReturn((Object)transactionConfig);
        Mockito.when((Object)inboundEndpoint.getEndpointURI()).thenReturn((Object)new MuleEndpointURI("test://test", this.muleContext));
        return inboundEndpoint;
    }
}

