/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import javax.xml.namespace.QName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.AnnotatedObject;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.TestNotSerializableMessageProcessor;
import org.mule.api.TestSerializableMessageProcessor;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.MessageProcessorPathResolver;
import org.mule.api.execution.LocationExecutionContextProvider;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.exception.MessagingExceptionLocationProvider;
import org.mule.tck.SerializationTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class MessagingExceptionTestCase
extends AbstractMuleContextTestCase {
    private static final String message = "a message";
    private static final String value = "Hello world!";
    private boolean originalVerboseExceptions;
    private LocationExecutionContextProvider locationProvider = new MessagingExceptionLocationProvider();
    @Mock
    private MuleEvent mockEvent;
    private static QName docNameAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "name");
    private static QName sourceFileNameAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileName");
    private static QName sourceFileLineAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileLine");

    @Before
    public void before() {
        this.originalVerboseExceptions = DefaultMuleConfiguration.verboseExceptions;
        MuleContext mockContext = (MuleContext)Mockito.mock(MuleContext.class);
        DefaultMuleConfiguration mockConfiguration = (DefaultMuleConfiguration)Mockito.mock(DefaultMuleConfiguration.class);
        Mockito.when((Object)mockConfiguration.getId()).thenReturn((Object)"MessagingExceptionTestCase");
        Mockito.when((Object)mockContext.getConfiguration()).thenReturn((Object)mockConfiguration);
        Mockito.when((Object)this.mockEvent.getMuleContext()).thenReturn((Object)mockContext);
    }

    @After
    public void after() {
        DefaultMuleConfiguration.verboseExceptions = this.originalVerboseExceptions;
    }

    @Test
    public void getCauseExceptionWithoutCause() {
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent);
        Assert.assertThat((Object)((MessagingException)exception.getCauseException()), (Matcher)CoreMatchers.is((Object)exception));
    }

    @Test
    public void getCauseExceptionWithMuleCause() {
        DefaultMuleException causeException = new DefaultMuleException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)((DefaultMuleException)exception.getCauseException()), (Matcher)CoreMatchers.is((Object)causeException));
    }

    @Test
    public void getCauseExceptionWithMuleCauseWithMuleCause() {
        DefaultMuleException causeCauseException = new DefaultMuleException("");
        DefaultMuleException causeException = new DefaultMuleException((Throwable)causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)((DefaultMuleException)exception.getCauseException()), (Matcher)CoreMatchers.is((Object)causeCauseException));
    }

    @Test
    public void getCauseExceptionWithNonMuleCause() {
        IOException causeException = new IOException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)((IOException)exception.getCauseException()), (Matcher)CoreMatchers.is((Object)causeException));
    }

    @Test
    public void getCauseExceptionWithNonMuleCauseWithNonMuleCause() {
        ConnectException causeCauseException = new ConnectException();
        IOException causeException = new IOException(causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)((ConnectException)exception.getCauseException()), (Matcher)CoreMatchers.is((Object)causeCauseException));
    }

    @Test
    public void causedByWithNullCause() {
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent);
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(Exception.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(DefaultMuleException.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedBy(IOException.class), (Matcher)Is.is((Object)false));
    }

    @Test
    public void causedByWithMuleCauseWithMuleCause() {
        DefaultMuleException causeCauseException = new DefaultMuleException("");
        DefaultMuleException causeException = new DefaultMuleException((Throwable)causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedBy(DefaultMuleException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void causedByWithNonMuleCause() {
        IOException causeException = new IOException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedBy(IOException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(Exception.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(NullPointerException.class), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void causedByWithNonMuleCauseWithNonMuleCause() {
        ConnectException causeCauseException = new ConnectException();
        IOException causeException = new IOException(causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedBy(NullPointerException.class), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)exception.causedBy(SocketException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(IOException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void causedExactlyByWithNullCause() {
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent);
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(Exception.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(DefaultMuleException.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(IOException.class), (Matcher)Is.is((Object)false));
    }

    @Test
    public void causedExactlyByWithMuleCauseWithMuleCause() {
        DefaultMuleException causeCauseException = new DefaultMuleException("");
        DefaultMuleException causeException = new DefaultMuleException((Throwable)causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedExactlyBy(DefaultMuleException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void causedExactlyByWithNonMuleCause() {
        IOException causeException = new IOException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedExactlyBy(IOException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(Exception.class), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(NullPointerException.class), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void causedExactlyByWithNonMuleCauseWithNonMuleCause() {
        ConnectException causeCauseException = new ConnectException();
        IOException causeException = new IOException(causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedExactlyBy(ConnectException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(SocketException.class), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(IOException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void withFailingProcessorNoPathResolver() {
        MessageProcessor mockProcessor = (MessageProcessor)Mockito.mock(MessageProcessor.class);
        Mockito.when((Object)this.mockEvent.getFlowConstruct()).thenReturn(null);
        Mockito.when((Object)mockProcessor.toString()).thenReturn((Object)"Mock@1");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, mockProcessor);
        exception.getInfo().putAll(this.locationProvider.getContextInfo(this.mockEvent, mockProcessor));
        Assert.assertThat((Object)exception.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"Mock@1 @ MessagingExceptionTestCase"));
    }

    @Test
    public void withFailingProcessorPathResolver() {
        MessageProcessor mockProcessor = (MessageProcessor)Mockito.mock(MessageProcessor.class);
        MessageProcessorPathResolver pathResolver = (MessageProcessorPathResolver)Mockito.mock(MessageProcessorPathResolver.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{FlowConstruct.class}));
        Mockito.when((Object)pathResolver.getProcessorPath((MessageProcessor)Matchers.eq((Object)mockProcessor))).thenReturn((Object)"/flow/processor");
        Mockito.when((Object)this.mockEvent.getFlowConstruct()).thenReturn((Object)((FlowConstruct)pathResolver));
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, mockProcessor);
        exception.getInfo().putAll(this.locationProvider.getContextInfo(this.mockEvent, mockProcessor));
        Assert.assertThat((Object)exception.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"/flow/processor @ MessagingExceptionTestCase"));
    }

    @Test
    public void withFailingProcessorNotPathResolver() {
        MessageProcessor mockProcessor = (MessageProcessor)Mockito.mock(MessageProcessor.class);
        FlowConstruct nonPathResolver = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)this.mockEvent.getFlowConstruct()).thenReturn((Object)nonPathResolver);
        Mockito.when((Object)mockProcessor.toString()).thenReturn((Object)"Mock@1");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, mockProcessor);
        exception.getInfo().putAll(this.locationProvider.getContextInfo(this.mockEvent, mockProcessor));
        Assert.assertThat((Object)exception.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"Mock@1 @ MessagingExceptionTestCase"));
    }

    @Test
    public void withAnnotatedFailingProcessorNoPathResolver() {
        MessageProcessor mockProcessor = (MessageProcessor)Mockito.mock(MessageProcessor.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{AnnotatedObject.class}));
        Mockito.when((Object)((AnnotatedObject)mockProcessor).getAnnotation((QName)Matchers.eq((Object)docNameAttrName))).thenReturn((Object)"Mock Component");
        Mockito.when((Object)((AnnotatedObject)mockProcessor).getAnnotation((QName)Matchers.eq((Object)sourceFileNameAttrName))).thenReturn((Object)"muleApp.xml");
        Mockito.when((Object)((AnnotatedObject)mockProcessor).getAnnotation((QName)Matchers.eq((Object)sourceFileLineAttrName))).thenReturn((Object)10);
        Mockito.when((Object)this.mockEvent.getFlowConstruct()).thenReturn(null);
        Mockito.when((Object)mockProcessor.toString()).thenReturn((Object)"Mock@1");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, mockProcessor);
        exception.getInfo().putAll(this.locationProvider.getContextInfo(this.mockEvent, mockProcessor));
        Assert.assertThat((Object)exception.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"Mock@1 @ MessagingExceptionTestCase:muleApp.xml:10 (Mock Component)"));
    }

    @Test
    public void withAnnotatedFailingProcessorPathResolver() {
        MessageProcessor mockProcessor = (MessageProcessor)Mockito.mock(MessageProcessor.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{AnnotatedObject.class}));
        Mockito.when((Object)((AnnotatedObject)mockProcessor).getAnnotation((QName)Matchers.eq((Object)docNameAttrName))).thenReturn((Object)"Mock Component");
        Mockito.when((Object)((AnnotatedObject)mockProcessor).getAnnotation((QName)Matchers.eq((Object)sourceFileNameAttrName))).thenReturn((Object)"muleApp.xml");
        Mockito.when((Object)((AnnotatedObject)mockProcessor).getAnnotation((QName)Matchers.eq((Object)sourceFileLineAttrName))).thenReturn((Object)10);
        MessageProcessorPathResolver pathResolver = (MessageProcessorPathResolver)Mockito.mock(MessageProcessorPathResolver.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{FlowConstruct.class}));
        Mockito.when((Object)pathResolver.getProcessorPath((MessageProcessor)Matchers.eq((Object)mockProcessor))).thenReturn((Object)"/flow/processor");
        Mockito.when((Object)this.mockEvent.getFlowConstruct()).thenReturn((Object)((FlowConstruct)pathResolver));
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, mockProcessor);
        exception.getInfo().putAll(this.locationProvider.getContextInfo(this.mockEvent, mockProcessor));
        Assert.assertThat((Object)exception.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"/flow/processor @ MessagingExceptionTestCase:muleApp.xml:10 (Mock Component)"));
    }

    @Test
    public void withAnnotatedFailingProcessorNotPathResolver() {
        MessageProcessor mockProcessor = (MessageProcessor)Mockito.mock(MessageProcessor.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{AnnotatedObject.class}));
        Mockito.when((Object)((AnnotatedObject)mockProcessor).getAnnotation((QName)Matchers.eq((Object)docNameAttrName))).thenReturn((Object)"Mock Component");
        Mockito.when((Object)((AnnotatedObject)mockProcessor).getAnnotation((QName)Matchers.eq((Object)sourceFileNameAttrName))).thenReturn((Object)"muleApp.xml");
        Mockito.when((Object)((AnnotatedObject)mockProcessor).getAnnotation((QName)Matchers.eq((Object)sourceFileLineAttrName))).thenReturn((Object)10);
        FlowConstruct nonPathResolver = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)this.mockEvent.getFlowConstruct()).thenReturn((Object)nonPathResolver);
        Mockito.when((Object)mockProcessor.toString()).thenReturn((Object)"Mock@1");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, mockProcessor);
        exception.getInfo().putAll(this.locationProvider.getContextInfo(this.mockEvent, mockProcessor));
        Assert.assertThat((Object)exception.getInfo().get("Element").toString(), (Matcher)CoreMatchers.is((Object)"Mock@1 @ MessagingExceptionTestCase:muleApp.xml:10 (Mock Component)"));
    }

    @Test
    public void serializableMessagingException() throws Exception {
        TestSerializableMessageProcessor processor = new TestSerializableMessageProcessor();
        processor.setValue(value);
        MessagingException e = new MessagingException(MessageFactory.createStaticMessage((String)message), MessagingExceptionTestCase.getTestEvent(""), (MessageProcessor)processor);
        e = SerializationTestUtils.testException(e, muleContext);
        Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)message));
        Assert.assertThat((Object)e.getFailingMessageProcessor(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)e.getFailingMessageProcessor(), (Matcher)IsInstanceOf.instanceOf(TestSerializableMessageProcessor.class));
        Assert.assertThat((Object)((TestSerializableMessageProcessor)e.getFailingMessageProcessor()).getValue(), (Matcher)CoreMatchers.is((Object)value));
    }

    @Test
    public void nonSerializableMessagingException() throws Exception {
        TestNotSerializableMessageProcessor processor = new TestNotSerializableMessageProcessor();
        MessagingException e = new MessagingException(MessageFactory.createStaticMessage((String)message), MessagingExceptionTestCase.getTestEvent(""), (MessageProcessor)processor);
        e = SerializationTestUtils.testException(e, muleContext);
        Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)message));
        Assert.assertThat((Object)e.getFailingMessageProcessor(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void payloadInfoNonConsumable() throws Exception {
        DefaultMuleConfiguration.verboseExceptions = true;
        MuleEvent testEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleMessage muleMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Object payload = Mockito.mock(Object.class);
        Mockito.when((Object)payload.toString()).then((Answer)new FailAnswer("toString() expected not to be called."));
        Mockito.when((Object)muleMessage.getPayload()).thenReturn(payload);
        Mockito.when((Object)muleMessage.getPayloadAsString()).thenReturn((Object)value);
        Mockito.when((Object)testEvent.getMessage()).thenReturn((Object)muleMessage);
        MessagingException e = new MessagingException(MessageFactory.createStaticMessage((String)message), testEvent);
        Assert.assertThat((Object)((String)e.getInfo().get("Payload")), (Matcher)CoreMatchers.is((Object)value));
    }

    @Test
    public void payloadInfoConsumable() throws Exception {
        DefaultMuleConfiguration.verboseExceptions = true;
        MuleEvent testEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleMessage muleMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)muleMessage.getPayload()).thenReturn((Object)new ByteArrayInputStream(new byte[0]));
        Mockito.when((Object)testEvent.getMessage()).thenReturn((Object)muleMessage);
        MessagingException e = new MessagingException(MessageFactory.createStaticMessage((String)message), testEvent);
        Assert.assertThat((Object)((String)e.getInfo().get("Payload")), (Matcher)CoreMatchers.containsString((String)(ByteArrayInputStream.class.getName() + "@")));
        ((MuleMessage)Mockito.verify((Object)muleMessage, (VerificationMode)Mockito.never())).getPayloadAsString();
    }

    @Test
    public void payloadInfoException() throws Exception {
        DefaultMuleConfiguration.verboseExceptions = true;
        MuleEvent testEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleMessage muleMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Object payload = Mockito.mock(Object.class);
        Mockito.when((Object)payload.toString()).then((Answer)new FailAnswer("toString() expected not to be called."));
        Mockito.when((Object)muleMessage.getPayload()).thenReturn(payload);
        Mockito.when((Object)muleMessage.getPayloadAsString()).thenThrow(new Throwable[]{new Exception("exception thrown")});
        Mockito.when((Object)testEvent.getMessage()).thenReturn((Object)muleMessage);
        MessagingException e = new MessagingException(MessageFactory.createStaticMessage((String)message), testEvent);
        Assert.assertThat((Object)((String)e.getInfo().get("Payload")), (Matcher)CoreMatchers.is((Object)(Exception.class.getName() + " while getting payload: exception thrown")));
    }

    @Test
    public void payloadInfoNonVerbose() throws Exception {
        DefaultMuleConfiguration.verboseExceptions = false;
        MuleEvent testEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleMessage muleMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)testEvent.getMessage()).thenReturn((Object)muleMessage);
        MessagingException e = new MessagingException(MessageFactory.createStaticMessage((String)message), testEvent);
        Assert.assertThat(e.getInfo().get("Payload"), (Matcher)CoreMatchers.nullValue());
        ((MuleMessage)Mockito.verify((Object)muleMessage, (VerificationMode)Mockito.never())).getPayload();
        ((MuleMessage)Mockito.verify((Object)muleMessage, (VerificationMode)Mockito.never())).getPayloadAsString();
    }

    private static final class FailAnswer
    implements Answer<String> {
        private final String failMessage;

        private FailAnswer(String failMessage) {
            this.failMessage = failMessage;
        }

        public String answer(InvocationOnMock invocation) throws Throwable {
            Assert.fail((String)this.failMessage);
            return null;
        }
    }
}

