/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.concurrent;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.concurrent.ExceptionCollectingThreadGroup;
import org.mule.util.concurrent.LastRejectedWaitPolicy;
import org.mule.util.concurrent.SleepyTask;

public class WaitPolicyTestCase
extends AbstractMuleTestCase {
    private ExceptionCollectingThreadGroup threadGroup;
    ThreadPoolExecutor executor;
    ReentrantLock executorLock;

    @Before
    public void startExecutor() {
        this.executor = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1));
        this.executor.prestartAllCoreThreads();
        this.executorLock = new ReentrantLock(true);
        this.threadGroup = new ExceptionCollectingThreadGroup();
        SleepyTask.activeTasks.set(0);
    }

    @After
    public void shutDownExecutor() {
        this.executor.shutdown();
        this.threadGroup.destroy();
    }

    protected LinkedList<Thread> execute(List<Runnable> tasks) throws InterruptedException {
        if (tasks == null || tasks.isEmpty()) {
            throw new IllegalArgumentException("List<Runnable> must not be empty");
        }
        LinkedList<Thread> submitters = new LinkedList<Thread>();
        this.executorLock.lock();
        for (final Runnable task : tasks) {
            Runnable submitterAction = new Runnable(){

                @Override
                public void run() {
                    try {
                        WaitPolicyTestCase.this.executorLock.lock();
                        WaitPolicyTestCase.this.executor.execute(task);
                    }
                    finally {
                        WaitPolicyTestCase.this.executorLock.unlock();
                    }
                }
            };
            Thread submitter = new Thread((ThreadGroup)this.threadGroup, submitterAction);
            submitter.setDaemon(true);
            submitters.add(submitter);
            submitter.start();
            while (submitter.isAlive() && !this.executorLock.hasQueuedThread(submitter)) {
                Thread.sleep(10L);
            }
        }
        this.executorLock.unlock();
        return submitters;
    }

    @Test
    public void testWaitPolicyWithShutdownExecutor() throws Exception {
        Assert.assertEquals((long)0L, (long)SleepyTask.activeTasks.get());
        this.executor.setRejectedExecutionHandler((RejectedExecutionHandler)((Object)new LastRejectedWaitPolicy()));
        this.executor.shutdown();
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        tasks.add(new SleepyTask("rejected", 1000L));
        LinkedList<Thread> submitters = this.execute(tasks);
        junit.framework.Assert.assertFalse((boolean)submitters.isEmpty());
        Thread.sleep(1000L);
        LinkedList<Map<Thread, Throwable>> exceptions = this.threadGroup.collectedExceptions();
        Assert.assertEquals((long)1L, (long)exceptions.size());
        Map.Entry<Thread, Throwable> threadFailure = exceptions.getFirst().entrySet().iterator().next();
        Assert.assertEquals((Object)submitters.getFirst(), (Object)threadFailure.getKey());
        Assert.assertEquals(RejectedExecutionException.class, threadFailure.getValue().getClass());
        Assert.assertEquals((long)0L, (long)SleepyTask.activeTasks.get());
    }

    @Test
    public void testWaitPolicyForever() throws Exception {
        Assert.assertEquals((long)0L, (long)SleepyTask.activeTasks.get());
        LastRejectedWaitPolicy policy = new LastRejectedWaitPolicy(-1L, TimeUnit.SECONDS);
        this.executor.setRejectedExecutionHandler((RejectedExecutionHandler)((Object)policy));
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        tasks.add(new SleepyTask("run", 1000L));
        tasks.add(new SleepyTask("queued", 1000L));
        SleepyTask waiting = new SleepyTask("waitingForever", 1000L);
        tasks.add(waiting);
        LinkedList<Thread> submitters = this.execute(tasks);
        junit.framework.Assert.assertFalse((boolean)submitters.isEmpty());
        junit.framework.Assert.assertFalse((boolean)this.executor.awaitTermination(4000L, TimeUnit.MILLISECONDS));
        Assert.assertSame((Object)waiting, (Object)policy.lastRejectedRunnable());
        Assert.assertEquals((long)0L, (long)SleepyTask.activeTasks.get());
    }

    @Test
    public void testWaitPolicyWithTimeout() throws Exception {
        Assert.assertEquals((long)0L, (long)SleepyTask.activeTasks.get());
        LastRejectedWaitPolicy policy = new LastRejectedWaitPolicy(2500L, TimeUnit.MILLISECONDS);
        this.executor.setRejectedExecutionHandler((RejectedExecutionHandler)((Object)policy));
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        tasks.add(new SleepyTask("run", 1000L));
        tasks.add(new SleepyTask("queued", 1000L));
        SleepyTask waiting = new SleepyTask("waiting", 1000L);
        tasks.add(waiting);
        LinkedList<Thread> submitters = this.execute(tasks);
        junit.framework.Assert.assertFalse((boolean)submitters.isEmpty());
        junit.framework.Assert.assertFalse((boolean)this.executor.awaitTermination(5000L, TimeUnit.MILLISECONDS));
        Assert.assertSame((Object)waiting, (Object)policy.lastRejectedRunnable());
        Assert.assertEquals((long)0L, (long)SleepyTask.activeTasks.get());
    }

    @Test
    public void testWaitPolicyWithTimeoutFailure() throws Exception {
        Assert.assertEquals((long)0L, (long)SleepyTask.activeTasks.get());
        long failureInterval = 100L;
        LastRejectedWaitPolicy policy = new LastRejectedWaitPolicy(failureInterval, TimeUnit.MILLISECONDS);
        this.executor.setRejectedExecutionHandler((RejectedExecutionHandler)((Object)policy));
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        tasks.add(new SleepyTask("run", 1000L));
        tasks.add(new SleepyTask("queued", 1000L));
        SleepyTask failedTask = new SleepyTask("waitAndFail", 1000L);
        tasks.add(failedTask);
        LinkedList<Thread> submitters = this.execute(tasks);
        junit.framework.Assert.assertFalse((boolean)submitters.isEmpty());
        Thread.sleep(failureInterval * 10L);
        LinkedList<Map<Thread, Throwable>> exceptions = this.threadGroup.collectedExceptions();
        Assert.assertEquals((long)1L, (long)exceptions.size());
        Map.Entry<Thread, Throwable> threadFailure = exceptions.getFirst().entrySet().iterator().next();
        Assert.assertEquals((Object)submitters.getLast(), (Object)threadFailure.getKey());
        Assert.assertEquals(RejectedExecutionException.class, threadFailure.getValue().getClass());
        this.executor.shutdown();
        Assert.assertTrue((boolean)this.executor.awaitTermination(2500L, TimeUnit.MILLISECONDS));
        Assert.assertSame((Object)failedTask, (Object)policy.lastRejectedRunnable());
        Assert.assertEquals((long)0L, (long)SleepyTask.activeTasks.get());
    }
}

