/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.journal;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.api.MuleContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.journal.JournalEntry;
import org.mule.util.journal.JournalEntrySerializer;
import org.mule.util.journal.TransactionJournalFile;
import org.mule.util.journal.queue.LocalQueueTxJournalEntry;
import org.mule.util.journal.queue.LocalTxQueueTransactionJournal;

public class TransactionJournalFileTestCase
extends AbstractMuleContextTestCase {
    private static final long KB_500 = 512000L;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void largeQueueName() throws Exception {
        String queueName = RandomStringUtils.randomAlphanumeric((int)129);
        String payload = "Hello World!";
        boolean txId = true;
        TransactionJournalFile<Integer, LocalQueueTxJournalEntry> journal = this.openJournal();
        journal.logOperation((JournalEntry)new LocalQueueTxJournalEntry(1, 6, queueName, (Serializable)((Object)payload)));
        journal.close();
        journal = this.openJournal();
        Collection entries = journal.getLogEntries((Object)1);
        Assert.assertThat((Object)entries, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)entries.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        LocalQueueTxJournalEntry entry = (LocalQueueTxJournalEntry)entries.iterator().next();
        Assert.assertThat((Object)entry.getQueueName(), (Matcher)CoreMatchers.equalTo((Object)queueName));
        Assert.assertThat((Object)entry.getValue(), (Matcher)CoreMatchers.equalTo((Object)payload));
    }

    private TransactionJournalFile<Integer, LocalQueueTxJournalEntry> openJournal() {
        File journalFile = new File(this.temporaryFolder.getRoot(), "journal");
        JournalEntrySerializer serializer = LocalTxQueueTransactionJournal.createLocalTxQueueJournalEntrySerializer((MuleContext)muleContext);
        return new TransactionJournalFile(journalFile, serializer, Long.valueOf(512000L));
    }
}

