/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.EvalCondition;
import org.drools.spi.PropagationContext;
import org.drools.util.Iterator;
import org.drools.util.LeftTupleList;

public class EvalConditionNode
extends LeftTupleSource
implements LeftTupleSinkNode,
NodeMemory {
    private static final long serialVersionUID = 400L;
    private EvalCondition condition;
    private LeftTupleSource tupleSource;
    protected boolean tupleMemoryEnabled;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;

    public EvalConditionNode() {
    }

    public EvalConditionNode(int id, LeftTupleSource tupleSource, EvalCondition eval, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.condition = eval;
        this.tupleSource = tupleSource;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.condition = (EvalCondition)in.readObject();
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.condition);
        out.writeObject(this.tupleSource);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated() {
        this.tupleSource.networkUpdated();
    }

    public EvalCondition getCondition() {
        return this.condition;
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        EvalMemory memory = (EvalMemory)workingMemory.getNodeMemory(this);
        boolean allowed = this.condition.isAllowed(leftTuple, workingMemory, memory.context);
        if (allowed) {
            if (this.tupleMemoryEnabled) {
                memory.tupleMemory.add(leftTuple);
            }
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
        }
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        EvalMemory memory = (EvalMemory)workingMemory.getNodeMemory(this);
        memory.tupleMemory.remove(leftTuple);
        this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
    }

    public String toString() {
        return "[EvalConditionNode: cond=" + this.condition + "]";
    }

    public int hashCode() {
        return this.tupleSource.hashCode() ^ this.condition.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != EvalConditionNode.class) {
            return false;
        }
        EvalConditionNode other = (EvalConditionNode)object;
        return this.tupleSource.equals(other.tupleSource) && this.condition.equals(other.condition);
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new EvalMemory(this.tupleMemoryEnabled, this.condition.createContext());
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        EvalMemory memory = (EvalMemory)workingMemory.getNodeMemory(this);
        Iterator it = memory.tupleMemory.iterator();
        LeftTuple tuple = (LeftTuple)it.next();
        while (tuple != null) {
            sink.assertLeftTuple(tuple, context, workingMemory);
            tuple = (LeftTuple)it.next();
        }
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        context.visitTupleSource(this);
        if (!node.isInUse()) {
            this.removeTupleSink((LeftTupleSink)((Object)node));
        }
        if (!this.isInUse()) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                EvalMemory memory = (EvalMemory)workingMemories[i].getNodeMemory(this);
                Iterator it = memory.getLeftTupleMemory().iterator();
                LeftTuple leftTuple = (LeftTuple)it.next();
                while (leftTuple != null) {
                    leftTuple.unlinkFromLeftParent();
                    leftTuple.unlinkFromRightParent();
                    leftTuple = (LeftTuple)it.next();
                }
                workingMemories[i].clearNodeMemory(this);
            }
        }
        if (!context.alreadyVisited(this.tupleSource)) {
            this.tupleSource.remove(context, builder, this, workingMemories);
        }
    }

    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public short getType() {
        return 3;
    }

    public static class EvalMemory
    implements Externalizable {
        private static final long serialVersionUID = -2754669682742843929L;
        public LeftTupleList tupleMemory;
        public Object context;

        public EvalMemory() {
        }

        public LeftTupleList getLeftTupleMemory() {
            return this.tupleMemory;
        }

        public EvalMemory(boolean tupleMemoryEnabled, Object context) {
            this.context = context;
            if (tupleMemoryEnabled) {
                this.tupleMemory = new LeftTupleList();
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.tupleMemory = (LeftTupleList)in.readObject();
            this.context = in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.tupleMemory);
            out.writeObject(this.context);
        }
    }
}

