/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.jetty;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.NoReceiverForEndpointException;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.servlet.MuleReceiverServlet;
import org.mule.transport.servlet.jetty.JettyHttpMessageReceiver;
import org.mule.util.StringUtils;

public class JettyReceiverServlet
extends MuleReceiverServlet {
    private static final long serialVersionUID = 238326861089137293L;
    private ConcurrentMap receivers = new ConcurrentHashMap(4);

    public JettyReceiverServlet(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    protected MessageReceiver getReceiverForURI(HttpServletRequest httpServletRequest) throws EndpointException {
        MessageReceiver receiver;
        String key = httpServletRequest.getPathInfo();
        if ("".equals(key)) {
            key = httpServletRequest.getContextPath();
        }
        if ((receiver = (MessageReceiver)this.receivers.get(key)) == null) {
            receiver = HttpConnector.findReceiverByStem((Map)this.receivers, (String)key);
        }
        if (receiver == null) {
            throw new NoReceiverForEndpointException(httpServletRequest.getPathInfo());
        }
        return receiver;
    }

    void addReceiver(MessageReceiver receiver) {
        this.receivers.putIfAbsent(this.getReceiverKey(receiver), receiver);
    }

    boolean removeReceiver(MessageReceiver receiver) {
        return this.receivers.remove(this.getReceiverKey(receiver), receiver);
    }

    protected String getReceiverKey(MessageReceiver receiver) {
        String key = receiver.getEndpoint().getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)key)) {
            key = "/";
        }
        return key;
    }

    protected void processHttpRequest(HttpServletRequest request, HttpServletResponse response, MessageReceiver receiver) throws Exception {
        ((JettyHttpMessageReceiver)receiver).processMessage(request, response);
    }
}

