/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.Whitespace;

public class XSLStylesheet
extends XSLModuleRoot {
    protected boolean mayContainParam(String attName) {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        this.processDefaultCollationAttribute();
        String inputTypeAnnotationsAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String val;
            String f = atts.getQName(a);
            if (f.equals("version") || f.equals("id") || f.equals("extension-element-prefixes") || f.equals("exclude-result-prefixes")) continue;
            if (f.equals("default-validation")) {
                val = Whitespace.trim(atts.getValue(a));
                this.defaultValidation = Validation.getCode(val);
                if (this.defaultValidation == -1 || this.defaultValidation == 1 || this.defaultValidation == 2) {
                    this.defaultValidation = 4;
                    this.compileError("Invalid value for default-validation attribute. Permitted values are (preserve, strip)", "XTSE0020");
                    continue;
                }
                if (this.isSchemaAware() || this.defaultValidation == 4) continue;
                this.defaultValidation = 4;
                this.compileError("default-validation='" + val + "' requires a schema-aware processor", "XTSE1660");
                continue;
            }
            if (f.equals("input-type-annotations")) {
                inputTypeAnnotationsAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("default-mode")) {
                if (!this.isXslt30Processor()) {
                    this.compileError("The @default-mode attribute requires XSLT 3.0");
                }
                if ("#unnamed".equals(val = Whitespace.trim(atts.getValue(a)))) continue;
                try {
                    this.defaultMode = this.makeQName(atts.getValue(a));
                    continue;
                }
                catch (NamespaceException err) {
                    throw new XPathException(err.getMessage(), "XTST0030");
                }
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.version == null && this.getParent().getNodeKind() == 9) {
            this.reportAbsence("version");
        }
        if (!(inputTypeAnnotationsAtt == null || inputTypeAnnotationsAtt.equals("strip") || inputTypeAnnotationsAtt.equals("preserve") || inputTypeAnnotationsAtt.equals("unspecified"))) {
            this.compileError("Invalid value for input-type-annotations attribute. Permitted values are (strip, preserve, unspecified)", "XTSE0020");
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo curr;
        if (this.validationError != null) {
            this.compileError(this.validationError);
        }
        if (this.getParent().getNodeKind() != 9) {
            this.compileError(this.getDisplayName() + " must be the outermost element", "XTSE0010");
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((curr = kids.next()) != null) {
            if (curr.getNodeKind() == 3 || curr instanceof StyleElement && ((StyleElement)curr).isDeclaration() || curr instanceof DataElement || !"http://www.w3.org/1999/XSL/Transform".equals(curr.getURI()) && !"".equals(curr.getURI()) || curr instanceof AbsentExtensionElement && ((StyleElement)curr).forwardsCompatibleModeIsEnabled()) continue;
            if ("http://www.w3.org/1999/XSL/Transform".equals(curr.getURI())) {
                ((StyleElement)curr).compileError("Element " + curr.getDisplayName() + " must not appear directly within " + this.getDisplayName(), "XTSE0010");
                continue;
            }
            ((StyleElement)curr).compileError("Element " + curr.getDisplayName() + " must not appear directly within " + this.getDisplayName() + " because it is not in a namespace", "XTSE0130");
        }
    }
}

