/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.drools.base.accumulators.JavaAccumulatorFunctionExecutor;
import org.drools.compiler.Dialect;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.rule.Accumulate;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.AccumulateBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.dialect.java.AbstractJavaRuleBuilder;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.parser.JavaLocalDeclarationDescr;
import org.drools.runtime.rule.AccumulateFunction;
import org.drools.spi.Accumulator;

public class JavaAccumulateBuilder
extends AbstractJavaRuleBuilder
implements AccumulateBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        AccumulateDescr accumDescr = (AccumulateDescr)descr;
        if (!accumDescr.hasValidInput()) {
            return null;
        }
        RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(accumDescr.getInput().getClass());
        RuleConditionElement source = builder.build(context, accumDescr.getInput());
        if (source == null) {
            return null;
        }
        Accumulate accumulate = null;
        if (accumDescr.isExternalFunction()) {
            JavaAnalysisResult analysis = (JavaAnalysisResult)context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getExpression(), new Map[]{context.getDeclarationResolver().getDeclarationClasses(context.getRule()), context.getPackageBuilder().getGlobals()});
            List<String>[] usedIdentifiers = analysis.getBoundIdentifiers();
            ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
            int size = usedIdentifiers[0].size();
            for (int i = 0; i < size; ++i) {
                tupleDeclarations.add(context.getDeclarationResolver().getDeclaration(context.getRule(), usedIdentifiers[0].get(i)));
            }
            Declaration[] previousDeclarations = tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]);
            String[] requiredGlobals = usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]);
            Declaration[] sourceDeclArr = source.getOuterDeclarations().values().toArray(new Declaration[0]);
            String className = "accumulateExpression" + context.getNextId();
            Map<String, Object> map = this.createVariableContext(className, accumDescr.getExpression(), context, previousDeclarations, sourceDeclArr, requiredGlobals);
            map.put("readLocalsFromTuple", accumDescr.isMultiPattern() ? Boolean.TRUE : Boolean.FALSE);
            AccumulateFunction function = context.getConfiguration().getAccumulateFunction(accumDescr.getFunctionIdentifier());
            JavaAccumulatorFunctionExecutor accumulator = new JavaAccumulatorFunctionExecutor(function);
            accumulate = new Accumulate(source, previousDeclarations, sourceDeclArr, (Accumulator)accumulator);
            JavaAccumulateBuilder.generatTemplates("returnValueMethod", "returnValueInvoker", context, className, map, accumulator, accumDescr);
        } else {
            String className = "Accumulate" + context.getNextId();
            accumDescr.setClassName(className);
            Map[] available = new Map[]{context.getDeclarationResolver().getDeclarationClasses(context.getRule()), context.getPackageBuilder().getGlobals()};
            JavaAnalysisResult initCodeAnalysis = (JavaAnalysisResult)context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getInitCode(), available);
            Dialect.AnalysisResult actionCodeAnalysis = context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getActionCode(), available);
            Dialect.AnalysisResult resultCodeAnalysis = context.getDialect().analyzeExpression(context, accumDescr, accumDescr.getResultCode(), available);
            HashSet<String> requiredDeclarations = new HashSet<String>(initCodeAnalysis.getBoundIdentifiers()[0]);
            requiredDeclarations.addAll(actionCodeAnalysis.getBoundIdentifiers()[0]);
            requiredDeclarations.addAll(resultCodeAnalysis.getBoundIdentifiers()[0]);
            HashSet<String> requiredGlobals = new HashSet<String>(initCodeAnalysis.getBoundIdentifiers()[1]);
            requiredGlobals.addAll(actionCodeAnalysis.getBoundIdentifiers()[1]);
            requiredGlobals.addAll(resultCodeAnalysis.getBoundIdentifiers()[1]);
            if (accumDescr.getReverseCode() != null) {
                Dialect.AnalysisResult reverseCodeAnalysis = context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getActionCode(), available);
                requiredDeclarations.addAll(reverseCodeAnalysis.getBoundIdentifiers()[0]);
                requiredGlobals.addAll(reverseCodeAnalysis.getBoundIdentifiers()[1]);
            }
            Declaration[] declarations = new Declaration[requiredDeclarations.size()];
            int i = 0;
            Iterator it = requiredDeclarations.iterator();
            while (it.hasNext()) {
                declarations[i] = context.getDeclarationResolver().getDeclaration(context.getRule(), (String)it.next());
                ++i;
            }
            Declaration[] sourceDeclArr = source.getOuterDeclarations().values().toArray(new Declaration[0]);
            String[] globals = requiredGlobals.toArray(new String[requiredGlobals.size()]);
            Map<String, Object> map = this.createVariableContext(className, null, context, declarations, null, globals);
            map.put("className", accumDescr.getClassName());
            map.put("innerDeclarations", sourceDeclArr);
            map.put("isMultiPattern", accumDescr.isMultiPattern() ? Boolean.TRUE : Boolean.FALSE);
            String initCode = this.fixInitCode(initCodeAnalysis, accumDescr.getInitCode());
            String actionCode = accumDescr.getActionCode();
            String resultCode = accumDescr.getResultCode();
            String[] attributesTypes = new String[initCodeAnalysis.getLocalVariablesMap().size()];
            String[] attributes = new String[initCodeAnalysis.getLocalVariablesMap().size()];
            int index = 0;
            for (Map.Entry<String, JavaLocalDeclarationDescr> entry : initCodeAnalysis.getLocalVariablesMap().entrySet()) {
                attributes[index] = entry.getKey();
                attributesTypes[index] = entry.getValue().getType();
                ++index;
            }
            map.put("attributes", attributes);
            map.put("attributesTypes", attributesTypes);
            map.put("initCode", initCode);
            map.put("actionCode", actionCode);
            map.put("resultCode", resultCode);
            if (accumDescr.getReverseCode() == null) {
                map.put("reverseCode", "");
                map.put("supportsReverse", "false");
            } else {
                map.put("reverseCode", accumDescr.getReverseCode());
                map.put("supportsReverse", "true");
            }
            map.put("hashCode", new Integer(actionCode.hashCode()));
            accumulate = new Accumulate(source, declarations, sourceDeclArr);
            JavaAccumulateBuilder.generatTemplates("accumulateInnerClass", "accumulateInvoker", context, className, map, accumulate, accumDescr);
        }
        return accumulate;
    }

    protected String fixInitCode(JavaAnalysisResult analysis, String originalCode) {
        TreeSet<JavaLocalDeclarationDescr> locals = new TreeSet<JavaLocalDeclarationDescr>(new Comparator(){

            public int compare(Object o1, Object o2) {
                JavaLocalDeclarationDescr d1 = (JavaLocalDeclarationDescr)o1;
                JavaLocalDeclarationDescr d2 = (JavaLocalDeclarationDescr)o2;
                return d1.getStart() - d2.getStart();
            }
        });
        Iterator<JavaLocalDeclarationDescr> it = analysis.getLocalVariablesMap().values().iterator();
        while (it.hasNext()) {
            locals.add(it.next());
        }
        StringBuilder initCode = new StringBuilder();
        int lastAdded = 0;
        for (JavaLocalDeclarationDescr d : locals) {
            initCode.append(originalCode.substring(lastAdded, d.getStart()));
            lastAdded = d.getEnd();
            for (JavaLocalDeclarationDescr.IdentifierDescr id : d.getIdentifiers()) {
                initCode.append(originalCode.substring(id.getStart(), id.getEnd()));
                initCode.append(";");
                for (lastAdded = id.getEnd(); lastAdded < originalCode.length() && (Character.isWhitespace(originalCode.charAt(lastAdded)) || originalCode.charAt(lastAdded) == ';'); ++lastAdded) {
                }
            }
        }
        initCode.append(originalCode.substring(lastAdded));
        return initCode.toString();
    }
}

