/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.DefaultMuleEvent;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NonBlockingSupported;
import org.mule.api.transport.ReplyToHandler;
import org.mule.processor.AbstractInterceptingMessageProcessor;

public abstract class AbstractRequestResponseMessageProcessor
extends AbstractInterceptingMessageProcessor
implements NonBlockingSupported {
    @Override
    public final MuleEvent process(MuleEvent event) throws MuleException {
        if (this.isNonBlocking(event)) {
            return this.processNonBlocking(event);
        }
        return this.processBlocking(event);
    }

    protected MuleEvent processBlocking(MuleEvent event) throws MuleException {
        MessagingException exception = null;
        try {
            MuleEvent muleEvent = this.processResponse(this.processNext(this.processRequest(event)), event);
            return muleEvent;
        }
        catch (MessagingException e) {
            exception = e;
            throw e;
        }
        finally {
            this.processFinally(event, exception);
        }
    }

    protected MuleEvent processNonBlocking(MuleEvent event) throws MuleException {
        event = new DefaultMuleEvent(event, this.createReplyToHandler(event));
        event = OptimizedRequestContext.unsafeSetEvent(event);
        try {
            MuleEvent result = this.processNext(this.processRequest(event));
            if (!(result instanceof NonBlockingVoidMuleEvent)) {
                MuleEvent after = this.processResponse(result, event);
                this.processFinally(after, null);
                return after;
            }
            return result;
        }
        catch (MessagingException exception) {
            this.processFinally(event, exception);
            throw exception;
        }
    }

    protected ReplyToHandler createReplyToHandler(final MuleEvent request) {
        final ReplyToHandler originalReplyToHandler = request.getReplyToHandler();
        return new ReplyToHandler(){

            @Override
            public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
                MuleEvent response = AbstractRequestResponseMessageProcessor.this.processResponse(AbstractRequestResponseMessageProcessor.this.recreateEventWithOriginalReplyToHandler(event, originalReplyToHandler), request);
                if (!NonBlockingVoidMuleEvent.getInstance().equals(response)) {
                    originalReplyToHandler.processReplyTo(response, null, null);
                }
                AbstractRequestResponseMessageProcessor.this.processFinally(event, null);
            }

            @Override
            public void processExceptionReplyTo(MessagingException exception, Object replyTo) {
                originalReplyToHandler.processExceptionReplyTo(exception, replyTo);
                AbstractRequestResponseMessageProcessor.this.processFinally(exception.getEvent(), exception);
            }
        };
    }

    private MuleEvent recreateEventWithOriginalReplyToHandler(MuleEvent event, ReplyToHandler originalReplyToHandler) {
        if (event != null) {
            event = new DefaultMuleEvent(event, originalReplyToHandler);
            OptimizedRequestContext.unsafeSetEvent(event);
        }
        return event;
    }

    private boolean isNonBlocking(MuleEvent event) {
        return event.isAllowNonBlocking() && event.getReplyToHandler() != null && this.next != null;
    }

    protected MuleEvent processRequest(MuleEvent request) throws MuleException {
        return request;
    }

    protected MuleEvent processResponse(MuleEvent response, MuleEvent request) throws MuleException {
        return this.processResponse(response);
    }

    @Deprecated
    protected MuleEvent processResponse(MuleEvent response) throws MuleException {
        return response;
    }

    protected void processFinally(MuleEvent event, MessagingException exception) {
    }
}

