/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.Serializable;
import org.apache.commons.collections.Factory;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.registry.RegistrationException;
import org.mule.api.routing.Aggregator;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.service.Service;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.api.store.PartitionableObjectStore;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.routing.correlation.EventCorrelator;
import org.mule.routing.correlation.EventCorrelatorCallback;
import org.mule.util.concurrent.ThreadNameHelper;
import org.mule.util.store.DefaultObjectStoreFactoryBean;
import org.mule.util.store.ProvidedObjectStoreWrapper;
import org.mule.util.store.ProvidedPartitionableObjectStoreWrapper;

public abstract class AbstractAggregator
extends AbstractInterceptingMessageProcessor
implements Initialisable,
MuleContextAware,
FlowConstructAware,
Aggregator,
Startable,
Stoppable,
Disposable {
    public static final int MAX_PROCESSED_GROUPS = 50000;
    public static final String EVENTS_STORE_REGISTRY_KEY_PREFIX = "aggregator.eventsObjectStore.";
    protected EventCorrelator eventCorrelator;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    protected MessageInfoMapping messageInfoMapping;
    private long timeout = 0L;
    private boolean failOnTimeout = true;
    private ObjectStore<Long> processedGroupsObjectStore;
    private PartitionableObjectStore eventGroupsObjectStore;
    protected boolean persistentStores;
    protected String storePrefix = null;
    protected String eventsObjectStoreKey;

    @Override
    public void initialise() throws InitialisationException {
        Service service;
        if (this.messageInfoMapping == null) {
            this.messageInfoMapping = this.flowConstruct.getMessageInfoMapping();
        }
        if (this.storePrefix == null) {
            this.storePrefix = String.format("%s%s.%s.", ThreadNameHelper.getPrefix(this.muleContext), this.flowConstruct.getName(), this.getClass().getName());
        }
        this.initProcessedGroupsObjectStore();
        this.initEventGroupsObjectStore();
        this.eventCorrelator = new EventCorrelator(this.getCorrelatorCallback(this.muleContext), this.next, this.messageInfoMapping, this.muleContext, this.flowConstruct, this.eventGroupsObjectStore, this.storePrefix, this.processedGroupsObjectStore);
        if (this.flowConstruct instanceof Service && (service = (Service)this.flowConstruct).getAsyncReplyMessageSource().getMessageProcessors().contains(this)) {
            this.failOnTimeout = service.getAsyncReplyMessageSource().isFailOnTimeout();
        }
        this.eventCorrelator.setTimeout(this.timeout);
        this.eventCorrelator.setFailOnTimeout(this.isFailOnTimeout());
    }

    protected void initProcessedGroupsObjectStore() {
        if (this.processedGroupsObjectStore == null) {
            this.processedGroupsObjectStore = new ProvidedObjectStoreWrapper<Long>(null, this.internalProcessedGroupsObjectStoreFactory());
        }
    }

    protected Factory internalProcessedGroupsObjectStoreFactory() {
        return new Factory(){

            public Object create() {
                ObjectStoreManager objectStoreManager = (ObjectStoreManager)AbstractAggregator.this.muleContext.getRegistry().get("_muleObjectStoreManager");
                return objectStoreManager.getObjectStore(AbstractAggregator.this.storePrefix + ".processedGroups", AbstractAggregator.this.persistentStores, 50000, -1, 1000);
            }
        };
    }

    protected void initEventGroupsObjectStore() throws InitialisationException {
        try {
            if (this.eventGroupsObjectStore == null) {
                this.eventGroupsObjectStore = new ProvidedPartitionableObjectStoreWrapper(null, this.internalEventsGroupsObjectStoreFactory());
            }
            this.eventGroupsObjectStore.open(this.storePrefix + ".expiredAndDispatchedGroups");
            this.eventGroupsObjectStore.open(this.storePrefix + ".eventGroups");
        }
        catch (MuleRuntimeException | ObjectStoreException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected Factory internalEventsGroupsObjectStoreFactory() {
        return new Factory(){

            public Object create() {
                try {
                    ObjectStore<Serializable> objectStore;
                    if (AbstractAggregator.this.persistentStores) {
                        AbstractAggregator.this.muleContext.getRegistry().lookupObject(DefaultObjectStoreFactoryBean.class);
                        objectStore = DefaultObjectStoreFactoryBean.createDefaultPersistentObjectStore();
                    } else {
                        AbstractAggregator.this.muleContext.getRegistry().lookupObject(DefaultObjectStoreFactoryBean.class);
                        objectStore = DefaultObjectStoreFactoryBean.createDefaultInMemoryObjectStore();
                    }
                    if (objectStore instanceof MuleContextAware) {
                        ((MuleContextAware)((Object)objectStore)).setMuleContext(AbstractAggregator.this.muleContext);
                    }
                    return objectStore;
                }
                catch (RegistrationException e) {
                    throw new MuleRuntimeException(e);
                }
            }
        };
    }

    @Override
    public void start() throws MuleException {
        if (this.timeout != 0L) {
            this.eventCorrelator.start();
        }
    }

    @Override
    public void stop() throws MuleException {
        this.eventCorrelator.stop();
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    protected abstract EventCorrelatorCallback getCorrelatorCallback(MuleContext var1);

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleEvent result = this.eventCorrelator.process(event);
        if (result == null || VoidMuleEvent.getInstance().equals(result)) {
            return result;
        }
        return this.processNext(result);
    }

    @Override
    public void expireAggregation(String groupId) throws MessagingException {
        this.eventCorrelator.forceGroupExpiry(groupId);
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    @Override
    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public void setMessageInfoMapping(MessageInfoMapping messageInfoMapping) {
        this.messageInfoMapping = messageInfoMapping;
    }

    public void setProcessedGroupsObjectStore(ObjectStore<Long> processedGroupsObjectStore) {
        this.processedGroupsObjectStore = new ProvidedObjectStoreWrapper<Long>(processedGroupsObjectStore, this.internalProcessedGroupsObjectStoreFactory());
    }

    public void setEventGroupsObjectStore(PartitionableObjectStore<MuleEvent> eventGroupsObjectStore) {
        this.eventGroupsObjectStore = new ProvidedPartitionableObjectStoreWrapper<MuleEvent>(eventGroupsObjectStore, this.internalEventsGroupsObjectStoreFactory());
    }

    public boolean isPersistentStores() {
        return this.persistentStores;
    }

    public void setPersistentStores(boolean persistentStores) {
        this.persistentStores = persistentStores;
    }

    public String getStorePrefix() {
        return this.storePrefix;
    }

    public void setStorePrefix(String storePrefix) {
        this.storePrefix = storePrefix;
    }

    @Override
    public void dispose() {
        this.disposeIfDisposable(this.processedGroupsObjectStore);
        this.disposeIfDisposable(this.eventGroupsObjectStore);
        this.eventCorrelator.dispose();
    }

    private void disposeIfDisposable(ObjectStore objectStore) {
        if (objectStore != null && objectStore instanceof Disposable) {
            ((Disposable)((Object)objectStore)).dispose();
        }
    }
}

