/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import javax.activation.DataHandler;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.AttributeEvaluator;
import org.mule.util.WildcardAttributeEvaluator;

public class CopyAttachmentsTransformer
extends AbstractMessageTransformer {
    private AttributeEvaluator attachmentNameEvaluator;
    private WildcardAttributeEvaluator wildcardAttachmentNameEvaluator;

    public CopyAttachmentsTransformer() {
        this.registerSourceType(DataTypeFactory.OBJECT);
        this.setReturnDataType(DataTypeFactory.OBJECT);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.attachmentNameEvaluator.initialize(this.muleContext.getExpressionManager());
    }

    @Override
    public Object transformMessage(final MuleMessage message, String outputEncoding) throws TransformerException {
        block5: {
            try {
                if (this.wildcardAttachmentNameEvaluator.hasWildcards()) {
                    try {
                        this.wildcardAttachmentNameEvaluator.processValues(message.getInboundAttachmentNames(), new WildcardAttributeEvaluator.MatchCallback(){

                            @Override
                            public void processMatch(String matchedValue) {
                                try {
                                    message.addOutboundAttachment(matchedValue, message.getInboundAttachment(matchedValue));
                                }
                                catch (Exception e) {
                                    throw new MuleRuntimeException(e);
                                }
                            }
                        });
                        break block5;
                    }
                    catch (Exception e) {
                        throw new TransformerException(this, (Throwable)e);
                    }
                }
                String attachmentName = this.attachmentNameEvaluator.resolveValue(message).toString();
                DataHandler inboundAttachment = message.getInboundAttachment(attachmentName);
                message.addOutboundAttachment(attachmentName, inboundAttachment);
            }
            catch (Exception e) {
                throw new TransformerException(this, (Throwable)e);
            }
        }
        return message;
    }

    public Object clone() throws CloneNotSupportedException {
        CopyAttachmentsTransformer clone = (CopyAttachmentsTransformer)super.clone();
        clone.setAttachmentName(this.attachmentNameEvaluator.getRawValue());
        return clone;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentNameEvaluator = new AttributeEvaluator(attachmentName);
        this.wildcardAttachmentNameEvaluator = new WildcardAttributeEvaluator(attachmentName);
    }
}

