/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Cookie;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;

public class MuleHttpServletResponse
implements HttpServletResponse {
    private static String[] DAYS = new String[]{"Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"};
    private MuleEvent event;
    private MuleMessage message;

    public MuleHttpServletResponse(MuleEvent event) {
        this.event = event;
        this.message = event.getMessage();
    }

    public String getCharacterEncoding() {
        return this.event.getEncoding();
    }

    public String getContentType() {
        return (String)this.message.getOutboundProperty("Content-Type");
    }

    public ServletOutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public PrintWriter getWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setCharacterEncoding(String charset) {
        this.message.setEncoding(charset);
    }

    public void setContentLength(int len) {
        throw new UnsupportedOperationException();
    }

    public void setContentType(String type) {
        this.message.setProperty("Content-Type", (Object)type, PropertyScope.OUTBOUND);
    }

    public void setBufferSize(int size) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void setLocale(Locale loc) {
    }

    public Locale getLocale() {
        return null;
    }

    public void addCookie(javax.servlet.http.Cookie cookie) {
        Cookie internal = this.toHttpClientCookie(cookie);
        Cookie[] internalCookies = (Cookie[])this.message.getOutboundProperty("cookies");
        if (internalCookies == null) {
            internalCookies = new Cookie[]{internal};
        } else {
            ArrayList<Cookie> list = new ArrayList<Cookie>(Arrays.asList(internalCookies));
            list.add(internal);
            internalCookies = list.toArray(new Cookie[list.size()]);
        }
        this.message.setOutboundProperty("cookies", (Object)internalCookies);
    }

    private Cookie toHttpClientCookie(javax.servlet.http.Cookie cookie) {
        Cookie internal = new Cookie();
        internal.setName(cookie.getName());
        internal.setValue(cookie.getValue());
        internal.setComment(cookie.getComment());
        internal.setDomain(cookie.getDomain());
        internal.setPath(cookie.getPath());
        internal.setVersion(cookie.getVersion());
        return internal;
    }

    public boolean containsHeader(String name) {
        return this.message.getOutboundProperty(name) != null;
    }

    public String encodeURL(String url) {
        return null;
    }

    public String encodeRedirectURL(String url) {
        return null;
    }

    public String encodeUrl(String url) {
        return null;
    }

    public String encodeRedirectUrl(String url) {
        return null;
    }

    public void sendError(int sc, String msg) throws IOException {
    }

    public void sendError(int sc) throws IOException {
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    public void setDateHeader(String name, long date) {
        StringBuilder buf = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date);
        MuleHttpServletResponse.formatDate(buf, calendar, false);
        this.message.setOutboundProperty(name, (Object)buf.toString());
    }

    public void addDateHeader(String name, long date) {
        this.setDateHeader(name, date);
    }

    public static void formatDate(StringBuilder buf, Calendar calendar, boolean cookie) {
        int day_of_week = calendar.get(7);
        int day_of_month = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1);
        int century = year / 100;
        year %= 100;
        int epoch = (int)(calendar.getTimeInMillis() / 1000L % 86400L);
        int seconds = epoch % 60;
        int minutes = (epoch /= 60) % 60;
        int hours = epoch / 60;
        buf.append(DAYS[day_of_week]);
        buf.append(',');
        buf.append(' ');
        MuleHttpServletResponse.append2digits(buf, day_of_month);
        if (cookie) {
            buf.append('-');
            buf.append(MONTHS[month]);
            buf.append('-');
            MuleHttpServletResponse.append2digits(buf, century);
            MuleHttpServletResponse.append2digits(buf, year);
        } else {
            buf.append(' ');
            buf.append(MONTHS[month]);
            buf.append(' ');
            MuleHttpServletResponse.append2digits(buf, century);
            MuleHttpServletResponse.append2digits(buf, year);
        }
        buf.append(' ');
        MuleHttpServletResponse.append2digits(buf, hours);
        buf.append(':');
        MuleHttpServletResponse.append2digits(buf, minutes);
        buf.append(':');
        MuleHttpServletResponse.append2digits(buf, seconds);
        buf.append(" GMT");
    }

    public static void append2digits(StringBuilder buf, int i) {
        if (i >= 100) {
            return;
        }
        buf.append((char)(i / 10 + 48));
        buf.append((char)(i % 10 + 48));
    }

    public void setHeader(String name, String value) {
        this.message.setOutboundProperty(name, (Object)value);
    }

    public void addHeader(String name, String value) {
        this.message.setOutboundProperty(name, (Object)value);
    }

    public void setIntHeader(String name, int value) {
        this.message.setOutboundProperty("http.status", (Object)value);
    }

    public void addIntHeader(String name, int value) {
        this.message.setOutboundProperty("http.status", (Object)value);
    }

    public void setStatus(int sc) {
        this.message.setOutboundProperty("http.status", (Object)sc);
    }

    public void setStatus(int sc, String sm) {
        this.message.setOutboundProperty("http.status", (Object)sc);
    }

    public Collection<String> getHeaderNames() {
        return null;
    }

    public int getStatus() {
        return 0;
    }

    public Collection<String> getHeaders(String s) {
        return null;
    }

    public String getHeader(String s) {
        return null;
    }
}

