/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import java.util.ArrayList;
import java.util.List;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Packet;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractConnector;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.AbstractReceiverWorker;
import org.mule.transport.xmpp.XmppConnector;
import org.mule.transport.xmpp.XmppConversation;

public class XmppMessageReceiver
extends AbstractMessageReceiver
implements PacketListener {
    private XmppConversation xmppConversation;

    public XmppMessageReceiver(AbstractConnector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super((Connector)connector, flowConstruct, endpoint);
        XmppConnector xmppConnector = (XmppConnector)connector;
        this.xmppConversation = xmppConnector.getConversationFactory().create((ImmutableEndpoint)endpoint);
    }

    protected void doConnect() throws Exception {
        this.xmppConversation.connect(false);
    }

    protected void doDisconnect() throws Exception {
        this.xmppConversation.disconnect();
    }

    protected void doStart() throws MuleException {
        this.xmppConversation.addPacketListener(this);
    }

    protected void doStop() throws MuleException {
        super.doStop();
        this.xmppConversation.removePacketListener(this);
    }

    protected void doDispose() {
        this.xmppConversation = null;
    }

    protected Work createWork(Packet packet) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(packet);
        return new XMPPWorker(list, this);
    }

    public void processPacket(Packet packet) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("processing packet: " + packet.toXML()));
        }
        try {
            Work work = this.createWork(packet);
            this.getWorkManager().scheduleWork(work, Long.MAX_VALUE, null, (WorkListener)this.connector);
        }
        catch (WorkException e) {
            this.logger.error((Object)("XMPP message receiver work failed: " + e.getMessage()), (Throwable)e);
        }
    }

    private class XMPPWorker
    extends AbstractReceiverWorker {
        public XMPPWorker(List<Object> packets, AbstractMessageReceiver receiver) {
            super(packets, receiver);
        }

        protected void bindTransaction(Transaction tx) throws TransactionException {
        }
    }
}

