/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.chain;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleEvent;
import org.mule.api.processor.ProcessorExecutor;
import org.mule.api.service.Service;
import org.mule.api.transport.ReplyToHandler;
import org.mule.construct.Flow;
import org.mule.processor.BlockingProcessorExecutor;
import org.mule.processor.NonBlockingProcessorExecutor;
import org.mule.processor.chain.ProcessorExecutorFactory;
import org.mule.service.processor.ServiceProcessorExecutor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class ProcessorExecutorFactoryTestCase
extends AbstractMuleTestCase {
    @Mock
    private MuleEvent muleEvent;

    @Test
    public void service() {
        Mockito.when((Object)this.muleEvent.getFlowConstruct()).thenReturn(Mockito.mock(Service.class));
        Assert.assertThat(this.createProcessorExecutor().getClass(), (Matcher)CoreMatchers.equalTo(ServiceProcessorExecutor.class));
    }

    @Test
    public void flow() {
        Mockito.when((Object)this.muleEvent.getFlowConstruct()).thenReturn(Mockito.mock(Flow.class));
        Mockito.when((Object)this.muleEvent.isAllowNonBlocking()).thenReturn((Object)false);
        Assert.assertThat(this.createProcessorExecutor().getClass(), (Matcher)CoreMatchers.equalTo(BlockingProcessorExecutor.class));
    }

    @Test
    public void flowReplyHandler() {
        Mockito.when((Object)this.muleEvent.getFlowConstruct()).thenReturn(Mockito.mock(Flow.class));
        Mockito.when((Object)this.muleEvent.isAllowNonBlocking()).thenReturn((Object)false);
        Mockito.when((Object)this.muleEvent.getReplyToHandler()).thenReturn(Mockito.mock(ReplyToHandler.class));
        Assert.assertThat(this.createProcessorExecutor().getClass(), (Matcher)CoreMatchers.equalTo(BlockingProcessorExecutor.class));
    }

    @Test
    public void flowNonBlockingAllowed() {
        Mockito.when((Object)this.muleEvent.getFlowConstruct()).thenReturn(Mockito.mock(Flow.class));
        Mockito.when((Object)this.muleEvent.isAllowNonBlocking()).thenReturn((Object)true);
        Assert.assertThat(this.createProcessorExecutor().getClass(), (Matcher)CoreMatchers.equalTo(BlockingProcessorExecutor.class));
    }

    @Test
    public void flowNonBlockingAllowedReplyHandler() {
        Mockito.when((Object)this.muleEvent.getFlowConstruct()).thenReturn(Mockito.mock(Flow.class));
        Mockito.when((Object)this.muleEvent.isAllowNonBlocking()).thenReturn((Object)true);
        Mockito.when((Object)this.muleEvent.getReplyToHandler()).thenReturn(Mockito.mock(ReplyToHandler.class));
        Assert.assertThat(this.createProcessorExecutor().getClass(), (Matcher)CoreMatchers.equalTo(NonBlockingProcessorExecutor.class));
    }

    private ProcessorExecutor createProcessorExecutor() {
        return new ProcessorExecutorFactory().createProcessorExecutor(this.muleEvent, null, null, false);
    }
}

