/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.correlation;

import org.junit.Test;
import org.mule.routing.EventProcessingThread;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.size.SmallTest;

@SmallTest
public class EventProcessingThreadTestCase
extends AbstractMuleTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void survivesProcessRuntimeExceptions() {
        final TestEventProcessingThread processingThread = new TestEventProcessingThread("testEventProcessingThread", 1L);
        try {
            processingThread.start();
            PollingProber prober = new PollingProber(100L, 1L);
            prober.check(new Probe(){

                @Override
                public boolean isSatisfied() {
                    return processingThread.count > 1;
                }

                @Override
                public String describeFailure() {
                    return "Expected more than one invocation of the thread processing method";
                }
            });
        }
        finally {
            processingThread.interrupt();
        }
    }

    private static class TestEventProcessingThread
    extends EventProcessingThread {
        volatile int count;

        public TestEventProcessingThread(String name, long delayTime) {
            super(name, delayTime);
        }

        protected void doRun() {
            ++this.count;
            throw new RuntimeException();
        }
    }
}

