/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.RoutingException;
import org.mule.routing.outbound.EndpointSelector;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.tck.MuleEventCheckAnswer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class EndpointSelectorTestCase
extends AbstractMuleContextTestCase {
    private MuleSession session;
    private OutboundEndpoint dest1;
    private OutboundEndpoint dest2;
    private OutboundEndpoint dest3;
    private EndpointSelector router;
    private OutboundEndpoint mockEndpoint1;
    private OutboundEndpoint mockEndpoint2;
    private OutboundEndpoint mockEndpoint3;

    public EndpointSelectorTestCase() {
        this.setStartContext(true);
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.session = (MuleSession)Mockito.mock(MuleSession.class);
        this.dest1 = EndpointSelectorTestCase.getTestOutboundEndpoint("dest1");
        this.dest2 = EndpointSelectorTestCase.getTestOutboundEndpoint("dest2");
        this.dest3 = EndpointSelectorTestCase.getTestOutboundEndpoint("dest3");
        this.mockEndpoint1 = RouterTestUtils.createMockEndpoint(this.dest1);
        this.mockEndpoint2 = RouterTestUtils.createMockEndpoint(this.dest2);
        this.mockEndpoint3 = RouterTestUtils.createMockEndpoint(this.dest3);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(this.mockEndpoint1);
        endpoints.add(this.mockEndpoint2);
        endpoints.add(this.mockEndpoint3);
        this.router = new EndpointSelector();
        this.router.setRoutes(endpoints);
        this.router.setMuleContext(muleContext);
        this.router.initialise();
    }

    @Test
    public void testSelectEndpointDefaultProperty() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("apple", "red");
        props.put("endpoint", "dest3");
        props.put("banana", "yellow");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", props, muleContext);
        Assert.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        Mockito.when((Object)this.mockEndpoint3.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext));
    }

    @Test
    public void testSelectEndpointCustomProperty() throws Exception {
        this.router.setExpression("wayOut");
        this.router.setEvaluator("header");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("apple", "red");
        props.put("wayOut", "dest2");
        props.put("banana", "yellow");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", props, muleContext);
        Assert.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        Mockito.when((Object)this.mockEndpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext));
    }

    @Test
    public void testSelectEndpointNoMatch() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("endpoint", "dest5");
        try {
            DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", props, muleContext);
            this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext));
            Assert.fail((String)"Router should have thrown an exception if endpoint was not found.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSelectEndpointNoMatchUseDefault() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        this.router.setDefaultEndpointName("dest3");
        Assert.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        Mockito.when((Object)this.mockEndpoint3.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext));
    }

    @Test
    public void testSelectEndpointNoPropertySet() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        try {
            this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext));
            Assert.fail((String)"Router should have thrown an exception if no selector property was set on the message.");
        }
        catch (RoutingException routingException) {
            // empty catch block
        }
    }
}

