/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.matcher;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.api.debug.SimpleFieldDebugInfo;

public class FieldDebugInfoMatcher
extends TypeSafeMatcher<FieldDebugInfo<?>> {
    private final String name;
    private final String type;
    private final Matcher matcher;

    public FieldDebugInfoMatcher(String name, Class type, Object value) {
        this.name = name;
        this.type = type.getName();
        this.matcher = Matchers.equalTo((Object)value);
    }

    public FieldDebugInfoMatcher(String name, Class type, Matcher matcher) {
        this.name = name;
        this.type = type.getName();
        this.matcher = matcher;
    }

    public boolean matchesSafely(FieldDebugInfo<?> item) {
        boolean sameValue = this.matcher.matches(item.getValue());
        return this.name.equals(item.getName()) && sameValue && this.type.equals(item.getType());
    }

    public void describeTo(Description description) {
        description.appendText(String.format("a %s with name: '%s' type: '%s' and value that is ", SimpleFieldDebugInfo.class.getSimpleName(), this.name, this.type));
        this.matcher.describeTo(description);
    }

    @Factory
    public static Matcher<FieldDebugInfo<?>> fieldLike(String name, Class type, Object value) {
        return new FieldDebugInfoMatcher(name, type, value);
    }

    @Factory
    public static Matcher<FieldDebugInfo<?>> fieldLike(String name, Class type, Matcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("Matcher cannot be null");
        }
        return new FieldDebugInfoMatcher(name, type, matcher);
    }
}

