/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.ConcurrentWorkTracker;

@SmallTest
public class ConcurrentWorkTrackerTestCase
extends AbstractMuleTestCase {
    private ConcurrentWorkTracker workTracker = new ConcurrentWorkTracker();

    @Test
    public void addsWork() {
        Runnable work = (Runnable)Mockito.mock(Runnable.class);
        this.workTracker.addWork(work);
        Assert.assertThat((Object)this.workTracker.pendingWorks(), (Matcher)IsCollectionContaining.hasItem((Object)work));
    }

    @Test
    public void removesWork() {
        Runnable work = (Runnable)Mockito.mock(Runnable.class);
        this.workTracker.addWork(work);
        this.workTracker.removeWork(work);
        Assert.assertThat((Object)this.workTracker.pendingWorks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)work)));
    }

    @Test
    public void cleansUpPendingWorksOnDispose() throws Exception {
        Runnable work = (Runnable)Mockito.mock(Runnable.class);
        this.workTracker.addWork(work);
        this.workTracker.dispose();
        Assert.assertThat((Object)this.workTracker.pendingWorks(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)work)));
    }
}

