/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;

public class MuleFoldersUtil {
    public static final String EXECUTION_FOLDER = ".mule";
    public static final String LIB_FOLDER = "lib";
    public static final String APPS_FOLDER = "apps";
    public static final String DOMAINS_FOLDER = "domains";
    public static final String PLUGINS_FOLDER = "plugins";
    public static final String USER_FOLDER = "user";

    private MuleFoldersUtil() {
    }

    public static File getMuleHomeFolder() {
        String muleHome = System.getProperty("mule.home", ".");
        return new File(muleHome);
    }

    public static File getAppsFolder() {
        return new File(MuleFoldersUtil.getMuleHomeFolder(), APPS_FOLDER);
    }

    public static File getDomainsFolder() {
        return new File(MuleFoldersUtil.getMuleHomeFolder(), DOMAINS_FOLDER);
    }

    public static File getAppFolder(String appName) {
        return new File(MuleFoldersUtil.getAppsFolder(), appName);
    }

    public static File getDomainFolder(String domainName) {
        return new File(MuleFoldersUtil.getDomainsFolder(), domainName);
    }

    public static File getAppLibFolder(String appName) {
        return new File(MuleFoldersUtil.getAppFolder(appName), LIB_FOLDER);
    }

    public static File getDomainLibFolder(String domainName) {
        return new File(MuleFoldersUtil.getDomainFolder(domainName), LIB_FOLDER);
    }

    public static File getAppPluginsFolder(String appName) {
        return new File(MuleFoldersUtil.getAppFolder(appName), PLUGINS_FOLDER);
    }

    public static File getAppSharedPluginLibsFolder(String appName) {
        return new File(MuleFoldersUtil.getAppPluginsFolder(appName), LIB_FOLDER);
    }

    public static File getExecutionFolder() {
        return new File(MuleFoldersUtil.getMuleHomeFolder(), EXECUTION_FOLDER);
    }

    public static File getMuleLibFolder() {
        return new File(MuleFoldersUtil.getMuleHomeFolder(), LIB_FOLDER);
    }

    public static File getUserLibFolder() {
        return new File(MuleFoldersUtil.getMuleLibFolder(), USER_FOLDER);
    }

    public static File getAppTempFolder(String appName) {
        return new File(MuleFoldersUtil.getExecutionFolder(), appName);
    }
}

