/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.descriptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.launcher.descriptor.DescriptorParser;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.PropertiesUtils;
import org.mule.util.StringUtils;

public class PropertiesDescriptorParser
implements DescriptorParser {
    public static final String PROPERTY_REDEPLOYMENT_ENABLED = "redeployment.enabled";
    public static final String PROPERTY_LOADER_OVERRIDE = "loader.override";
    protected static final String PROPERTY_ENCODING = "encoding";
    protected static final String PROPERTY_CONFIG_BUILDER = "config.builder";
    protected static final String PROPERTY_DOMAIN = "domain";
    protected static final String PROPERTY_CONFIG_RESOURCES = "config.resources";
    protected static final String PROPERTY_LOG_CONFIG_FILE = "log.configFile";
    protected static final String PROPERTY_SCAN_PACKAGES = "scan.packages";

    @Override
    public ApplicationDescriptor parse(File descriptor, String applicationName) throws IOException {
        String overrideString;
        Properties p = PropertiesUtils.loadProperties((InputStream)new FileInputStream(descriptor));
        ApplicationDescriptor d = new ApplicationDescriptor();
        d.setEncoding(p.getProperty(PROPERTY_ENCODING));
        d.setConfigurationBuilder(p.getProperty(PROPERTY_CONFIG_BUILDER));
        d.setDomain(p.getProperty(PROPERTY_DOMAIN));
        d.setPackagesToScan(p.getProperty(PROPERTY_SCAN_PACKAGES));
        String resProps = p.getProperty(PROPERTY_CONFIG_RESOURCES);
        String[] urls = StringUtils.isBlank((String)resProps) ? new String[]{"mule-config.xml"} : resProps.split(",");
        d.setConfigResources(urls);
        String[] absoluteResourcePaths = this.convertConfigResourcesToAbsolutePatch(urls, applicationName);
        d.setAbsoluteResourcePaths(absoluteResourcePaths);
        d.setConfigResourcesFile(this.convertConfigResourcesToFile(absoluteResourcePaths));
        d.setRedeploymentEnabled(BooleanUtils.toBoolean((String)p.getProperty(PROPERTY_REDEPLOYMENT_ENABLED, Boolean.TRUE.toString())));
        if (p.containsKey(PROPERTY_LOG_CONFIG_FILE)) {
            d.setLogConfigFile(new File(p.getProperty(PROPERTY_LOG_CONFIG_FILE)));
        }
        if (StringUtils.isNotBlank((String)(overrideString = p.getProperty(PROPERTY_LOADER_OVERRIDE)))) {
            HashSet<String> values = new HashSet<String>();
            String[] overrides = overrideString.split(",");
            Collections.addAll(values, overrides);
            d.setLoaderOverride(values);
        }
        return d;
    }

    private File[] convertConfigResourcesToFile(String[] absoluteResourcePaths) {
        File[] configResourcesFile = new File[absoluteResourcePaths.length];
        for (int i = 0; i < absoluteResourcePaths.length; ++i) {
            configResourcesFile[i] = new File(absoluteResourcePaths[i]);
        }
        return configResourcesFile;
    }

    private String[] convertConfigResourcesToAbsolutePatch(String[] configResources, String appName) {
        String[] absoluteResourcePaths = new String[configResources.length];
        for (int i = 0; i < configResources.length; ++i) {
            String resource = configResources[i];
            absoluteResourcePaths[i] = this.toAbsoluteFile(resource, appName);
        }
        return absoluteResourcePaths;
    }

    protected String toAbsoluteFile(String path, String appName) {
        return MuleContainerBootstrapUtils.getMuleAppDir((String)appName).getAbsolutePath() + File.separator + path;
    }

    @Override
    public String getSupportedFormat() {
        return "properties";
    }
}

