/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.ArrayHandler;

public class KeyedHandler
implements ResultSetHandler {
    protected final RowProcessor convert;
    protected final int columnIndex;
    protected final String columnName;

    public KeyedHandler() {
        this(ArrayHandler.ROW_PROCESSOR, 1, null);
    }

    public KeyedHandler(RowProcessor convert) {
        this(convert, 1, null);
    }

    public KeyedHandler(int columnIndex) {
        this(ArrayHandler.ROW_PROCESSOR, columnIndex, null);
    }

    public KeyedHandler(String columnName) {
        this(ArrayHandler.ROW_PROCESSOR, 1, columnName);
    }

    private KeyedHandler(RowProcessor convert, int columnIndex, String columnName) {
        this.convert = convert;
        this.columnIndex = columnIndex;
        this.columnName = columnName;
    }

    public Object handle(ResultSet rs) throws SQLException {
        Map result = this.createMap();
        while (rs.next()) {
            result.put(this.createKey(rs), this.createRow(rs));
        }
        return result;
    }

    protected Map createMap() {
        return new HashMap();
    }

    protected Object createKey(ResultSet rs) throws SQLException {
        return this.columnName == null ? rs.getObject(this.columnIndex) : rs.getObject(this.columnName);
    }

    protected Object createRow(ResultSet rs) throws SQLException {
        return this.convert.toMap(rs);
    }
}

